function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _superPropGet(t, e, o, r) { var p = _get(_getPrototypeOf(1 & r ? t.prototype : t), e, o); return 2 & r && "function" == typeof p ? function (t) { return p.apply(o, t); } : p; }
function _get() { return _get = "undefined" != typeof Reflect && Reflect.get ? Reflect.get.bind() : function (e, t, r) { var p = _superPropBase(e, t); if (p) { var n = Object.getOwnPropertyDescriptor(p, t); return n.get ? n.get.call(arguments.length < 3 ? e : r) : n.value; } }, _get.apply(null, arguments); }
function _superPropBase(t, o) { for (; !{}.hasOwnProperty.call(t, o) && null !== (t = _getPrototypeOf(t));); return t; }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2022 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/bacnet/rc/wb/mgr/export/BacnetExportUxManager
 * @since Niagara 4.14
 */

define(['baja!', 'baja!bacnet:IBacnetExportObject,control:ControlPoint', 'lex!workbench', 'Promise', 'underscore', 'nmodule/bacnet/rc/baja/datatypes/BacnetObjectIdentifier', 'nmodule/bacnet/rc/baja/enums/BacnetObjectType', 'nmodule/bacnet/rc/wb/mgr/commands/NewBacnetExportFolderCommand', 'nmodule/bacnet/rc/wb/mgr/export/BacnetExportPointLearn', 'nmodule/bacnet/rc/wb/mgr/export/BacnetExportUtil', 'nmodule/bacnet/rc/wb/mgr/model/BacnetExportModel', 'nmodule/bql/rc/builder/BqlQueryBuilder', 'nmodule/bql/rc/util/parseBql', 'nmodule/driver/rc/wb/mgr/DriverMgr', 'nmodule/driver/rc/wb/mgr/point/PointLearnModel', 'nmodule/webEditors/rc/fe/baja/util/compUtils', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/wb/mgr/commands/CancelDiscoverCommand', 'nmodule/webEditors/rc/wb/mgr/commands/NewFolderCommand', 'nmodule/webEditors/rc/wb/mgr/Manager', 'nmodule/webEditors/rc/wb/mgr/MgrLearn', 'nmodule/webEditors/rc/wb/mgr/MgrTypeInfo'], function (baja, types, lexs, Promise, _, BacnetObjectIdentifier, BacnetObjectType, NewBacnetExportFolderCommand, BacnetExportPointLearn, BacnetExportUtil, BacnetExportModel, BqlQueryBuilder, parseBql, DriverMgr, PointLearnModel, compUtils, feDialogs, CancelDiscoverCommand, NewFolderCommand, Manager, MgrLearnSupport, MgrTypeInfo) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    WB_LEX = _lexs[0];
  var toSelect = parseBql.toSelect;
  var COLUMNS = PointLearnModel.COLUMNS;
  var closest = compUtils.closest;
  var memoize = _.memoize;
  var getObjectOrd = BacnetExportUtil.getObjectOrd;
  var getExportAgents = memoize(function (typeSpec) {
    return baja.registry.getAgents('type:' + typeSpec, ['bacnet:IBacnetExportObject']);
  });
  function getBqlQuery(ordStr) {
    var bqlOrdParts = ordStr.match(/(\|bql:)|(bql:)/gi);
    var pieces = bqlOrdParts ? ordStr.split(bqlOrdParts[0]) : [ordStr];
    return pieces.length > 1 ? pieces[pieces.length - 1] : pieces[0];
  }
  function getBqlProjection() {
    var columns = COLUMNS.filter(function (column) {
      return column.getName() !== 'icon';
    }).map(function (column) {
      return column.getName();
    });
    columns.push('icon.encodeToString');
    return columns.join(', ');
  }
  function getDefaultBqlQuery() {
    return baja.Ord.make('bql:select ' + getBqlProjection() + ' from control:ControlPoint');
  }
  function getName(bacnetExportObject, instanceNumber) {
    var objectId = bacnetExportObject.getObjectId();
    var instance = instanceNumber || objectId.getInstanceNumber();
    return BacnetObjectType.tagForId(objectId.getObjectType()) + '_' + instance;
  }
  function toObjectName(fromPathString) {
    if (!fromPathString) {
      return '';
    }
    return baja.SlotPath.unescape(fromPathString.substring(1)).replaceAll('/', '.');
  }

  /**
   * @class
   * @alias module:nmodule/bacnet/rc/wb/mgr/export/BacnetExportUxManager
   * @extends module:nmodule/driver/rc/wb/mgr/DriverMgr
   */
  return /*#__PURE__*/function (_DriverMgr) {
    function BacnetExportUxManager(params) {
      var _this;
      _classCallCheck(this, BacnetExportUxManager);
      _this = _callSuper(this, BacnetExportUxManager, [Object.assign({
        moduleName: 'bacnet',
        keyName: 'BacnetExportUxManager',
        getComponentStatus: function getComponentStatus(c) {
          return baja.Status.getStatusFromIStatus(c);
        },
        editableTypes: [baja.lt('bacnet:IBacnetExportObject')],
        subscriptionDepth: 3,
        folderType: baja.lt('bacnet:BacnetExportFolder')
      }, params)]);
      MgrLearnSupport(_this);
      return _this;
    }

    /**
     * @param {baja.Component} exportContainer
     * @returns {Promise.<module:nmodule/bacnet/rc/wb/mgr/model/BacnetExportModel>}
     */
    _inherits(BacnetExportUxManager, _DriverMgr);
    return _createClass(BacnetExportUxManager, [{
      key: "makeModel",
      value: function makeModel(exportContainer) {
        return BacnetExportModel.make(exportContainer);
      }
    }, {
      key: "makeLearnModel",
      value: function makeLearnModel() {
        return PointLearnModel.make();
      }

      /**
       * Starts a discovery job. Pops open an instance of BqlQueryBuilder
       * editor rooted to the local config space.
       * 
       * @returns {Promise}
       */
    }, {
      key: "doDiscover",
      value: function doDiscover() {
        var _this2 = this;
        return feDialogs.showFor({
          title: WB_LEX.get('bqlQueryBuilder.queryBuilder'),
          type: BqlQueryBuilder,
          value: this.$bqlQuery || getDefaultBqlQuery(),
          formFactor: 'compact',
          properties: {
            hideProjection: true
          }
        }).then(function (bqlQuery) {
          if (!bqlQuery) {
            return;
          }
          if (bqlQuery) {
            var bqlQueryStr = String(bqlQuery);
            return toSelect(getBqlQuery(bqlQueryStr)).then(function (select) {
              var projection = select.get('projection'),
                projCol = projection && projection.get('ProjCol'),
                path = projCol && projCol.get('Path');
              if (String(path).equals('*')) {
                bqlQueryStr = bqlQueryStr.replace('*', getBqlProjection());
              }
              return _this2.$doBqlDiscover(bqlQueryStr, _this2.$getExportTable());
            });
          }
        });
      }

      /**
       * Filters IBacnetExportObjects registered as agents on the subject's type
       * @param {baja.Component} subject 
       * @returns {Promise.<Array.<MgrTypeInfo>>}
       */
    }, {
      key: "getTypesForDiscoverySubject",
      value: function getTypesForDiscoverySubject(subject) {
        var typeSpec = subject.get('type');
        return getExportAgents(typeSpec).then(function (types) {
          return MgrTypeInfo.make(types).then(function (mgrTypes) {
            mgrTypes.sort(MgrTypeInfo.BY_DISPLAY_NAME);
            return mgrTypes;
          });
        });
      }

      /**
       * 
       * @param {baja.Component} discovery 
       * @param {baja.Value} bacnetExportObject 
       * @returns {Object}
       */
    }, {
      key: "getProposedValuesFromDiscovery",
      value: function getProposedValuesFromDiscovery(discovery, bacnetExportObject) {
        return this.$getProposedInstanceNumber(bacnetExportObject).then(function (instanceNumber) {
          return {
            name: getName(bacnetExportObject),
            values: {
              objectOrd: baja.Ord.make('h:' + discovery.get('handle')),
              objectName: toObjectName(discovery.get('toPathString')),
              instanceNumber: baja.Integer.make(instanceNumber)
            }
          };
        });
      }
    }, {
      key: "newInstancesFromDiscoverySubjects",
      value: function newInstancesFromDiscoverySubjects(discoveries) {
        var _this3 = this;
        // objectTypeInstNumMap helps get the correct instance increment per objectType
        var objectTypeInstNumMap = {};
        return MgrLearnSupport.prototype.newInstancesFromDiscoverySubjects.apply(this, arguments).then(function (exportComps) {
          return Promise.all(exportComps.map(function (exportComp) {
            var objectType = exportComp.getObjectId().getObjectType();
            return _this3.$generateInstanceNumber(objectType).then(function (instanceNumber) {
              if (objectTypeInstNumMap.hasOwnProperty(objectType)) {
                objectTypeInstNumMap[objectType] = objectTypeInstNumMap[objectType] + 1;
              } else {
                objectTypeInstNumMap[objectType] = 0;
              }
              var increment = objectTypeInstNumMap[objectType];
              return exportComp.setObjectId(BacnetObjectIdentifier.make(objectType, instanceNumber + increment));
            }).then(function () {
              return exportComp;
            });
          }));
        });
      }

      /**
       * 
       * @param {baja.Component} discovery 
       * @param {baja.Value} exportObject 
       * @returns {boolean}
       */
    }, {
      key: "isExisting",
      value: function isExisting(discovery, exportObject) {
        var isHandlesMatch = function isHandlesMatch() {
          var objectOrd = getObjectOrd(exportObject);
          var handleOrd = baja.Ord.make({
            base: 'station:',
            child: 'h:' + discovery.get('handle')
          }).relativizeToSession();
          return handleOrd.equals(objectOrd);
        };
        var isSlotPathsMatch = function isSlotPathsMatch() {
          var objectOrd = getObjectOrd(exportObject);
          var absoluteOrd = baja.Ord.make({
            base: 'station:',
            child: new baja.SlotPath(discovery.get('toPathString'))
          }).relativizeToSession();
          return absoluteOrd.equals(objectOrd);
        };
        if (!baja.hasType(exportObject, 'bacnet:IBacnetExportObject')) {
          return false;
        }
        return isHandlesMatch() || isSlotPathsMatch();
      }
    }, {
      key: "makeCommands",
      value: function makeCommands() {
        var newFolderCmd = new NewBacnetExportFolderCommand(this);
        return _superPropGet(BacnetExportUxManager, "makeCommands", this, 3)([]).then(function (cmds) {
          return cmds.filter(function (cmd) {
            return !(cmd instanceof CancelDiscoverCommand);
          });
        }).then(function (cmds) {
          // Find and replace NewFolderCommand
          var index = cmds.findIndex(function (cmd) {
            return cmd instanceof NewFolderCommand;
          });
          cmds.splice(index, 1, newFolderCmd);
          return cmds;
        });
      }
    }, {
      key: "saveStateForOrd",
      value: function saveStateForOrd() {
        return this.$bqlResults ? {
          discoveryData: this.$bqlResults
        } : {};
      }
    }, {
      key: "restoreStateForOrd",
      value: function restoreStateForOrd(state) {
        var discoveryData = state.discoveryData;
        if (discoveryData) {
          this.$bqlResults = discoveryData;
          var bacnetPointLearn = new BacnetExportPointLearn(this.$bqlQuery, this.$getExportTable());
          return bacnetPointLearn.$updateTable(discoveryData.contents, this.getLearnModel());
        }
        this.$bqlResults = undefined;
        return Promise.resolve();
      }

      /**
       * @since Niagara 4.14
       * @param {*} learnSubject the subject selected in the learn table
       * @param {baja.Component} mainSubject the subject from the main table that the learn table
       * subject items is being matched to
       * @returns {Promise.<boolean>}
       */
    }, {
      key: "isMatchable",
      value: function isMatchable(learnSubject, mainSubject) {
        return getExportAgents(learnSubject.get('type')).then(function (types) {
          return types.some(function (_ref) {
            var typeSpec = _ref.typeSpec;
            return mainSubject.getType().getTypeSpec() === typeSpec;
          });
        });
      }

      /**
       * 'bacnet:BacnetExportFolder' is a BFolder but handled a little differently when 
       * compared with other Manager folders. Since it is also a bacnet:BIBacnetExportObject,
       * it is created like one and follows the same New/Edit paradigm like any other supported
       * BIBacnetExportObject.
       * 
       * @param {module:nmodule/webEditors/rc/wb/table/model/Column} column
       * @param {module:nmodule/webEditors/rc/wb/table/model/Row} row
       * @param {JQuery} dom
       * @returns {Promise|*}
       */
    }, {
      key: "buildMainTableCell",
      value: function buildMainTableCell(column, row, dom) {
        if (baja.hasType(row.getSubject(), 'bacnet:BacnetExportFolder')) {
          return Manager.prototype.buildMainTableCell.apply(this, [column, row, dom]);
        }
        return _superPropGet(BacnetExportUxManager, "buildMainTableCell", this, 3)(arguments);
      }

      /**
       * @private
       * @param {string} bqlQuery 
       * @param {baja.Component} exportTable 
       * @returns {Promise}
       */
    }, {
      key: "$doBqlDiscover",
      value: function $doBqlDiscover(bqlQuery, exportTable) {
        var _this4 = this;
        this.$bqlQuery = bqlQuery;
        var pointLearn = new BacnetExportPointLearn(bqlQuery, exportTable);
        return pointLearn.bqlDiscover({
          learnModel: this.getLearnModel()
        }).then(function (value) {
          // Store the discovery results for state handling
          _this4.$bqlResults = pointLearn.$bqlResults;
          return value;
        });
      }

      /**
      * Returns the export table for the current loaded component. As we may have a folder
      * loaded, this may be several levels up in the component tree.
      *
      * @private
      * @returns {baja.Component}
      */
    }, {
      key: "$getExportTable",
      value: function $getExportTable() {
        return closest(this.value(), 'bacnet:BacnetExportTable');
      }

      /**
       * @private
       * @param {module:nmodule/bacnet/rc/baja/enums/BacnetObjectType} objectType
       * @returns {Promise.<Number>}
       */
    }, {
      key: "$generateInstanceNumber",
      value: function $generateInstanceNumber(objectType) {
        var exportTable = this.$getExportTable();
        var getNextInst = memoize(function (objectType) {
          if (!exportTable) {
            return Promise.resolve(baja.Integer.DEFAULT);
          }
          return exportTable.invoke({
            slot: 'getNextInst',
            value: baja.$('bacnet:NextInstArgs', {
              objectType: objectType
            })
          });
        });
        return getNextInst(objectType);
      }

      /**
       * @private
       * @param {baja.Component} exportObject 
       * @return {Promise<baja.Integer>}
       */
    }, {
      key: "$getProposedInstanceNumber",
      value: function $getProposedInstanceNumber(exportObject) {
        var name = exportObject.getName();
        // If the export object is already in the database then this is most likely
        // called from a Match operation and the next available instance number needs to be looked up.
        if (name && this.$getExportTable().has(name)) {
          var objectType = exportObject.getObjectId().getObjectType();
          return this.$generateInstanceNumber(objectType);
        }
        // Otherwise the instance number is already looked up so just return it
        return Promise.resolve(exportObject.getObjectId().getInstanceNumber());
      }
    }]);
  }(DriverMgr);
});
