/**
 * @copyright 2022 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/bacnet/rc/wb/mgr/export/BacnetExportUtil
 * @since Niagara 4.14
 */

define(['baja!'], function (baja) {
  'use strict';

  var exports = {};

  /**
   * @param {baja.Component} exportComp 
   * @returns {baja.Ord}
   */
  exports.getObjectOrd = function (exportComp) {
    // TODO - NCCB-59639
    var objectOrd = baja.Ord.DEFAULT;
    var type = exportComp.getType();
    if (type.is('bacnet:BacnetPointDescriptor') && typeof exportComp.getPointOrd === 'function') {
      objectOrd = exportComp.getPointOrd();
    } else if (type.is('bacnet:BacnetScheduleDescriptor') && typeof exportComp.getScheduleOrd === 'function') {
      objectOrd = exportComp.getScheduleOrd();
    } else if (type.is('bacnet:BacnetCalendarDescriptor') && typeof exportComp.getCalendarOrd === 'function') {
      objectOrd = exportComp.getCalendarOrd();
    } else if (type.is('bacnet:BacnetEventEnrollmentDescriptor') && typeof exportComp.getEventEnrollmentOrd === 'function') {
      objectOrd = exportComp.getEventEnrollmentOrd();
    } else if (type.is('bacnet:BacnetNotificationClassDescriptor') && typeof exportComp.getAlarmClassOrd === 'function') {
      objectOrd = exportComp.getAlarmClassOrd();
    }
    return baja.Ord.make({
      base: 'station:',
      child: objectOrd
    }).normalize();
  };
  return exports;
});
