function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/bacnet/rc/wb/mgr/commands/WhoHasCommand
 */
define(['baja!', 'lex!bacnet', 'Promise', 'underscore', 'dialogs', 'bajaux/commands/Command', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/wb/mgr/commands/MgrCommand', 'baja!bacnet:WhoHasConfig'], function (baja, lexs, Promise, _, dialogs, Command, feDialogs, MgrCommand) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    bacnetLex = _lexs[0];
  var ALL_BARS = MgrCommand.flags.ALL_BARS;

  /**
   * Command to search the network for devices containing objects with a particular
   * id or name. This will query the network and display the results in a dialog
   * when the job complete event is fired.
   *
   * @class
   * @alias module:nmodule/bacnet/rc/wb/mgr/commands/WhoHasCommand
   * @extends module:bajaux/commands/Command
   */
  var WhoHasCommand = function WhoHasCommand(mgr) {
    var that = this;
    Command.call(that, {
      displayName: bacnetLex.get('whoHas.label'),
      description: bacnetLex.get('whoHas.description'),
      icon: bacnetLex.get('whoHas.icon'),
      enabled: true,
      flags: ALL_BARS,
      /**
       * Show the configuration property sheet, then pass the configuration
       * parameters to the action to start the job.
       *
       * @alias module:nmodule/bacnet/rc/wb/mgr/commands/WhoHasCommand#invoke
       * @returns {Promise}
       */
      func: function func() {
        var network = mgr.getNetwork();
        var that = this;
        return mgr.makeDiscoveryNetworks(network).then(function (discoveryNetworks) {
          return that.$promptForConfig(discoveryNetworks).then(function (config) {
            if (config) {
              return network.submitDeviceManagerJob(config).then(function (ord) {
                mgr.setJob(baja.Ord.make({
                  base: baja.Ord.make('station:'),
                  child: ord.relativizeToSession()
                }));
              });
            }
          });
        });
      }
    });
    mgr.on('jobcomplete', function (job) {
      if (job.getType().is('bacnet:WhoHasJob')) {
        that.complete(job);
      }
    });
  };
  WhoHasCommand.prototype = Object.create(Command.prototype);
  WhoHasCommand.prototype.constructor = WhoHasCommand;

  /**
   * @private
   * @param {module:nmodule/bacnet/rc/baja/datatypes/DiscoveryNetworks} networks
   * @returns {Promise.<baja.Component>} a `bacnet:WhoHasConfig`
   */
  WhoHasCommand.prototype.$promptForConfig = function (networks) {
    return feDialogs.props(baja.$('bacnet:WhoHasConfig', {
      networks: networks
    }), {
      title: bacnetLex.get('whoHas.description')
    });
  };

  /**
   * Function called when the 'who has' job has completed. This will get the encoded
   * 'I Have' responses from the job and display the results in a dialog.
   *
   * @param {baja.Component} job - the 'who has' job, submitted by the invoke function
   * above.
   */
  WhoHasCommand.prototype.complete = function (job) {
    return job.loadSlots().then(function () {
      var slots = job.getSlots().properties().is('baja:String').toValueArray(),
        txt = 'I-Have Responses for <br>' + slots[0] + '<br><ul>';
      _.each(_.tail(slots), function (str) {
        var tokens = str.split('|');
        txt = txt + '<li>' + tokens[0] + ' has object ' + tokens[1] + ' named ' + tokens[2] + '</li>';
      });
      txt = txt + '</ul>';
      dialogs.showOk({
        title: bacnetLex.get('whoHas.label'),
        content: txt
      });
    });
  };
  return WhoHasCommand;
});
