function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/bacnet/rc/wb/mgr/commands/TimeSynchCommand
 */
define(['baja!', 'lex!bacnet', 'Promise', 'dialogs', 'bajaux/commands/Command', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/wb/mgr/commands/MgrCommand', 'baja!bacnet:TimeSynchConfig,bacnet:TimeSynchJob,bacnet:BacnetNetwork'], function (baja, lexs, Promise, dialogs, Command, feDialogs, MgrCommand) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    bacnetLex = _lexs[0];
  var ALL_BARS = MgrCommand.flags.ALL_BARS;

  /**
   * Display an error dialog, inserting the error text into the failure message.
   */
  function showErrorDialog(err) {
    dialogs.showOk({
      title: bacnetLex.get('timeSynch.title'),
      text: bacnetLex.get('timeSynch.fail').replace('{0}', err || '')
    });
  }

  /**
   * Command for invoking a time synchronization job on the BACnet network.
   *
   * @class
   * @alias module:nmodule/bacnet/rc/wb/mgr/commands/TimeSynchCommand
   * @extends module:bajaux/commands/Command
   */
  var TimeSynchCommand = function TimeSynchCommand(mgr) {
    var that = this;
    Command.call(this, {
      displayName: bacnetLex.get('timeSynch.label'),
      description: bacnetLex.get('timeSynch.description'),
      icon: bacnetLex.get('timeSynch.icon'),
      enabled: true,
      flags: ALL_BARS,
      /**
       * Display a dialog with the choices of local/UTC time and local or remote
       * networks. Once that's confirmed, we invoke the command to start the job
       * and then set the job on the manager view.
       *
       * @alias module:nmodule/bacnet/rc/wb/mgr/commands/TimeSynchCommand#invoke
       * @returns {Promise}
       */
      func: function func() {
        var network = mgr.getNetwork();
        var that = this;
        return dialogs.showYesNo({
          title: bacnetLex.get('timeSynch.title'),
          text: bacnetLex.get('timeSynch.confirm'),
          yes: function yes() {
            return that.$promptForConfig().then(function (jobConfig) {
              if (!jobConfig) {
                return;
              }
              return network.submitDeviceManagerJob(jobConfig).then(function (ord) {
                // Pass the job to the manager. This will set it on the job bar and
                // will listen for the completion event. It will check the type and
                // display a message when complete.

                mgr.setJob(baja.Ord.make({
                  base: baja.Ord.make('station:'),
                  child: ord.relativizeToSession()
                }));
              });
            })["catch"](showErrorDialog);
          }
        }).promise();
      }
    });
    mgr.on('jobcomplete', function (job) {
      if (job.getType().is('bacnet:TimeSynchJob')) {
        that.complete(job);
      }
    });
  };
  TimeSynchCommand.prototype = Object.create(Command.prototype);
  TimeSynchCommand.prototype.constructor = TimeSynchCommand;

  /**
   * Prompt the user for a `bacnet:TimeSynchConfig` to use to invoke the action.
   * @private
   * @returns {Promise.<baja.Component|null>}
   */
  TimeSynchCommand.prototype.$promptForConfig = function () {
    return feDialogs.props({
      timeSynchType: {
        displayName: '%lexicon(bacnet:timeSynchType.title)%',
        value: false,
        properties: {
          range: {
            '%lexicon(bacnet:timeSynchType.local)%': false,
            '%lexicon(bacnet:timeSynchType.utc)%': true
          }
        }
      },
      addressRange: {
        displayName: '%lexicon(bacnet:timeSynchRange.title)%',
        value: false,
        properties: {
          range: {
            '%lexicon(bacnet:timeSynchRange.local)%': false,
            '%lexicon(bacnet:timeSynchRange.global)%': true
          }
        }
      }
    }, {
      title: bacnetLex.get('timeSynch.title')
    }).then(function (results) {
      return results && baja.$('bacnet:TimeSynchConfig', results);
    });
  };

  /**
   * Function called when the time synch job has completed.
   *
   * @param {baja.Component} job - the time synch job, submitted by the invoke function
   * above.
   */
  TimeSynchCommand.prototype.complete = function (job) {
    var msg, cause;
    if (job.getJobState().getTag() === 'success') {
      msg = bacnetLex.get('timeSynch.success');
    } else {
      cause = job.get('failureCause') || '';
      msg = bacnetLex.get({
        key: 'timeSynch.fail',
        args: [cause]
      });
    }
    dialogs.showOk({
      title: bacnetLex.get('timeSynch.title'),
      text: msg
    });
  };
  return TimeSynchCommand;
});
