function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 * @author Aaron Laniewicz
 */

/**
 * API Status: **Private**
 * @module nmodule/bacnet/rc/fe/BacnetRecipientEditor
 */
define(['baja!', 'baja!bacnet:BacnetRecipient', 'bajaux/mixin/batchSaveMixin', 'bajaux/commands/ToggleCommandGroup', 'bajaux/util/CommandButtonGroup', 'bajaux/Widget', 'css!nmodule/bacnet/rc/bacnet', 'hbs!nmodule/bacnet/rc/fe/templates/BacnetRecipientEditor', 'nmodule/bacnet/rc/baja/datatypes/BacnetRecipient', 'nmodule/webEditors/rc/fe/CompositeEditor', 'nmodule/webEditors/rc/fe/baja/DisplayOnlyEditor', 'nmodule/webEditors/rc/fe/baja/util/compUtils', 'nmodule/webEditors/rc/fe/config/CompositeBuilder', 'Promise'], function (baja, types, batchSaveMixin, ToggleCommandGroup, CommandButtonGroup, Widget, css, template, BacnetRecipient, CompositeEditor, DisplayOnlyEditor, compUtils, CompositeBuilder, Promise) {
  'use strict';

  var DEVICE = BacnetRecipient.DEVICE,
    ADDRESS = BacnetRecipient.ADDRESS,
    bulkCopy = compUtils.bulkCopy;

  /**
   * Field editor for working with `bacnet:BacnetRecipient` instances.
   *
   * @class
   * @alias module:nmodule/bacnet/rc/fe/BacnetRecipientEditor
   * @extends module:nmodule/webEditors/rc/fe/CompositeEditor
   */
  var BacnetRecipientEditor = function BacnetRecipientEditor() {
    CompositeEditor.apply(this, arguments);
    batchSaveMixin(this);
    if (this.getFormFactor() === Widget.formfactor.mini) {
      DisplayOnlyEditor.$mixin(this);
    }
  };
  BacnetRecipientEditor.prototype = Object.create(CompositeEditor.prototype);
  BacnetRecipientEditor.prototype.constructor = BacnetRecipientEditor;

  /**
   * Initialize the `BacnetRecipientEditor`.
   *
   * @param {JQuery} dom
   * @returns {Promise}
   */
  BacnetRecipientEditor.prototype.doInitialize = function (dom) {
    var that = this;
    dom.html(template());
    that.$toggleCommandGroup = new ToggleCommandGroup({
      onChange: function onChange(value) {
        that.$toggleDisplay(value);
      },
      commands: [{
        module: 'bacnet',
        lex: 'BacnetRecipientEditor.commands.toggle.device',
        value: DEVICE
      }, {
        module: 'bacnet',
        lex: 'BacnetRecipientEditor.commands.toggle.address',
        value: ADDRESS
      }]
    });
    return CompositeEditor.prototype.doInitialize.apply(that, arguments);
  };

  /**
   * The builder for `BacnetRecipientEditor` will create a `BacnetAddressEditor`
   * for `address` and a `BacnetObjectIdEditor` for `device`.
   *
   * @returns {module:nmodule/webEditors/rc/fe/config/CompositeBuilder}
   */
  BacnetRecipientEditor.prototype.makeBuilder = function () {
    var that = this,
      builder = new CompositeBuilder();
    builder.getKeys = function () {
      return ['commands', 'device', 'address'];
    };
    builder.getDomFor = function (key) {
      return that.jq().children('.key-' + key);
    };
    builder.getValueFor = function (key) {
      var recipient = this.getDataSource();
      switch (key) {
        case 'commands':
          return that.$toggleCommandGroup;
        case 'device':
          return recipient.get('device');
        case 'address':
          return recipient.get('address');
      }
    };
    builder.getConfigFor = function (key) {
      switch (key) {
        case 'commands':
          return {
            type: CommandButtonGroup,
            formFactor: 'mini'
          };
        default:
          {
            return {
              formFactor: 'mini'
            };
          }
      }
    };
    return builder;
  };

  /**
   * Load the `choice`, `address`, and `device` of the `BacnetRecipient` into
   * the appropriate child editors.
   *
   * @param {Struct} bacnetRecipient
   * @returns {Promise}
   */
  BacnetRecipientEditor.prototype.doLoad = function (bacnetRecipient) {
    var that = this,
      choice = bacnetRecipient && bacnetRecipient.getChoice();
    return CompositeEditor.prototype.doLoad.apply(that, arguments).then(function () {
      that.$toggleDisplay(choice);
      that.$getAddressToggleCommand().setSelected(choice === ADDRESS);
      that.$getDeviceToggleCommand().setSelected(choice === DEVICE);
    });
  };

  /**
   * Read a new `BacnetRecipient` with current values of `address` and `device`.
   *
   * @returns {Promise.<baja.Struct>}
   */
  BacnetRecipientEditor.prototype.doRead = function () {
    var that = this;
    return Promise.all([that.$getDeviceEditor().read(), that.$getAddressEditor().read()]).then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 2),
        device = _ref2[0],
        address = _ref2[1];
      return baja.$('bacnet:BacnetRecipient', {
        choice: baja.Integer.make(that.$getToggleCommandGroup().getSelectedValue()),
        device: device,
        address: address
      });
    });
  };

  /**
   * Apply the currently selected choice, and either the corresponding `device`
   * or `address` values back to the `BacnetRecipient`. Respects the
   * `batchSaveMixin` contract.
   *
   * @param {baja.Struct} bacnetRecipient - the `BacnetRecipient` to save
   * @param {Object} params
   * @returns {Promise}
   */
  BacnetRecipientEditor.prototype.doSave = function (bacnetRecipient, params) {
    var value = this.value(),
      batch = params && params.batch,
      progressCallback = params && params.progressCallback,
      proms = [],
      choice = bacnetRecipient.get('choice'),
      device = bacnetRecipient.get('device'),
      address = bacnetRecipient.get('address');
    proms.push(value.set({
      slot: 'choice',
      value: choice,
      batch: batch
    }));
    if (choice.valueOf() === DEVICE) {
      proms.push(value.set({
        slot: 'device',
        value: device,
        batch: batch
      }));
    } else {
      proms.push(bulkCopy(address, value.get('address'), ['addressType', 'networkNumber', 'macAddress'], batch));
    }
    var prom = Promise.all(proms);
    if (progressCallback) {
      progressCallback(batchSaveMixin.COMMIT_READY);
    }
    return prom;
  };
  BacnetRecipientEditor.prototype.$getToggleCommandGroup = function () {
    return this.$toggleCommandGroup;
  };
  BacnetRecipientEditor.prototype.$getDeviceToggleCommand = function () {
    return this.$toggleCommandGroup.get(DEVICE);
  };
  BacnetRecipientEditor.prototype.$getAddressToggleCommand = function () {
    return this.$toggleCommandGroup.get(ADDRESS);
  };
  BacnetRecipientEditor.prototype.$getCommandButtonGroup = function () {
    return this.getBuilder().getEditorFor('commands');
  };
  BacnetRecipientEditor.prototype.$getDeviceEditor = function () {
    return this.getBuilder().getEditorFor('device');
  };
  BacnetRecipientEditor.prototype.$getAddressEditor = function () {
    return this.getBuilder().getEditorFor('address');
  };
  BacnetRecipientEditor.prototype.$getDeviceElement = function () {
    return this.jq().find('.key-device');
  };
  BacnetRecipientEditor.prototype.$getAddressElement = function () {
    return this.jq().find('.key-address');
  };
  BacnetRecipientEditor.prototype.$toggleDisplay = function (choice) {
    var that = this;
    that.$getDeviceElement().toggle(choice === DEVICE);
    that.$getAddressElement().toggle(choice === ADDRESS);
  };
  return BacnetRecipientEditor;
});
