/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 * @author Aaron Laniewicz
 */

/**
 * API Status: **Private**
 * @module nmodule/bacnet/rc/baja/datatypes/BacnetRecipient
 */
define(['baja!'], function (baja) {
  'use strict';

  var Struct = baja.Struct,
    DEVICE = 0,
    ADDRESS = 1;

  /**
   * BajaScript representation of a `bacnet:BacnetRecipient`.
   * @class
   * @alias module:nmodule/bacnet/rc/datatypes/BacnetRecipient
   * @extends baja.Struct
   */
  var BacnetRecipient = function BacnetRecipient() {
    Struct.apply(this, arguments);
  };
  BacnetRecipient.prototype = Object.create(Struct.prototype);
  BacnetRecipient.prototype.constructor = BacnetRecipient;

  /**
   * Returns the String value of the device if choice is 0, or address if choice
   * is 1.
   *
   * @returns {String}
   */
  BacnetRecipient.prototype.toString = function () {
    var that = this,
      choice = that.get('choice').valueOf();
    if (choice === DEVICE) {
      return that.get('device').toString();
    } else {
      return that.get('address').toString();
    }
  };
  BacnetRecipient.DEVICE = DEVICE;
  BacnetRecipient.ADDRESS = ADDRESS;
  return BacnetRecipient;
});
