/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/bacnet/rc/baja/config/BacnetSchedule
 */
define(['nmodule/bacnet/rc/baja/BacnetObject', 'nmodule/webEditors/rc/baja/bajaUtils'], function (BacnetObject, bajaUtils) {
  'use strict';

  var proxySlotFacets = bajaUtils.proxySlotFacets;

  /**
   * BajaScript representation of an `bacnet:BacnetSchedule` value.
   *
   * @class
   * @extends {module:nmodule/bacnet/rc/baja/BacnetObject}
   * @alias {module:nmodule/bacnet/rc/baja/config/BacnetSchedule}
   */
  var BacnetSchedule = function BacnetSchedule() {
    BacnetObject.apply(this, arguments);
    proxySlotFacets(this, {
      '^presentValue$': 'facets'
    });
  };
  BacnetSchedule.prototype = Object.create(BacnetObject.prototype);
  BacnetSchedule.prototype.constructor = BacnetSchedule;
  return BacnetSchedule;
});
