function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _superPropGet(t, e, o, r) { var p = _get(_getPrototypeOf(1 & r ? t.prototype : t), e, o); return 2 & r && "function" == typeof p ? function (t) { return p.apply(o, t); } : p; }
function _get() { return _get = "undefined" != typeof Reflect && Reflect.get ? Reflect.get.bind() : function (e, t, r) { var p = _superPropBase(e, t); if (p) { var n = Object.getOwnPropertyDescriptor(p, t); return n.get ? n.get.call(arguments.length < 3 ? e : r) : n.value; } }, _get.apply(null, arguments); }
function _superPropBase(t, o) { for (; !{}.hasOwnProperty.call(t, o) && null !== (t = _getPrototypeOf(t));); return t; }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/*
 * Copyright 2023 Tridium, Inc. All Rights Reserved.
 */
/* global niagara */
/* eslint-env browser */
/**
 * API Status: **Private**
 * @module nmodule/onCall/rc/wb/UxOnCallListManager
 */
define(['baja!', 'dialogs', 'Promise', 'underscore', 'bajaux/commands/Command', 'bajaux/mixin/subscriberMixIn', 'nmodule/onCall/rc/wb/model/OnCallListManagerModel', 'nmodule/webEditors/rc/fe/baja/util/DepthSubscriber', 'nmodule/webEditors/rc/wb/mgr/componentStatusUtils', 'nmodule/webEditors/rc/wb/mgr/mgrUtils', 'nmodule/webEditors/rc/wb/mgr/Manager'], function (baja, dialogs, Promise, _, Command, subscribable, OnCallListManagerModel, DepthSubscriber, componentStatusUtils, mgrUtils, Manager) {
  'use strict';

  var getMainTableSelectedSubjects = mgrUtils.getMainTableSelectedSubjects;
  var addComponentStatusCss = componentStatusUtils.addComponentStatusCss;

  /**
   * Implementation of RotateCommand
   * @since Niagara 4.14
   * @inner
   * @class
   * @extends {module:bajaux/commands/Command}
   * @param {UxOnCallListManager} mgr
   */
  var RotateCommand = /*#__PURE__*/function (_Command) {
    function RotateCommand(mgr) {
      _classCallCheck(this, RotateCommand);
      return _callSuper(this, RotateCommand, [{
        module: 'onCall',
        lex: 'commands.rotate',
        enabled: false,
        func: function func() {
          // Rotate all selected OnCallList
          var selectedSubjects = getMainTableSelectedSubjects(mgr);
          var rotates = _.map(selectedSubjects, function (subject) {
            return subject.rotate();
          });
          return Promise.all(rotates);
        }
      }]);
    }
    _inherits(RotateCommand, _Command);
    return _createClass(RotateCommand);
  }(Command);
  /**
   * Shows information about OnCallList.
   *
   * @class
   * @alias module:nmodule/onCall/rc/wb/UxOnCallListManager
   * @extends module:nmodule/webEditors/rc/wb/mgr/Manager
   */
  return /*#__PURE__*/function (_Manager) {
    function UxOnCallListManager() {
      var _this;
      _classCallCheck(this, UxOnCallListManager);
      _this = _callSuper(this, UxOnCallListManager, [{
        moduleName: 'onCall',
        keyName: 'UxOnCallListManager'
      }]);
      _this.$subscriber = new DepthSubscriber(2);
      subscribable(_this);
      return _this;
    }

    /**
     * Makes the main model
     * @param {baja.Component} component
     * @returns {Promise<module:nmodule/onCall/rc/wb/model/OnCallListManagerModel>}
     */
    _inherits(UxOnCallListManager, _Manager);
    return _createClass(UxOnCallListManager, [{
      key: "makeModel",
      value: function makeModel(component) {
        return OnCallListManagerModel.make(component);
      }

      /**
       * Adds Rotate Command
       * @returns {Array.<module:bajaux/commands/Command>}
       */
    }, {
      key: "makeCommands",
      value: function makeCommands() {
        var _this2 = this;
        return _superPropGet(UxOnCallListManager, "makeCommands", this, 3)([]).then(function (cmds) {
          return cmds.concat(new RotateCommand(_this2));
        });
      }

      /**
       * In addition to the standard logic, this enables/disables the EditCommand and RotateCommand
       * based on the selected rows
       * @inheritDoc
       */
    }, {
      key: "onTableSelectionChanged",
      value: function onTableSelectionChanged(selectedSubjects) {
        var _this3 = this;
        return _superPropGet(UxOnCallListManager, "onTableSelectionChanged", this, 3)(arguments).then(function () {
          var mainTableSelection = selectedSubjects.mainTableSelection;
          var editCmd = _this3.$getEditCommand();
          var rotateCmd = _this3.$getRotateCommand();
          var commandsEnabled = !(mainTableSelection.length === 0);
          editCmd.setEnabled(commandsEnabled);
          rotateCmd.setEnabled(commandsEnabled);
        });
      }

      /**
       * Hyperlinks the row to NavOrd
       * @inheritDoc
       */
    }, {
      key: "onMainTableDblClicked",
      value: function onMainTableDblClicked(event, subjects) {
        if (subjects && subjects.length) {
          if (typeof niagara !== 'undefined' && niagara.env) {
            return niagara.env.hyperlink(baja.Ord.make(subjects[0].getNavOrd()));
          }
        }
      }

      /**
       * Overrides the basic manager `#finishMainTableRow` function with some extra css information
       * specified on the dom for the table row.
       *
       * @param {module:nmodule/webEditors/rc/wb/table/model/Row} row a table row instance
       * @param {JQuery} dom
       */
    }, {
      key: "finishMainTableRow",
      value: function finishMainTableRow(row, dom) {
        var subject = row.getSubject(),
          status = subject.getStatus();
        addComponentStatusCss(status, dom);
        return Promise.resolve(dom);
      }

      /**
       * @private
       * @returns {RotateCommand}
       */
    }, {
      key: "$getRotateCommand",
      value: function $getRotateCommand() {
        return this.getCommandGroup().findCommand(RotateCommand);
      }
    }]);
  }(Manager);
});
