function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2021 Tridium, Inc. All Rights Reserved.
 */

define(['baja!', 'lex!baja', 'baja!bql:BqlExtent,' + 'query:Projection,' + 'query:ProjCol,' + 'bql:Path,' + 'query:Binary,' + 'query:Null,' + 'query:Predicate,' + 'query:SimpleExpr', 'underscore', 'nmodule/webEditors/rc/fe/baja/util/typeUtils', 'nmodule/webEditors/rc/util/textUtils'], function (baja, lexs, types, _, typeUtils, textUtils) {
  'use strict';

  /**
   * Utility functions for parsing Bql.
   *
   * Note that the support for interacting with a `bql:Select` is
   * simplified here for supporting the options needed for the Bql Builder.
   * In general, bql queries can more complex that what the Bql Builder supports.
   * In those more complex cases, you may want to interact with the `bql:Select`
   * directly once you call `parseBql.toSelect` to obtain the `bql:Select`.
   * Once changes are made to the `bql:Select`, a call to `parseBql.toBqlBody`
   * will obtain the new bql body for that query.
   *
   * API Status: **Private**
   * @exports nmodule/bql/rc/util/parseBql
   * @since Niagara 4.12
   */
  var exports = {};
  var _lexs = _slicedToArray(lexs, 1),
    bajaLex = _lexs[0];
  var WILDCARD = '*';
  var toFriendly = textUtils.toFriendly;
  var getSlotDisplayName = typeUtils.getSlotDisplayName,
    getSlotType = typeUtils.getSlotType;
  var ORD_TYPE = 'baja:Ord';
  var COMPONENT_COLS = [toCol("absoluteOrd", ORD_TYPE), toCol("class"), toCol("displayName"), toCol("handle"), toCol("handleOrd", ORD_TYPE), toCol("host"), toCol("isNull"), toCol("name"), toCol("navOrd", ORD_TYPE), toCol("navParent"), toCol("ordInHost", ORD_TYPE), toCol("ordInSession", ORD_TYPE), toCol("ordInSpace", ORD_TYPE), toCol("parent"), toCol("slotPath"), toCol("slotPathOrd", ORD_TYPE), toCol("toPathString"), toCol("toString"), toCol("type")];
  var COMPLEX_COLS = [toCol("class"), toCol("displayName"), toCol("isNull"), toCol("name"), toCol("parent"), toCol("slotPath"), toCol("toString"), toCol("type")];
  var OBJECT_COLS = [toCol("class"), toCol("isNull"), toCol("toString"), toCol("type")];

  /**
   * Converts a bql body string into a bql:Select Component.
   *
   * @param {String} bqlBody the body of a bql scheme. For example, `select * from baja:Component`.
   * @returns {Promise.<baja.Component>} which resolves to a `bql:Select`.
   */
  exports.toSelect = function (bqlBody) {
    return baja.rpc({
      typeSpec: "box:BqlRpc",
      method: "toSelect",
      args: [bqlBody]
    }).then(function (result) {
      return baja.bson.decodeAsync(JSON.parse(result));
    });
  };

  /**
   * Converts a bql:Select Component into a bql body string.
   *
   * @param {baja.Component} select a `bql:Select` instance.
   * @returns {Promise.<String>} which resolves to the bql query body
   */
  exports.toBqlBody = function (select) {
    return baja.rpc({
      typeSpec: "box:BqlRpc",
      method: "toBqlBody",
      args: [JSON.stringify(baja.bson.encodeValue(select))]
    });
  };

  /**
   * Converts a simplified bql:Select Component into a bql body string for the BqlBuilderBuilder.
   *
   * @param {baja.Component} select a `bql:Select` instance.
   * @param {baja.Ord} rootOrd
   * @returns {string} which resolves to the simplified bql query body
   */
  exports.toSimplifiedBqlBody = function (select, rootOrd) {
    var bqlBody = 'select';
    exports.getProjection(select).forEach(function (_ref, index) {
      var fieldPath = _ref.fieldPath,
        alias = _ref.alias;
      if (index > 0) {
        bqlBody += ', ';
      } else {
        bqlBody += ' ';
      }
      if (toFriendly(fieldPath) === alias || fieldPath === WILDCARD) {
        bqlBody += fieldPath;
      } else {
        bqlBody += fieldPath + ' as \'' + alias + '\'';
      }
    });
    if (exports.isStationOrd(rootOrd)) {
      var typeSpec = exports.getExtent(select);
      if (typeSpec) {
        bqlBody += ' from ' + typeSpec;
      }
      var extent = select.get('extent');
      var stop = extent.get('stop');
      if (stop) {
        bqlBody += ' stop';
      }
    }
    var _exports$getPredicate = exports.getPredicateInfo(select),
      expressions = _exports$getPredicate.expressions,
      matchAll = _exports$getPredicate.matchAll;
    expressions.forEach(function (_ref2, index) {
      var fieldPath = _ref2.fieldPath,
        operator = _ref2.operator,
        matchValue = _ref2.matchValue;
      if (index > 0) {
        bqlBody += matchAll ? ' and' : ' or';
      } else {
        bqlBody += ' where';
      }
      bqlBody += ' ' + fieldPath + ' ' + operator;
      if (matchValue === null || matchValue === undefined || isNullSimple(matchValue)) {
        bqlBody += ' null';
      } else if (baja.hasType(matchValue, 'baja:Number') || baja.hasType(matchValue, 'baja:Boolean')) {
        bqlBody += ' ' + matchValue.encodeToString();
      } else {
        bqlBody += ' \'' + matchValue.encodeToString() + '\'';
      }
    });
    return bqlBody;
  };

  /**
   * Get the TypeSpec String of the extent.
   * @param {baja.Component} select a `bql:Select` instance.
   * @return {string} The TypeSpec String of the Extent. This will be an empty String if there is no extent.
   */
  exports.getExtent = function (select) {
    var extent = select.get('extent');
    return extent ? extent.get('unparsed') : '';
  };

  /**
   * Sets the `bql:Select` extent to a certain TypeSpec.
   * @param {baja.Component} select a `bql:Select` instance.
   * @param {String} typeSpec
   * @param {boolean} [stop]
   * @return {Promise}
   */
  exports.setExtent = function (select, typeSpec, stop) {
    var extentArs = {
      unparsed: typeSpec
    };
    if (stop) {
      extentArs.stop = stop;
    }
    var extent = baja.$('bql:BqlExtent', extentArs);
    return addOrSet(select, {
      slot: 'extent',
      value: extent
    });
  };

  /**
   * Get the Projection Columns.
   *
   * @param {baja.Component} select a `bql:Select` instance.
   * @returns {Array.<module:nmodule/bql/rc/util/parseBql~column>} columns
   */
  exports.getProjection = function (select) {
    var projection = select.get('projection');
    var results = [];
    if (!projection) {
      return results;
    }
    _.each(projection.getSlots().properties().is("query:ProjCol").toValueArray(), function (col) {
      var firstPath = col.getSlots().properties().is("bql:Path").firstValue();
      if (firstPath) {
        var fieldPath = firstPath.get('fieldPath');
        var alias = col.get('alias');
        if (!alias && fieldPath !== WILDCARD) {
          alias = toFriendly(fieldPath);
        }
        results.push({
          fieldPath: fieldPath,
          alias: alias
        });
      }
    });
    return results;
  };

  /**
   * Sets the Projection based on the Columns provided.
   *
   * @param {baja.Component} select a `bql:Select` instance.
   * @param {Array.<module:nmodule/bql/rc/util/parseBql~column>} columns
   * @return {Promise}
   */
  exports.setProjection = function (select, columns) {
    var projection = baja.$('query:Projection');
    for (var i = 0; i < columns.length; i++) {
      var col = getProjCol(columns[i]);
      projection.add({
        value: col
      });
    }
    return addOrSet(select, {
      slot: 'projection',
      value: projection
    });
  };

  /**
   * Get the Predicate info. This is the information that is part of the `where` clause.
   * If there are more than two expressions and there is a mix of 'and' and 'or' operators, an Error will be thrown
   * because the BqlBuilder only supports only `matchAll` or `matchAny`.
   *
   * @param {baja.Component} select a `bql:Select` instance.
   * @returns {module:nmodule/bql/rc/util/parseBql~predicateInfo}
   */
  exports.getPredicateInfo = function (select) {
    var predicate = select.get('predicate');
    if (!predicate) {
      return {
        expressions: [],
        matchAll: true
      };
    }
    var predicateInfo = {
      expressions: []
    };
    collectionMatchExpressions(predicate, predicateInfo);
    if (predicateInfo.matchAll === undefined) {
      predicateInfo.matchAll = true;
    }
    return predicateInfo;
  };

  /**
   * Set the Predicate Info. This is the information that is part of the `where` clause.
   * If there is one or more expressions, then the `matchAll` will determine whether to use `and` or to use `or`.
   * This is because the BqlBuilder only supports only `matchAll` or `matchAny`.
   *
   * @param {baja.Component} select a `bql:Select` instance.
   * @param {Array.<module:nmodule/bql/rc/util/parseBql~predicateInfo>} predicateInfo
   * @return {Promise}
   */
  exports.setPredicateInfo = function (select, predicateInfo) {
    var expressions = predicateInfo.expressions,
      matchAll = predicateInfo.matchAll,
      predicate = baja.$('query:Predicate');
    var currentExpr;
    for (var i = 0; i < expressions.length; i++) {
      var expression = expressions[i];
      var path = baja.$('bql:Path', {
        fieldPath: expression.fieldPath
      });
      var matchValue = expression.matchValue;
      if (matchValue === null || matchValue === undefined) {
        matchValue = baja.$('query:Null');
      }
      var simpleExpr = baja.$('query:SimpleExpr', {
        simple: matchValue
      });
      var binary = baja.$('query:Binary', {
        left: path,
        right: simpleExpr,
        operator: expression.operator
      });
      if (!currentExpr) {
        currentExpr = binary;
      } else {
        currentExpr = baja.$('query:Binary', {
          left: currentExpr,
          right: binary,
          operator: matchAll ? 'and' : 'or'
        });
      }
    }
    if (currentExpr) {
      predicate.add({
        value: currentExpr
      });
      return addOrSet(select, {
        slot: 'predicate',
        value: predicate
      });
    }
  };

  /**
   * @param {baja.Ord|String} rootOrd
   * @returns {boolean}
   */
  exports.isStationOrd = function (rootOrd) {
    return rootOrd.toString().toLowerCase().indexOf("station:") === 0;
  };

  /**
   * @param {baja.Ord|String} rootOrd
   * @returns {boolean}
   */
  exports.isHistoryOrd = function (rootOrd) {
    return rootOrd.toString().toLowerCase().indexOf("history:") !== -1;
  };

  /**
   * @param {baja.Ord|String} rootOrd
   * @returns {boolean}
   */
  exports.isNullOrd = function (rootOrd) {
    return rootOrd.toString().toLowerCase().indexOf("null") === 0;
  };

  /**
   * Resolve the predefined columns based on the current BqlQueryBuilder state.
   * @param {module:nmodule/bql/rc/builder/BqlQueryBuilder~state} state
   * @returns {Promise.<Array.<module:nmodule/bql/rc/util/parseBql~column>>}
   */
  exports.resolvePredefinedColumns = function (_ref3) {
    var extent = _ref3.extent,
      rootOrd = _ref3.rootOrd,
      columnMode = _ref3.columnMode;
    if (!exports.isStationOrd(rootOrd) || !columnMode) {
      var trimmedOrd = exports.isHistoryOrd(rootOrd) ? trimQuery(rootOrd) : rootOrd;
      return trimmedOrd.get().then(function (root) {
        if (root && typeof root.toConfig === 'function') {
          return root.toConfig().then(function (config) {
            var recordType = config.get('recordType');
            if (recordType) {
              return typeToColumns(recordType.valueOf());
            }
            return typeToColumns(root.getType());
          });
        }
        return typeToColumns(root.getType());
      });
    }
    return typeToColumns(extent.valueOf());
  };

  /**
   * @param {module:nmodule/bql/rc/util/parseBql~column} column
   * @return {baja.Component} a `query:ProjCol` instance.
   */
  function getProjCol(column) {
    var fieldPath = column.fieldPath,
      alias = column.alias,
      columnArguments = {},
      pathArguments = {
        fieldPath: fieldPath
      };
    if (alias) {
      columnArguments.alias = alias;
    }
    var col = baja.$('query:ProjCol', columnArguments);
    var path = baja.$('bql:Path', pathArguments);
    col.add({
      value: path
    });
    return col;
  }

  /**
   * @param {baja.Component} comp
   * @param {Object} params Object literal
   * @param {String} params.slot the name of the Slot.
   * @param {baja.Value} params.value the value to add or set.
   *
   * @see baja.Component#add
   * @see baja.Complex#set
   * @return {Promise}
   */
  function addOrSet(comp, params) {
    var slot = params.slot;
    if (comp.get(slot) === null) {
      return comp.add(params);
    } else {
      return comp.set(params);
    }
  }

  /**
   * Recursively traverses the Predicate to collect the expressions
   * and provide them to the Bql Builder.
   * @param {baja.Component} comp
   * @param {module:nmodule/bql/rc/util/parseBql~predicateInfo} predicateInfo
   */
  function collectionMatchExpressions(comp, predicateInfo) {
    var expressions = predicateInfo.expressions;
    _.map(comp.getSlots().toValueArray(), function (expression) {
      if (expression.getType().is('query:Binary')) {
        var binary = expression;
        var operator = binary.get('operator');
        if (operator === 'and' || operator === 'or') {
          var currentMatchAll = operator === 'and';
          if (predicateInfo.matchAll === undefined) {
            predicateInfo.matchAll = currentMatchAll;
          } else if (currentMatchAll !== predicateInfo.matchAll) {
            throw new Error("Cannot mix `and` with `or`");
          }
          collectionMatchExpressions(binary, predicateInfo);
        } else {
          var left = binary.get('left');
          var right = binary.get('right');
          expressions.push({
            operator: operator,
            fieldPath: left.get('fieldPath'),
            matchValue: right.get('simple')
          });
        }
      }
    });
  }

  /**
   * @param {String} typeString
   * @return {Promise.<Array.<module:nmodule/bql/rc/util/parseBql~column>>}
   */
  function typeToColumns(typeString) {
    return baja.importTypes([typeString]).then(function (_ref4) {
      var _ref5 = _slicedToArray(_ref4, 1),
        type = _ref5[0];
      return [].concat(_toConsumableArray(getPropertyColumns(type)), _toConsumableArray(getBasicColumns(type))).sort(function (obj1, obj2) {
        return obj1.fieldPath.toLowerCase().localeCompare(obj2.fieldPath.toLowerCase());
      });
    });
  }

  /**
   * @param {String} fieldPath
   * @param {String|Type} type
   * @return {module:nmodule/bql/rc/util/parseBql~column}
   */
  function toCol(fieldPath, type) {
    var lexEntry = bajaLex.get(fieldPath);
    if (!type) {
      type = 'baja:String';
    }
    return {
      fieldPath: fieldPath,
      alias: lexEntry || toFriendly(fieldPath),
      type: type
    };
  }

  /**
   * @param {Type} type
   * @return {Array.<module:nmodule/bql/rc/util/parseBql~column>}
   */
  function getBasicColumns(type) {
    if (type.isComponent()) {
      return COMPONENT_COLS;
    }
    if (type.isComplex()) {
      return COMPLEX_COLS;
    }
    return OBJECT_COLS;
  }

  /**
   * @param {Type} type
   * @return {Array.<module:nmodule/bql/rc/util/parseBql~column>}
   */
  function getPropertyColumns(type) {
    if (type.isComplex()) {
      return typeUtils.getPropertyNames(type).map(function (name) {
        return {
          fieldPath: name,
          alias: getSlotDisplayName(type, name),
          type: getSlotType(type, name)
        };
      });
    }
    return [];
  }

  /**
   * Trims off the part of the ord past the first ?
   * @param {baja.Ord|String} ord
   * @returns {baja.Ord}
   */
  function trimQuery(ord) {
    var ordStr = ord.toString();
    return baja.Ord.make(ordStr.split('?')[0]);
  }
  function isNullSimple(value) {
    if (baja.hasType(value, 'query:Null')) {
      return true;
    }
    return baja.hasType(value, 'baja:Simple') && typeof value.isNull === 'function' && value.isNull();
  }

  /**
   * @typedef module:nmodule/bql/rc/util/parseBql~column
   * @property {String} fieldPath
   * @property {String} [alias]
   * @property {String|Type} [type] An optional type to provide the proper field editor
   */

  /**
   * An object that defines a simple expression that can be used as part of the predicate.
   * A simple expression is one that can be represented as a `query:Binary` expression and with a `fieldPath`, `operator`, and `matchValue`.
   * For example `displayName like '%a%'` would be a simple expression.
   *
   * @typedef module:nmodule/bql/rc/util/parseBql~simpleExpression
   * @property {String} fieldPath
   * @property {String} operator
   * @property {*} matchValue
   * @property {String|Type} [type] An optional type to provide the proper field editor
   */

  /**
   * @typedef module:nmodule/bql/rc/util/parseBql~predicateInfo
   * @property {Array.<module:nmodule/bql/rc/util/parseBql~simpleExpression>} expressions
   * @property {boolean} [matchAll]
   */

  return exports;
});
