/**
 * @copyright 2015, Tridium, Inc. All Rights Reserved.
 * @author Danesh Kamal
 */

/**
 * API Status: **Private**
 * @module nmodule/bql/rc/fe/filter/BooleanFilterEditor
 */
define(['baja!', 'baja!bql:BooleanFilter', 'jquery', 'Promise', 'bajaux/events', 'nmodule/webEditors/rc/fe/baja/BaseEditor', 'nmodule/webEditors/rc/fe/fe', 'bajaux/mixin/batchSaveMixin', 'nmodule/bql/rc/fe/filter/saveUtil'], function (baja, types, $, Promise, events, BaseEditor, fe, batchSaveMixin, saveUtil) {
  "use strict";

  var ENABLE_EVENT = events.ENABLE_EVENT,
    DISABLE_EVENT = events.DISABLE_EVENT,
    MODIFY_EVENT = events.MODIFY_EVENT,
    INITIALIZE_EVENT = events.INITIALIZE_EVENT,
    LOAD_EVENT = events.LOAD_EVENT,
    READONLY_EVENT = events.READONLY_EVENT,
    WRITABLE_EVENT = events.WRITABLE_EVENT,
    DESTROY_EVENT = events.DESTROY_EVENT,
    save = saveUtil.save;

  /**
   * BooleanFilterEditor is a field editor for a bql:BooleanFilter instance
   * @class
   * @alias module:nmodule/bql/rc/fe/filter/BooleanFilterEditor
   * @extends module:nmodule/webEditors/rc/fe/baja/BaseEditor
   */
  var BooleanFilterEditor = function BooleanFilterEditor() {
    BaseEditor.apply(this, arguments);
    batchSaveMixin(this);
  };
  BooleanFilterEditor.prototype = Object.create(BaseEditor.prototype);
  BooleanFilterEditor.prototype.constructor = BooleanFilterEditor;

  /**
   * Delegates initialization to the BooleanEditor
   * @param dom
   * @returns {Promise}
   */
  BooleanFilterEditor.prototype.doInitialize = function (dom) {
    var that = this,
      booleanEditorDom = $("<div/>").addClass('booleanEditor').appendTo(dom);

    //prevent BooleanEditor subeditor from bubbling up events
    dom.on([ENABLE_EVENT, DISABLE_EVENT, READONLY_EVENT, WRITABLE_EVENT, INITIALIZE_EVENT, LOAD_EVENT, DESTROY_EVENT].join(' '), '.booleanEditor', false);
    dom.on(MODIFY_EVENT, '.booleanEditor', function () {
      that.setModified(true);
      return false;
    });
    return fe.buildFor({
      dom: booleanEditorDom,
      value: false,
      formFactor: 'mini'
    }).then(function (editor) {
      that.$booleanEditor = editor;
    });
  };

  /**
   * Delegates loading the filter value to the Boolean Editor
   * @param filter
   * @param params
   * @returns {Promise}
   */
  BooleanFilterEditor.prototype.doLoad = function (filter, params) {
    if (!baja.hasType(filter, 'bql:BooleanFilter')) {
      return Promise.reject(new Error('editor must be loaded with bql:BooleanFilter'));
    }
    return this.$getBooleanEditor().load(filter.getValue(), params);
  };

  /**
   * Reads the current boolean value from the BooleanEditor
   * @returns {Promise} Promise resolved with a new instance of a BooleanFilter
   */
  BooleanFilterEditor.prototype.doRead = function () {
    return this.$getBooleanEditor().read().then(function (value) {
      return baja.$("bql:BooleanFilter", {
        value: value
      });
    });
  };

  /**
   * Sets the readonly state of the BooleanEditor
   * @param readonly
   * @returns {Promise}
   */
  BooleanFilterEditor.prototype.doReadonly = function doReadonly(readonly) {
    return this.$getBooleanEditor().setReadonly(readonly);
  };

  /**
   * Sets the enabled state of the BooleanEditor
   * @param enabled
   * @returns {Promise}
   */
  BooleanFilterEditor.prototype.doEnabled = function doEnabled(enabled) {
    return this.$getBooleanEditor().setEnabled(enabled);
  };

  /**
   * Saves the the current boolean value to the filter
   * @param filter
   * @returns {Promise}
   */
  BooleanFilterEditor.prototype.doSave = function (filter, params) {
    return save(this, filter, params);
  };

  /**
   * Delegates destruction to the BooleanEditor
   * @param params
   * @returns {Promise}
   */
  BooleanFilterEditor.prototype.doDestroy = function (params) {
    return this.$getBooleanEditor().destroy(params);
  };

  /**
   * Returns the underlying BooleanEditor
   * @private
   * @returns {module:nmodule/bql/rc/fe/filter/BooleanFilterEditor}
   */
  BooleanFilterEditor.prototype.$getBooleanEditor = function () {
    return this.$booleanEditor;
  };
  return BooleanFilterEditor;
});
