function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2016, Tridium, Inc. All Rights Reserved.
 * @author Danesh Kamal
 */

/**
 * API Status: **Private**
 * @module nmodule/bql/rc/fe/filter/BitStringFilterEditor
 */
define(['baja!', 'baja!bql:EnumFilter', 'lex!workbench', 'jquery', 'underscore', 'Promise', 'bajaux/events', 'bajaux/Widget', 'nmodule/webEditors/rc/fe/baja/BaseEditor', 'nmodule/webEditors/rc/fe/fe', 'bajaux/commands/Command', 'bajaux/util/CommandButton', 'bajaux/mixin/batchSaveMixin', 'bajaux/mixin/subscriberMixIn', 'nmodule/bql/rc/fe/filter/saveUtil', 'hbs!nmodule/bql/rc/fe/filter/templates/BitStringFilterEditor', 'css!nmodule/bql/rc/bql'], function (baja, types, lexs, $, _, Promise, events, Widget, BaseEditor, fe, Command, CommandButton, batchSaveMixin, subscriberMixin, saveUtil, template) {
  "use strict";

  var lex = lexs[0],
    save = saveUtil.save,
    EnumRange = baja.EnumRange,
    clearLabel = lex.get('filter.clearBits.label'),
    setLabel = lex.get('filter.setAllBits.label'),
    clearIcon = 'module://icons/x16/braces.png',
    setIcon = 'module://icons/x16/bracesAsterisk.png',
    INCLUDE_LABEL_SELECTOR = ".includeLabel",
    EXCLUDE_LABEL_SELECTOR = ".excludeLabel",
    INCLUDE_EDITOR_CLASS = "includeEditor",
    EXCLUDE_EDITOR_CLASS = "excludeEditor",
    CLEAR_INCLUDE_CLASS = "clearInclude",
    CLEAR_EXCLUDE_CLASS = "clearExclude",
    SET_INCLUDE_CLASS = "setInclude",
    SET_EXCLUDE_CLASS = "setExclude",
    INCLUDE_EDITOR_SELECTOR = "." + INCLUDE_EDITOR_CLASS,
    EXCLUDE_EDITOR_SELECTOR = "." + EXCLUDE_EDITOR_CLASS,
    CLEAR_INCLUDE_SELECTOR = "." + CLEAR_INCLUDE_CLASS,
    CLEAR_EXCLUDE_SELECTOR = "." + CLEAR_EXCLUDE_CLASS,
    SET_INCLUDE_SELECTOR = "." + SET_INCLUDE_CLASS,
    SET_EXCLUDE_SELECTOR = "." + SET_EXCLUDE_CLASS,
    SELECTORS = [INCLUDE_EDITOR_SELECTOR, EXCLUDE_EDITOR_SELECTOR, CLEAR_INCLUDE_SELECTOR, CLEAR_EXCLUDE_SELECTOR, SET_INCLUDE_SELECTOR, SET_EXCLUDE_SELECTOR].join(','),
    ENABLE_EVENT = events.ENABLE_EVENT,
    DISABLE_EVENT = events.DISABLE_EVENT,
    MODIFY_EVENT = events.MODIFY_EVENT,
    INITIALIZE_EVENT = events.INITIALIZE_EVENT,
    LOAD_EVENT = events.LOAD_EVENT,
    READONLY_EVENT = events.READONLY_EVENT,
    WRITABLE_EVENT = events.WRITABLE_EVENT,
    DESTROY_EVENT = events.DESTROY_EVENT,
    EVENTS = [ENABLE_EVENT, DISABLE_EVENT, READONLY_EVENT, WRITABLE_EVENT, INITIALIZE_EVENT, LOAD_EVENT, DESTROY_EVENT].join(' ');
  function clear(bitStringEditor) {
    var enumFilter = bitStringEditor.value(),
      enumType = enumFilter.getEnumType();
    enumFilter = baja.$('bql:EnumFilter');
    enumFilter.setEnumType(enumType);
    return bitStringEditor.load(enumFilter).then(function () {
      bitStringEditor.setModified(true);
    });
  }
  function set(bitStringEditor) {
    var enumFilter = bitStringEditor.value(),
      enumType = enumFilter.getEnumType(),
      enumRange = enumType.getRange(),
      vector = baja.$('baja:Vector');
    enumFilter = baja.$('bql:EnumFilter');
    enumFilter.setEnumType(enumType);
    _.each(enumRange.getOrdinals(), function (ordinal) {
      vector.add({
        slot: 'e?',
        value: enumRange.get(ordinal)
      });
    });
    enumFilter.setEnumValues(vector);
    return bitStringEditor.load(enumFilter).then(function () {
      bitStringEditor.setModified(true);
    });
  }
  function initBitStringEditors(editor) {
    return Promise.all(_.map([INCLUDE_EDITOR_SELECTOR, EXCLUDE_EDITOR_SELECTOR], function (selector) {
      var enumFilter = baja.$('bql:EnumFilter');
      return fe.buildFor({
        dom: $(selector, editor.jq()),
        value: enumFilter,
        formFactor: 'mini'
      });
    })).then(function () {
      return editor;
    });
  }
  function initCommands(editor) {
    var bitStringEditors = editor.$getBitStringEditors(),
      incEd = bitStringEditors[0],
      excEd = bitStringEditors[1];
    function buildMap() {
      var map = {};
      map[CLEAR_INCLUDE_SELECTOR] = {
        desc: clearLabel,
        icon: clearIcon,
        func: clear,
        ed: incEd
      };
      map[CLEAR_EXCLUDE_SELECTOR] = {
        desc: clearLabel,
        icon: clearIcon,
        func: clear,
        ed: excEd
      };
      map[SET_INCLUDE_SELECTOR] = {
        desc: setLabel,
        icon: setIcon,
        func: set,
        ed: incEd
      };
      map[SET_EXCLUDE_SELECTOR] = {
        desc: setLabel,
        icon: setIcon,
        func: set,
        ed: excEd
      };
      return map;
    }
    return Promise.all(_.map(buildMap(), function (properties, selector) {
      return fe.buildFor({
        dom: $(selector, editor.jq()),
        type: CommandButton,
        formFactor: 'mini',
        value: new Command({
          description: properties.desc,
          icon: properties.icon,
          func: function func() {
            return properties.func(properties.ed);
          }
        })
      });
    }));
  }

  /**
   * BitStringFilterEditor is a field editor for a bql:BitStringFilter instance
   * @class
   * @alias module:nmodule/bql/rc/fe/filter/BitStringFilterEditor
   * @extends module:nmodule/webEditors/rc/fe/baja/BaseEditor
   */
  var BitStringFilterEditor = function BitStringFilterEditor() {
    BaseEditor.apply(this, arguments);
    batchSaveMixin(this);
    subscriberMixin(this);
  };
  BitStringFilterEditor.prototype = Object.create(BaseEditor.prototype);
  BitStringFilterEditor.prototype.constructor = BitStringFilterEditor;

  /**
   * Returns an Array of String labels for the include/exclude fields
   * @private
   * @returns {Array} Array of Strings
   */
  BitStringFilterEditor.prototype.$getLabels = function () {
    var that = this;
    return _.map([INCLUDE_LABEL_SELECTOR, EXCLUDE_LABEL_SELECTOR], function (selector) {
      return that.jq().find(selector).text();
    });
  };

  /**
   * Returns an Array of EnumFilterEditors for the include/exclude bit fields
   * @private
   * @returns {Array} Array of EnumFilterEditors
   * @see module:nmodule/bql/rc/fe/filter/EnumFilterEditor
   */
  BitStringFilterEditor.prototype.$getBitStringEditors = function () {
    var that = this;
    return _.map([INCLUDE_EDITOR_SELECTOR, EXCLUDE_EDITOR_SELECTOR], function (selector) {
      return Widget["in"](that.jq().find(selector));
    });
  };

  /**
   * Returns an Array of CommandButtons for clearing the include/exclude bit fields
   * @private
   * @returns {Array} Array of CommandButtons
   * @see bajaux/util/CommandButton
   */
  BitStringFilterEditor.prototype.$getClearCommands = function () {
    var that = this;
    return _.map([CLEAR_INCLUDE_SELECTOR, CLEAR_EXCLUDE_SELECTOR], function (selector) {
      return Widget["in"](that.jq().find(selector));
    });
  };

  /**
   * Returns an Array of CommandButtons for setting the include/exclude bit fields
   * @private
   * @returns {Array} Array of CommandButtons
   * @see bajaux/util/CommandButton
   */
  BitStringFilterEditor.prototype.$getSetCommands = function () {
    var that = this;
    return _.map([SET_INCLUDE_SELECTOR, SET_EXCLUDE_SELECTOR], function (selector) {
      return Widget["in"](that.jq().find(selector));
    });
  };

  /**
   * Initializes the DOM with EnumFilterEditor fields for the filter's 'include' and 'exclude' properties,
   * and commands to clear/set the bits in the include/exclude editors
   * @param dom The jQuery DOM element to be initialized
   * @returns {Promise}
   */
  BitStringFilterEditor.prototype.doInitialize = function (dom) {
    var that = this;

    //prevent child editors from bubbling events
    dom.addClass("BitStringFilterEditor").on(EVENTS, SELECTORS, false).on(MODIFY_EVENT, SELECTORS, function () {
      that.setModified(true);
      return false;
    });

    //load template
    dom.html(template({
      includeLabel: lex.get('filter.bitsToInclude'),
      excludeLabel: lex.get('filter.bitsToExclude')
    }));
    return initBitStringEditors(this).then(initCommands);
  };

  /**
   * Loads the editor with a bql:BitStringFilter
   * @param filter An instance of bql:BitStringFilter
   * @returns {Promise} Promise resolved when the editor has been loaded with the filter
   */
  BitStringFilterEditor.prototype.doLoad = function (filter) {
    var editors = this.$getBitStringEditors(),
      includeEditor = editors[0],
      excludeEditor = editors[1];
    return Promise.all(_.map([[filter.getInclude(), includeEditor], [filter.getExclude(), excludeEditor]], function (pair) {
      var bitString = pair[0],
        editor = pair[1],
        enumFilter = baja.$('bql:EnumFilter'),
        enumSet = bitString.toEnumSet && bitString.toEnumSet(),
        ordinals = enumSet ? enumSet.getOrdinals() : [],
        enumRange = enumSet ? enumSet.getRange() : EnumRange.DEFAULT,
        vector = baja.$('baja:Vector');
      if (enumRange === EnumRange.DEFAULT) {
        return Promise.resolve();
      }
      _.each(ordinals, function (ordinal) {
        vector.add({
          slot: "e?",
          value: enumRange.get(ordinal)
        });
      });
      enumFilter.setEnumType(enumRange.get(enumRange.getOrdinals()[0]));
      enumFilter.setEnumValues(vector);
      return editor.load(enumFilter);
    }));
  };

  /**
   * Reads the current value of the filter
   * @returns {Promise} Promise resolved with a new instance of a bql:BitStringFilter with properties
   * set to the values read from the corresponding include/exclude bit string editor fields.
   */
  BitStringFilterEditor.prototype.doRead = function () {
    var editors = this.$getBitStringEditors(),
      includeBitString = this.value().getInclude(),
      excludeBitString = this.value().getExclude();
    function makeBitString(enumFilter, exclude) {
      var enumValues = enumFilter.getEnumValues(),
        enums = enumValues.getSlots().properties().dynamic().toValueArray(),
        bitString = exclude ? excludeBitString : includeBitString,
        bits = _.reduce(enums, function (memo, _enum) {
          return memo | _enum.getOrdinal();
        }, 0);
      return bitString.decodeFromString(bits.toString(16));
    }
    return Promise.all(_.map(editors, function (editor) {
      return editor.read();
    })).then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 2),
        incEnumFilter = _ref2[0],
        excEnumFilter = _ref2[1];
      return baja.$('bql:BitStringFilter', {
        include: makeBitString(incEnumFilter, false),
        exclude: makeBitString(excEnumFilter, true)
      });
    });
  };

  /**
   * Saves the current editor values to the loaded filter
   * @param filter bql:BitStringFilter instance returned by BitStringFilterEditor#read()
   * @param params Extra params passed to doSave()
   * @returns {Promise} Promise resolved with the filter initially loaded into the editor
   */
  BitStringFilterEditor.prototype.doSave = function (filter, params) {
    return save(this, filter, params);
  };

  /**
   * Sets the child editors' and commands' readonly status
   * @param readonly Boolean flag indicating readonly status
   * @returns {Promise} Promise
   */
  BitStringFilterEditor.prototype.doReadonly = function (readonly) {
    var editorsPromise = this.getChildEditors().setAllReadonly(readonly),
      commandsPromise = Promise.all(_.map(_.flatten([this.$getClearCommands(), this.$getSetCommands()]), function (command) {
        return command.setReadonly(readonly);
      }));
    return Promise.all([editorsPromise, commandsPromise]);
  };

  /**
   * Sets the child editors' and commands' enabled status
   * @param enabled Boolean flag indicating enabled status
   * @returns {Promise} Promise
   */
  BitStringFilterEditor.prototype.doEnabled = function (enabled) {
    var editorsPromise = this.getChildEditors().setAllEnabled(enabled),
      commandsPromise = Promise.all(_.map(_.flatten([this.$getClearCommands(), this.$getSetCommands()]), function (command) {
        return command.setEnabled(enabled);
      }));
    return Promise.all([editorsPromise, commandsPromise]);
  };

  /**
   * Destroys the child editors and commands
   * @returns {Promise} Promise
   */
  BitStringFilterEditor.prototype.doDestroy = function () {
    this.jq().removeClass('BitStringFilterEditor');
    var editorsPromise = this.getChildEditors().destroyAll(),
      commandsPromise = Promise.all(_.map(_.flatten([this.$getClearCommands(), this.$getSetCommands()]), function (command) {
        return command.destroy();
      }));
    return Promise.all([editorsPromise, commandsPromise]);
  };
  return BitStringFilterEditor;
});
