function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2021 Tridium, Inc. All Rights Reserved.
 */

/** @jsx spandrel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/bql/rc/builder/commands/LoadFromUserDataCommand
 */
define(['bajaux/commands/Command', 'bajaux/commands/CommandGroup', 'bajaux/spandrel', 'Promise', 'nmodule/webEditors/rc/servlets/userData', 'nmodule/webEditors/rc/wb/menu/CommandGroupContextMenu'], function (Command, CommandGroup, spandrel, Promise, userData, CommandGroupContextMenu) {
  'use strict';

  var get = userData.get;

  /**
   * A command to load in data from an object stored in user data.
   *
   * @class
   * @alias module:nmodule/bql/rc/builder/LoadFromUserDataCommand
   * @extends module:bajaux/commands/Command
   */
  var LoadFromUserDataCommand = /*#__PURE__*/function (_Command) {
    /**
     * Get the user to select which data to load from their user data and then load it into the
     * given callback.
     *
     * @param {Object} params
     * @param {String} params.userDataKey the key to get the user's data from in storage
     * @param {Function} params.loadValue a function to be called with the selected value string
     */
    function LoadFromUserDataCommand(_ref) {
      var _this;
      var userDataKey = _ref.userDataKey,
        _ref$loadValue = _ref.loadValue,
        loadValue = _ref$loadValue === void 0 ? function () {} : _ref$loadValue;
      _classCallCheck(this, LoadFromUserDataCommand);
      _this = _callSuper(this, LoadFromUserDataCommand, [{
        module: 'bql',
        lex: 'commands.LoadFromUserDataCommand',
        func: function func(value) {
          return loadValue(value);
        }
      }]);
      _this.$userDataKey = userDataKey;
      return _this;
    }

    /**
     * @param {JQuery.event} event
     * @returns {Promise}
     */
    _inherits(LoadFromUserDataCommand, _Command);
    return _createClass(LoadFromUserDataCommand, [{
      key: "invokeFromEvent",
      value: function invokeFromEvent(event) {
        return LoadFromUserDataCommand.$invokeWithPopup(this, event, this.$userDataKey);
      }

      /**
       * @private
       * @param {module:bajaux/commands/Command} cmd
       * @param {JQuery.Event} event
       * @param {String} userDataKey
       * @returns {Promise}
       */
    }], [{
      key: "$invokeWithPopup",
      value: function $invokeWithPopup(cmd, event, userDataKey) {
        return get(userDataKey).then(function (str) {
          var obj = str ? JSON.parse(str) : {};
          var commands = Object.keys(obj).map(function (key) {
            return new Command({
              displayName: key,
              func: function func() {
                return cmd.invoke(obj[key]);
              }
            });
          });
          var group = new CommandGroup({
            commands: commands
          });
          return CommandGroupContextMenu.show({
            event: event,
            group: group
          });
        });
      }
    }]);
  }(Command);
  return LoadFromUserDataCommand;
});
