function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _superPropGet(t, e, o, r) { var p = _get(_getPrototypeOf(1 & r ? t.prototype : t), e, o); return 2 & r && "function" == typeof p ? function (t) { return p.apply(o, t); } : p; }
function _get() { return _get = "undefined" != typeof Reflect && Reflect.get ? Reflect.get.bind() : function (e, t, r) { var p = _superPropBase(e, t); if (p) { var n = Object.getOwnPropertyDescriptor(p, t); return n.get ? n.get.call(arguments.length < 3 ? e : r) : n.value; } }, _get.apply(null, arguments); }
function _superPropBase(t, o) { for (; !{}.hasOwnProperty.call(t, o) && null !== (t = _getPrototypeOf(t));); return t; }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2021 Tridium, Inc. All Rights Reserved.
 */

/** @jsx spandrel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/bql/rc/builder/BqlQueryBuilder
 */
define(['baja!', 'baja!bql:DynamicTimeRange,bql:Select,bajaui:Button,bajaui:ButtonStyle', 'lex!workbench,bql', 'log!nmodule.bql.rc.builder.BqlQueryBuilder', 'bajaux/commands/Command', 'bajaux/spandrel', 'bajaux/util/CommandButton', 'bajaux/Widget', 'Promise', 'underscore', 'nmodule/bajaui/rc/ux/UxCommandButton', 'nmodule/bql/rc/builder/ColumnChooser', 'nmodule/bql/rc/builder/commands/EditSavedQueriesCommand', 'nmodule/bql/rc/builder/ExpressionChooser', 'nmodule/bql/rc/builder/ExtentTypeChooser', 'nmodule/bql/rc/builder/commands/LoadFromUserDataCommand', 'nmodule/bql/rc/builder/OrdDisplayWidget', 'nmodule/bql/rc/builder/commands/SaveToUserDataCommand', 'nmodule/bql/rc/fe/DynamicTimeRangeEditor', 'nmodule/bql/rc/util/DynamicTimeRange', 'nmodule/bql/rc/util/parseBql', 'nmodule/webEditors/rc/fe/BaseWidget', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/wb/commands/GoToCommand', 'nmodule/webEditors/rc/wb/links/OrdChooser', 'nmodule/webEditors/rc/wb/options/MruButton', 'nmodule/webEditors/rc/wb/options/MruOptions', 'nmodule/webEditors/rc/wb/tree/BajaSlotTreeNode', 'nmodule/webEditors/rc/util/textUtils', 'css!nmodule/bql/rc/bql'], function (baja, types, lexs, log, Command, spandrel, CommandButton, Widget, Promise, _, UxCommandButton, ColumnChooser, EditSavedQueriesCommand, ExpressionChooser, ExtentTypeChooser, LoadFromUserDataCommand, OrdDisplayWidget, SaveToUserDataCommand, DynamicTimeRangeEditor, DynamicTimeRange, parseBql, BaseWidget, feDialogs, GoToCommand, OrdChooser, MruButton, MruOptions, BajaSlotTreeNode, textUtils) {
  'use strict';

  var logSevere = log.severe.bind(log);
  var _lexs = _slicedToArray(lexs, 2),
    workbenchLex = _lexs[0],
    bqlLex = _lexs[1];
  var toFriendly = textUtils.toFriendly;
  var first = _.first,
    flatten = _.flatten;
  var WILDCARD = '*';
  var miniFormFactor = Widget.formfactor.mini;
  var VALUE_READY_EVENT = BaseWidget.VALUE_READY_EVENT;
  var isNullOrd = parseBql.isNullOrd,
    isHistoryOrd = parseBql.isHistoryOrd,
    getExtent = parseBql.getExtent,
    getProjection = parseBql.getProjection,
    getPredicateInfo = parseBql.getPredicateInfo,
    resolvePredefinedColumns = parseBql.resolvePredefinedColumns,
    setExtent = parseBql.setExtent,
    setProjection = parseBql.setProjection,
    setPredicateInfo = parseBql.setPredicateInfo,
    toSelect = parseBql.toSelect,
    toSimplifiedBqlBody = parseBql.toSimplifiedBqlBody;
  var TOOLBAR_BUTTON_STYLE = baja.$('bajaui:ButtonStyle', 'toolBar');
  var DEFAULT_TYPE_SPEC = baja.$('baja:TypeSpec', 'baja:Component');
  var DEFAULT_TIME_RANGE = baja.$('bql:DynamicTimeRange');
  var DEFAULT_ROOT_ORD = baja.Ord.make('station:|slot:/');
  var DEFAULT_COLUMN_CHOICE = true;
  var DEFAULT_MATCH_ALL_CHOICE = true;
  var DEFAULT_QUERY_ORD = baja.Ord.make('station:|slot:/|bql:select * from baja:Component');
  var defaultState = function defaultState(ord) {
    return {
      extent: DEFAULT_TYPE_SPEC,
      timeRange: DEFAULT_TIME_RANGE,
      projectionColumns: [],
      projectionExpressions: [],
      rootOrd: DEFAULT_ROOT_ORD,
      ordString: String(ord),
      columnMode: DEFAULT_COLUMN_CHOICE,
      predefinedColumns: [],
      matchAll: DEFAULT_MATCH_ALL_CHOICE,
      expressions: []
    };
  };
  var FIND_TEXT = workbenchLex.get('bqlQueryBuilder.find');
  var CHOOSE_TEXT = workbenchLex.get('bqlQueryBuilder.choose');
  var MATCH_TEXT = workbenchLex.get('bqlQueryBuilder.qualifier');
  var IN_TEXT = workbenchLex.get('bqlQueryBuilder.in');
  var OF_TYPE_TEXT = workbenchLex.get('bqlQueryBuilder.ofType');
  var DEFAULT_SAVE_KEY_TEXT = bqlLex.get('commands.BqlQueryBuilder.defaultSaveName');
  var MRU_NAME = 'bqlQueryFE';
  var resolveMruOptions = function resolveMruOptions() {
    return MruOptions.make(MRU_NAME);
  };
  var SAVE_DATA_KEY = 'BqlQueryBuilderSavedQueries';
  var widgetDefaults = function widgetDefaults() {
    return {
      properties: {
        rootCssClass: '-t-BqlBuilder'
      }
    };
  };
  var SelectOrdCommand = /*#__PURE__*/function (_Command) {
    function SelectOrdCommand(bqlQueryBuilder) {
      _classCallCheck(this, SelectOrdCommand);
      return _callSuper(this, SelectOrdCommand, [{
        func: function func() {
          feDialogs.showFor({
            type: OrdChooser,
            value: bqlQueryBuilder.state().rootOrd,
            formFactor: 'compact',
            properties: {
              displayFilter: function displayFilter(parent, child) {
                if (baja.hasType(child.value(), 'baja:Component')) {
                  return true;
                }
                return !(child instanceof BajaSlotTreeNode);
              },
              rootNode: bqlQueryBuilder.properties().getValue('rootNode'),
              showOrdText: false
            }
          }).then(function (selectedOrd) {
            return bqlQueryBuilder.$setRootOrd(selectedOrd);
          })["catch"](logSevere);
        },
        module: 'bql',
        lex: 'commands.BqlQueryBuilder.selectRootOrd'
      }]);
    }
    _inherits(SelectOrdCommand, _Command);
    return _createClass(SelectOrdCommand);
  }(Command);
  var AddColumn = /*#__PURE__*/function (_Command2) {
    function AddColumn(_ref) {
      var func = _ref.func;
      _classCallCheck(this, AddColumn);
      return _callSuper(this, AddColumn, [{
        func: func,
        module: 'bql',
        lex: 'commands.BqlQueryBuilder.addColumn'
      }]);
    }
    _inherits(AddColumn, _Command2);
    return _createClass(AddColumn);
  }(Command);
  var RemoveColumn = /*#__PURE__*/function (_Command3) {
    function RemoveColumn(_ref2) {
      var func = _ref2.func;
      _classCallCheck(this, RemoveColumn);
      return _callSuper(this, RemoveColumn, [{
        func: func,
        module: 'bql',
        lex: 'commands.BqlQueryBuilder.removeColumn'
      }]);
    }
    _inherits(RemoveColumn, _Command3);
    return _createClass(RemoveColumn);
  }(Command);
  var AddExpression = /*#__PURE__*/function (_Command4) {
    function AddExpression(_ref3) {
      var func = _ref3.func;
      _classCallCheck(this, AddExpression);
      return _callSuper(this, AddExpression, [{
        func: func,
        module: 'bql',
        lex: 'commands.BqlQueryBuilder.addExpression'
      }]);
    }
    _inherits(AddExpression, _Command4);
    return _createClass(AddExpression);
  }(Command);
  var RemoveExpression = /*#__PURE__*/function (_Command5) {
    function RemoveExpression(_ref4) {
      var func = _ref4.func;
      _classCallCheck(this, RemoveExpression);
      return _callSuper(this, RemoveExpression, [{
        func: func,
        module: 'bql',
        lex: 'commands.BqlQueryBuilder.removeExpression'
      }]);
    }
    _inherits(RemoveExpression, _Command5);
    return _createClass(RemoveExpression);
  }(Command);
  /**
   * An editor for creating BQL queries.
   *
   * Supports the following Properties:
   *
   * - `hideProjection`: set to `true` to hide the projection settings (default: `false`)
   * - `hideRootNode`: set to `true` to hide the root node selection (default: `false`)
   *
   * @class
   * @extends module:bajaux/Widget
   * @alias module:nmodule/bql/rc/builder/BqlQueryBuilder
   *
   */
  var BqlQueryBuilder = /*#__PURE__*/function (_spandrel) {
    function BqlQueryBuilder(params) {
      var _this;
      _classCallCheck(this, BqlQueryBuilder);
      _this = _callSuper(this, BqlQueryBuilder, [{
        params: params,
        defaults: widgetDefaults()
      }]);
      _this.$saveCmd = new SaveToUserDataCommand({
        name: DEFAULT_SAVE_KEY_TEXT,
        value: function value() {
          return _this.read().then(function (value) {
            return value.encodeToString();
          });
        },
        userDataKey: SAVE_DATA_KEY
      });
      _this.$loadOrd = function (value) {
        return _this.load(baja.Ord.make(value));
      };
      _this.$loadCmd = new LoadFromUserDataCommand({
        loadValue: _this.$loadOrd,
        userDataKey: SAVE_DATA_KEY
      });
      _this.$editCmd = new EditSavedQueriesCommand({
        userDataKey: SAVE_DATA_KEY
      });
      _this.$addCmd = new AddColumn({
        func: function func() {
          return _this.$getProjectionSection().addColumn();
        }
      });
      _this.$addExpressionCmd = new AddExpression({
        func: function func() {
          return _this.$getExpressionSection().addExpression();
        }
      });
      _this.$selectOrdCmd = new SelectOrdCommand(_this);
      _this.$gotoCmd = new GoToCommand(_this);
      _this.on(VALUE_READY_EVENT, function (value) {
        var extentWidget = _this.$getExtentWidget();
        if (extentWidget) {
          extentWidget.emit(VALUE_READY_EVENT, _this.state().extent);
        }
        if (!baja.hasType(value, 'baja:Ord')) {
          return;
        }
        resolveMruOptions().then(function (options) {
          options.add(value.encodeToString());
          return options.save();
        })["catch"](logSevere);
      });
      return _this;
    }
    _inherits(BqlQueryBuilder, _spandrel);
    return _createClass(BqlQueryBuilder, [{
      key: "doInitialize",
      value: function doInitialize() {
        var _arguments = arguments,
          _this2 = this;
        return resolveMruOptions().then(function (mruOptions) {
          _this2.state({
            mruOptions: mruOptions
          });
          return _superPropGet(BqlQueryBuilder, "doInitialize", _this2, 3)(_arguments);
        });
      }

      /**
       * @param {baja.Ord} ord
       * @return {Promise.<module:nmodule/bql/rc/builder/BqlQueryBuilder~BqlQueryBuilderState>}
       */
    }, {
      key: "toState",
      value: function toState(ord) {
        var _this3 = this;
        if (!ord || isNullOrd(ord.toString())) {
          return Promise.resolve(defaultState(ord));
        }
        var ordString = ord.toString();
        var _splitIntoRootAndBqlO = splitIntoRootAndBqlOrd(ordString),
          _splitIntoRootAndBqlO2 = _slicedToArray(_splitIntoRootAndBqlO, 2),
          rootOrd = _splitIntoRootAndBqlO2[0],
          bqlOrd = _splitIntoRootAndBqlO2[1];
        var lowercaseBqlOrd = bqlOrd.toLowerCase();
        var isHistory = isHistoryOrd(rootOrd);
        var timeRange = isHistory ? parseSelectedTimeRange(rootOrd) : DEFAULT_TIME_RANGE;
        var rootOrdWithoutTimeRange = baja.Ord.make(isHistory ? rootOrd.split("?")[0] : rootOrd);
        rootOrd = baja.Ord.make(rootOrd);
        return Promise["try"](function () {
          rootOrd.parse();
          return _this3.getFormFactor() !== 'mini' && rootOrd.resolve();
        }).then(function () {
          if (lowercaseBqlOrd.indexOf("select") < 0) {
            if (lowercaseBqlOrd.indexOf(" ") > -1 || !lowercaseBqlOrd) {
              return defaultState(ord);
            }
            return {
              extent: DEFAULT_TYPE_SPEC,
              timeRange: timeRange,
              projectionColumns: [{
                fieldPath: bqlOrd,
                alias: toFriendly(bqlOrd)
              }],
              projectionExpressions: [{
                fieldPath: bqlOrd,
                alias: toFriendly(bqlOrd)
              }],
              rootOrd: rootOrdWithoutTimeRange,
              columnMode: false,
              expressions: [],
              matchAll: true,
              ordString: ordString
            };
          }
          return toSelect(bqlOrd).then(function (select) {
            var typeSpecStr = select && getExtent(select);
            var typeSpec = typeSpecStr ? baja.$('baja:TypeSpec', typeSpecStr) : DEFAULT_TYPE_SPEC;
            var projectionColumns = select && getProjection(select);
            if (projectionColumns.length === 1 && projectionColumns[0].fieldPath === WILDCARD) {
              projectionColumns = [];
            }
            var predicateInfo = select && getPredicateInfo(select); //TODO?
            var matchAll = predicateInfo.matchAll,
              expressions = predicateInfo.expressions;
            return Promise.resolve(typeSpecStr && baja.importTypes([typeSpecStr]))["catch"](function () {
              typeSpec = DEFAULT_TYPE_SPEC;
            }).then(function () {
              return {
                extent: typeSpec,
                timeRange: timeRange,
                projectionColumns: projectionColumns,
                projectionExpressions: projectionColumns.length ? [projectionColumns[0]] : [],
                rootOrd: rootOrdWithoutTimeRange,
                columnMode: DEFAULT_COLUMN_CHOICE,
                matchAll: matchAll,
                expressions: expressions,
                ordString: ordString
              };
            });
          });
        })["catch"](function (err) {
          logSevere(err);
          if (_this3.getFormFactor() === miniFormFactor) {
            return defaultState(ord);
          } else {
            return defaultState(DEFAULT_QUERY_ORD);
          }
        });
      }

      /**
       * @param {module:nmodule/bql/rc/builder/BqlQueryBuilder~BqlQueryBuilderState} state
       * @return {baja.Ord|Promise.<baja.Ord>}
       */
    }, {
      key: "fromState",
      value: function fromState(state) {
        var extent = state.extent,
          projectionColumns = state.projectionColumns,
          projectionExpressions = state.projectionExpressions,
          rootOrd = state.rootOrd,
          timeRange = state.timeRange,
          columnMode = state.columnMode,
          matchAll = state.matchAll,
          expressions = state.expressions,
          ordString = state.ordString;
        if (this.getFormFactor() === miniFormFactor) {
          return baja.Ord.make(ordString);
        }
        var base = isHistoryOrd(rootOrd) ? getOrdWithTimeRange(rootOrd, timeRange) : rootOrd;
        if (!columnMode) {
          return Promise.resolve(projectionExpressions[0] || resolvePredefinedColumns({
            extent: extent,
            rootOrd: rootOrd,
            columnMode: columnMode
          }).then(function (predefinedColumns) {
            return getProjectionToLoad(state, predefinedColumns);
          }).then(first)).then(function (expressionColumn) {
            return baja.Ord.make({
              base: base,
              child: "bql:".concat(expressionColumn.fieldPath)
            });
          });
        }
        var select = baja.$('bql:Select');
        setExtent(select, extent, extent.encodeToString() === 'schedule:AbstractSchedule');
        setProjection(select, projectionColumns.length ? projectionColumns : [column(WILDCARD)]);
        setPredicateInfo(select, {
          expressions: expressions,
          matchAll: matchAll
        });
        return baja.Ord.make({
          base: base,
          child: "bql:".concat(toSimplifiedBqlBody(select, rootOrd))
        });
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getExtentWidget",
      value: function $getExtentWidget() {
        return this.queryWidget('find/**/extent');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getTimeRangeWidget",
      value: function $getTimeRangeWidget() {
        return this.queryWidget('find/**/timeRange');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getRootOrdDisplay",
      value: function $getRootOrdDisplay() {
        return this.queryWidget('find/**/rootOrdDisplay');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getLoadButton",
      value: function $getLoadButton() {
        return this.queryWidget('commands/**/load');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getSaveButton",
      value: function $getSaveButton() {
        return this.queryWidget('commands/**/save');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getEditButton",
      value: function $getEditButton() {
        return this.queryWidget('commands/**/edit');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getMruButton",
      value: function $getMruButton() {
        return this.queryWidget('commands/**/mru');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getSelectRootOrdButton",
      value: function $getSelectRootOrdButton() {
        return this.queryWidget('find/**/selectRootOrdButton');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getColumnModeEditor",
      value: function $getColumnModeEditor() {
        return this.queryWidget('choose/**/columnMode');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getAddProjectionColumnButton",
      value: function $getAddProjectionColumnButton() {
        return this.queryWidget('choose/**/addProjectionColumnButton');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getProjectionSection",
      value: function $getProjectionSection() {
        return this.queryWidget('choose/projection');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getExpressionSection",
      value: function $getExpressionSection() {
        return this.queryWidget('match/expressions');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getMatchAllEditor",
      value: function $getMatchAllEditor() {
        return this.queryWidget('match/**/matchAll');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getAddExpressionColumnButton",
      value: function $getAddExpressionColumnButton() {
        return this.queryWidget('match/**/addExpressionColumnButton');
      }

      /**
       * @private
       * @returns {Array.<module:bajaux/Widget>}
       */
    }, {
      key: "$getRemoveExpressionColumnButtons",
      value: function $getRemoveExpressionColumnButtons() {
        return this.$getExpressionSection().$getRemoveButtons();
      }

      /**
       * @private
       * @returns {module:bajaux/Widget|undefined}
       */
    }, {
      key: "$getMiniEditor",
      value: function $getMiniEditor() {
        return this.getFormFactor() === miniFormFactor ? this.queryWidget('ordString') : undefined;
      }

      /**
       * @param {baja.Ord} rootOrd
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$setRootOrd",
      value: function $setRootOrd(rootOrd) {
        var _this4 = this;
        if (!rootOrd) {
          return Promise.resolve();
        }
        var rootOrdStr = rootOrd.encodeToString();
        var previousOrdStr = this.state().rootOrd.encodeToString();
        if (rootOrdStr === previousOrdStr) {
          return Promise.resolve();
        }
        return this.state({
          rootOrd: rootOrd
        }).then(function () {
          return _this4.setModified(true);
        });
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getGoToCommand",
      value: function $getGoToCommand() {
        return this.queryWidget('goto');
      }
    }]);
  }(spandrel(function (value, state) {
    var columnMode = state.columnMode,
      expressions = state.expressions,
      extent = state.extent,
      formFactor = state.formFactor,
      matchAll = state.matchAll,
      mruOptions = state.mruOptions,
      ordString = state.ordString,
      props = state.props,
      rootElement = state.rootElement,
      rootOrd = state.rootOrd,
      self = state.self,
      timeRange = state.timeRange,
      writable = state.writable;
    var buttonProperties = {
      enabled: writable,
      buttonStyle: TOOLBAR_BUTTON_STYLE
    };
    var addButtonProperties = {
      enabled: writable && columnMode,
      buttonStyle: TOOLBAR_BUTTON_STYLE
    };
    if (formFactor === miniFormFactor) {
      return [spandrel.jsx("any", {
        bind: true,
        spandrelKey: "ordString",
        value: ordString
      }), GoToCommand.canAdd(props) && spandrel.jsx(CommandButton, {
        value: self.$gotoCmd,
        tagName: "button",
        type: "button",
        properties: buttonProperties,
        spandrelKey: "goto",
        className: "ux-btn-tb"
      })];
    }
    var classList = rootElement.classList;
    var hideProjection = props.hideProjection,
      hideRootNode = props.hideRootNode,
      rootNode = props.rootNode;
    var isExtentShown = parseBql.isStationOrd(rootOrd) || isHistoryOrd(rootOrd);
    if (!isExtentShown) {
      classList.add('-t-BqlBuilder-noExtentMode');
    }
    if (!columnMode) {
      classList.add('-t-BqlBuilder-expressionMode');
    }
    if (hideProjection) {
      classList.add('-t-BqlBuilder-hideProjection');
    }
    if (hideRootNode) {
      classList.add('-t-BqlBuilder-hideRootNode');
    }
    var isHistory = isHistoryOrd(rootOrd);
    return resolvePredefinedColumns({
      extent: extent,
      rootOrd: rootOrd,
      columnMode: columnMode
    }).then(function (predefinedColumns) {
      return [spandrel.jsx("div", {
        className: "commands",
        spandrelKey: "commands"
      }, spandrel.jsx(UxCommandButton, {
        value: self.$loadCmd,
        properties: buttonProperties,
        spandrelKey: "load",
        className: "bqlCommand"
      }), spandrel.jsx(UxCommandButton, {
        value: self.$saveCmd,
        properties: buttonProperties,
        spandrelKey: "save",
        className: "bqlCommand"
      }), spandrel.jsx(UxCommandButton, {
        value: self.$editCmd,
        properties: buttonProperties,
        spandrelKey: "edit",
        className: "bqlCommand"
      }), spandrel.jsx("div", {
        className: "vertical-divider",
        spandrelKey: "divider"
      }), spandrel.jsx(MruButton, {
        value: {
          options: mruOptions,
          select: self.$loadOrd
        },
        properties: buttonProperties,
        spandrelKey: "mru",
        className: "mru"
      })), spandrel.jsx("div", {
        spandrelKey: "find",
        className: "-t-BqlBuilder-section"
      }, spandrel.jsx("div", {
        className: "-t-BqlBuilder-preventFocus"
      }, spandrel.jsx("input", null)), spandrel.jsx("div", {
        className: "-t-BqlBuilder-section-header"
      }, spandrel.jsx("div", {
        className: "-t-BqlBuilder-section-name"
      }, FIND_TEXT)), spandrel.jsx("div", {
        className: "-t-BqlBuilder-section-row -t-BqlBuilder-find"
      }, spandrel.jsx("div", {
        className: "-t-BqlBuilder-find-subsection -t-BqlBuilder-in"
      }, spandrel.jsx("span", null, IN_TEXT), spandrel.jsx(OrdDisplayWidget, {
        value: rootOrd,
        bindKey: "rootOrd",
        spandrelKey: "rootOrdDisplay",
        properties: {
          rootNode: rootNode
        }
      }), spandrel.jsx(UxCommandButton, {
        value: self.$selectOrdCmd,
        properties: buttonProperties,
        spandrelKey: "selectRootOrdButton",
        className: "-t-BqlBuilder-selectRootOrdButton"
      })), spandrel.jsx("div", {
        className: "-t-BqlBuilder-find-subsection ".concat(isHistory ? '-t-BqlBuilder-timeRange' : '-t-BqlBuilder-type')
      }, getDisplayedFindEditor(isHistory, extent, timeRange)))), spandrel.jsx("div", {
        spandrelKey: "choose",
        className: "-t-BqlBuilder-section -t-BqlBuilder-projection"
      }, spandrel.jsx("div", {
        className: "-t-BqlBuilder-section-header"
      }, spandrel.jsx("div", {
        className: "-t-BqlBuilder-section-name"
      }, CHOOSE_TEXT), spandrel.jsx("any", {
        value: columnMode,
        properties: {
          trueText: "%lexicon(workbench:bqlQueryBuilder.columns)%",
          falseText: "%lexicon(workbench:bqlQueryBuilder.expression)%",
          trueIcon: "%lexicon(baja:neutral.icon)%",
          falseIcon: "%lexicon(baja:neutral.icon)%"
        },
        bind: true,
        spandrelKey: "columnMode",
        className: "-t-columnModeEditor"
      }), spandrel.jsx("div", null, spandrel.jsx(UxCommandButton, {
        spandrelKey: "addProjectionColumnButton",
        value: self.$addCmd,
        properties: addButtonProperties,
        className: "-t-BqlBuilder-addProjectionColumnButton"
      }))), spandrel.jsx(ProjectionSection, {
        className: "-t-BqlBuilder-section-rows",
        lax: true,
        bindKey: columnMode ? 'projectionColumns' : 'projectionExpressions',
        spandrelKey: "projection",
        value: getProjectionToLoad(state, predefinedColumns),
        onUxModifiedValue: function onUxModifiedValue(columns) {
          var firstColumn = columns[0];
          if (firstColumn) {
            // apply the first column as a convenient default for when we switch to the other projection mode
            return self.state(_defineProperty({}, columnMode ? 'projectionExpressions' : 'projectionColumns', [firstColumn]));
          }
        },
        properties: {
          predefinedColumns: predefinedColumns,
          allowDelete: columnMode
        }
      })), spandrel.jsx("div", {
        spandrelKey: "match",
        className: "-t-BqlBuilder-section -t-BqlBuilder-predicate"
      }, spandrel.jsx("div", {
        className: "-t-BqlBuilder-section-header"
      }, spandrel.jsx("div", {
        className: "-t-BqlBuilder-section-name"
      }, MATCH_TEXT), spandrel.jsx("any", {
        value: matchAll,
        properties: {
          trueText: "%lexicon(workbench:bqlQueryBuilder.all)%",
          falseText: "%lexicon(workbench:bqlQueryBuilder.any)%",
          trueIcon: "%lexicon(baja:neutral.icon)%",
          falseIcon: "%lexicon(baja:neutral.icon)%"
        },
        bind: true,
        spandrelKey: "matchAll",
        className: "-t-matchAllEditor"
      }), spandrel.jsx("div", null, spandrel.jsx(UxCommandButton, {
        spandrelKey: "addExpressionColumnButton",
        value: self.$addExpressionCmd,
        properties: addButtonProperties,
        className: "-t-BqlBuilder-addExpressionColumnButton"
      }))), spandrel.jsx(ExpressionSection, {
        className: "-t-BqlBuilder-section-rows",
        bind: true,
        spandrelKey: "expressions",
        value: expressions,
        properties: {
          predefinedColumns: predefinedColumns
        }
      }))];
    });
  }, {
    strategy: 'niagara'
  }));
  /**
   * @param {String} ordStr
   * @inner
   * @returns {Array.<String>} where the first string is the root ord and the second string is the
   * bql query. The root ord will default to the station root if none found.
   */
  function splitIntoRootAndBqlOrd(ordStr) {
    try {
      var list = baja.Ord.make(ordStr).parse();
      for (var i = list.size() - 1; i >= 0; i--) {
        var query = list.get(i);
        list.remove(i);
        if (query.getSchemeName().toLowerCase() === 'bql') {
          var rootOrd = list.toString() || DEFAULT_ROOT_ORD;
          return [rootOrd, query.getBody()];
        }
      }
    } catch (ignore) {}
    return [DEFAULT_ROOT_ORD, ''];
  }
  var ProjectionSection = /*#__PURE__*/function (_spandrel2) {
    function ProjectionSection() {
      _classCallCheck(this, ProjectionSection);
      return _callSuper(this, ProjectionSection, arguments);
    }
    _inherits(ProjectionSection, _spandrel2);
    return _createClass(ProjectionSection, [{
      key: "addColumn",
      value: function addColumn(newColumn) {
        var _this5 = this;
        var predefinedColumns = this.properties().getValue('predefinedColumns');
        return this.read().then(function (projection) {
          return _this5.load(projection.concat(newColumn || predefinedColumns[0]));
        }).then(function () {
          return _this5.setModified(true);
        });
      }
    }, {
      key: "removeColumn",
      value: function removeColumn(index) {
        var _this6 = this;
        return this.read().then(function (readValue) {
          var projection = readValue.slice();
          projection.splice(index, 1);
          return _this6.load(projection).then(function () {
            return _this6.setModified(true);
          });
        });
      }
    }, {
      key: "doRead",
      value: function doRead() {
        return Promise.all(this.$getColumnChoosers().map(function (c) {
          return c.read();
        }));
      }
    }, {
      key: "$getColumnChoosers",
      value: function $getColumnChoosers() {
        return this.getChildWidgets({
          type: ColumnChooser
        });
      }
    }, {
      key: "$getRemoveButtons",
      value: function $getRemoveButtons() {
        return this.getChildWidgets({
          type: UxCommandButton
        });
      }
    }]);
  }(spandrel(function (projection, _ref5) {
    var props = _ref5.props,
      self = _ref5.self,
      writable = _ref5.writable;
    var predefinedColumns = props.predefinedColumns,
      allowDelete = props.allowDelete;
    return flatten(projection.map(function (column, index) {
      if (column.fieldPath === WILDCARD) {
        return [];
      }
      var removeCommand = new RemoveColumn({
        func: function func() {
          return self.removeColumn(index);
        }
      });
      return [spandrel.jsx(ColumnChooser, {
        value: column,
        properties: {
          predefinedColumns: predefinedColumns
        }
      }), allowDelete && spandrel.jsx(UxCommandButton, {
        value: removeCommand,
        properties: {
          enabled: writable,
          buttonStyle: TOOLBAR_BUTTON_STYLE
        }
      })];
    }));
  }));
  var ExpressionSection = /*#__PURE__*/function (_spandrel3) {
    function ExpressionSection() {
      _classCallCheck(this, ExpressionSection);
      return _callSuper(this, ExpressionSection, arguments);
    }
    _inherits(ExpressionSection, _spandrel3);
    return _createClass(ExpressionSection, [{
      key: "addExpression",
      value: function addExpression(newExpression) {
        var _this7 = this;
        var predefinedColumns = this.properties().getValue('predefinedColumns');
        var toAdd = newExpression || {
          fieldPath: predefinedColumns[0].fieldPath,
          type: predefinedColumns[0].type,
          operator: '=',
          matchValue: null
        };
        return this.read().then(function (expressions) {
          return _this7.load(expressions.concat(toAdd)).then(function () {
            return _this7.setModified(true);
          });
        });
      }
    }, {
      key: "removeExpression",
      value: function removeExpression(index) {
        var _this8 = this;
        return this.read().then(function (value) {
          var expressions = value.slice();
          expressions.splice(index, 1);
          return _this8.load(expressions).then(function () {
            return _this8.setModified(true);
          });
        });
      }
    }, {
      key: "doRead",
      value: function doRead() {
        return Promise.all(this.$getExpressionChoosers().map(function (c) {
          return c.read();
        }));
      }
    }, {
      key: "$getExpressionChoosers",
      value: function $getExpressionChoosers() {
        return this.getChildWidgets({
          type: ExpressionChooser
        });
      }
    }, {
      key: "$getRemoveButtons",
      value: function $getRemoveButtons() {
        return this.getChildWidgets({
          type: UxCommandButton
        });
      }
    }]);
  }(spandrel(function (expressions, _ref6) {
    var props = _ref6.props,
      self = _ref6.self,
      writable = _ref6.writable;
    var predefinedColumns = props.predefinedColumns;
    return flatten(expressions.map(function (column, index) {
      var removeCommand = new RemoveExpression({
        func: function func() {
          return self.removeExpression(index);
        }
      });
      return [spandrel.jsx(ExpressionChooser, {
        value: column,
        properties: {
          predefinedColumns: predefinedColumns
        }
      }), spandrel.jsx(UxCommandButton, {
        value: removeCommand,
        properties: {
          enabled: writable,
          buttonStyle: TOOLBAR_BUTTON_STYLE
        }
      })];
    }));
  }));
  function column(fieldPath) {
    return {
      fieldPath: fieldPath
    };
  }
  function parseSelectedTimeRange(ord) {
    var ordStr = ord.toString();
    var splits = ordStr.split("?");
    if (splits.length <= 1) {
      return DEFAULT_TIME_RANGE;
    }
    return DynamicTimeRange.fromOrdParams(splits[1]);
  }
  function getOrdWithTimeRange(ord, timeRange) {
    var ordStr = ord.toString();
    var timeRangeParam = timeRange.toOrdParams();
    if (timeRangeParam === "period=timeRange") {
      return ordStr;
    }
    return baja.Ord.make(ordStr.concat("?".concat(timeRangeParam)));
  }
  function getDisplayedFindEditor(isHistory, extent, timeRange) {
    if (isHistory) {
      return spandrel.jsx(DynamicTimeRangeEditor, {
        value: timeRange,
        bind: true,
        spandrelKey: "timeRange"
      });
    }
    return [spandrel.jsx("span", null, OF_TYPE_TEXT), spandrel.jsx(ExtentTypeChooser, {
      value: extent,
      bind: true,
      spandrelKey: "extent"
    })];
  }

  // if we enter a projection and then switch from column mode to expression mode,
  // we want to keep the first entry as a convenience.
  function getProjectionToLoad(state, predefinedColumns) {
    var columnMode = state.columnMode,
      projectionColumns = state.projectionColumns,
      projectionExpressions = state.projectionExpressions,
      modified = state.modified;
    var projection;
    if (columnMode) {
      if (modified) {
        // if projection columns is empty because we loaded in a "select" ord and then the user
        // deleted the last column, then we respect that empty projection..
        projection = projectionColumns;
      } else {
        // if projection columns is empty because we loaded in an expression ord, then we will use
        // that expression as the default first column.
        projection = projectionColumns.length ? projectionColumns : projectionExpressions;
      }
    } else {
      projection = projectionExpressions.length ? projectionExpressions : projectionColumns.length ? projectionColumns : predefinedColumns;
      // exactly one row required in expression mode
      projection = projection.slice(0, 1);
    }
    return projection;
  }
  return BqlQueryBuilder;
});

/**
 * @typedef module:nmodule/bql/rc/builder/BqlQueryBuilder~BqlQueryBuilderState
 * @extends module:bajaux/spandrel/SpandrelWidget~WidgetState
 * @property {string} ordString - the string encoding of the loaded ORD
 * @property {baja.Ord} rootOrd - the scope we're selecting within
 * @property {Array.<module:nmodule/bql/rc/util/parseBql~column>} projectionColumns - the columns we're selecting
 * when in column mode (the "navOrd" in "bql:select navOrd from baja:Component")
 * @property {Array.<module:nmodule/bql/rc/util/parseBql~column>} projectionExpressions - the expressions we're
 * selecting when in expression mode (the "absoluteOrd" in "bql:absoluteOrd")
 * @property {boolean} columnMode - true for column mode, false for expression mode
 * @property {baja.Simple} extent - the type spec we're selecting from (the "X" in "bql:select * from X")
 * @property {module:nmodule/bql/rc/util/DynamicTimeRange} timeRange - the time range to be
 * used in history queries
 * @property {Array.<module:nmodule/bql/rc/util/parseBql~simpleExpression>} expressions - the expressions
 * we're matching on (the stuff that comes after "where")
 * @property {boolean} matchAll - true to match on all expressions, false to match on any expression
 */
