/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Danesh Kamal
 */

/**
 * API Status: **Private**
 * @module nmodule/alarm/rc/fe/LimitEnableEditor
 */
define(['lex!alarm', 'nmodule/webEditors/rc/fe/baja/ComplexCompositeEditor', 'css!nmodule/alarm/rc/fe/alarmEditors'], function (lexs, ComplexCompositeEditor) {
  'use strict';

  var alarmLex = lexs[0],
    lowText = alarmLex.get('lowLimit.enable'),
    highText = alarmLex.get('highLimit.enable');

  /**
   * Editor for working with `alarm:LimitEnable` values.
   *
   * @class
   * @extends module:nmodule/webEditors/rc/fe/baja/ComplexCompositeEditor
   * @alias module:nmodule/alarm/rc/fe/LimitEnableEditor
   */
  var LimitEnableEditor = function LimitEnableEditor() {
    ComplexCompositeEditor.apply(this, arguments);
  };
  LimitEnableEditor.prototype = Object.create(ComplexCompositeEditor.prototype);
  LimitEnableEditor.prototype.constructor = LimitEnableEditor;

  /**
   * Show inline editors for the `lowLimitEnable` and `highLimitEnable` slots.
   * @returns {Array}
   */
  LimitEnableEditor.prototype.getSlotFilter = function () {
    return [{
      slot: 'lowLimitEnable',
      properties: {
        trueText: lowText,
        falseText: lowText
      }
    }, {
      slot: 'highLimitEnable',
      properties: {
        trueText: highText,
        falseText: highText
      }
    }];
  };
  return LimitEnableEditor;
});
