/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Danesh Kamal
 */

/**
 * API Status: **Private**
 * @module nmodule/alarm/rc/db/editors/Sequencer
 */
define(['jquery', 'lex!alarm', 'log!nmodule/alarm/rc/db/editors/Sequencer', 'Promise', 'bajaux/commands/Command', 'nmodule/alarm/rc/db/commands/NotesCommand', 'nmodule/alarm/rc/db/editors/AlarmDetailsTable'], function ($, lexs, log, Promise, Command, NotesCommand, AlarmDetailsTable) {
  "use strict";

  var logSevere = log.severe.bind(log);
  var Sequencer = function Sequencer() {};
  Sequencer.makeFor = function (table, view) {
    var lex = lexs[0],
      index,
      model = table.getModel(),
      selection = table.$getSelection(),
      rows = model.getRows(),
      DIALOG_SELECTOR = '.js-dialog',
      PREV_BUTTON_SELECTOR = '.js-dialog-button-prev',
      NEXT_BUTTON_SELECTOR = '.js-dialog-button-next';
    function disableButton(selector) {
      $(selector, $(DIALOG_SELECTOR)).attr('disabled', 'disabled');
    }
    function enableButton(selector) {
      $(selector, $(DIALOG_SELECTOR)).removeAttr('disabled', '');
    }
    function enableNextButton() {
      enableButton(NEXT_BUTTON_SELECTOR);
    }
    function disableNextButton() {
      disableButton(NEXT_BUTTON_SELECTOR);
    }
    function enablePreviousButton() {
      enableButton(PREV_BUTTON_SELECTOR);
    }
    function disablePreviousButton() {
      disableButton(PREV_BUTTON_SELECTOR);
    }
    function getSelectedIndex() {
      var i, index;
      for (i = 0; i < rows.length; i++) {
        if (selection.isSelected(i)) {
          index = i;
          break;
        }
      }
      return index;
    }
    function getPreviousAlarm() {
      index = index || index === 0 ? index : getSelectedIndex();
      if (index === rows.length - 1) {
        enableNextButton();
      }
      index -= 1;
      if (index === 0) {
        disablePreviousButton();
      }
      return rows[index].getSubject();
    }
    function getNextAlarm() {
      index = index || index === 0 ? index : getSelectedIndex();
      if (index === 0) {
        enablePreviousButton();
      }
      index += 1;
      if (index === rows.length - 1) {
        disableNextButton();
      }
      return rows[index].getSubject();
    }
    function getCurrentAlarm() {
      index = index || index === 0 ? index : getSelectedIndex();
      return rows[index].getSubject();
    }
    var PrevAlarmCommand = function PrevAlarmCommand() {},
      NextAlarmCommand = function NextAlarmCommand() {},
      SequencerNotesCommand = function SequencerNotesCommand() {};
    PrevAlarmCommand.make = function () {
      return {
        name: 'prev',
        displayName: lex.get('command.prevAlarm.label'),
        handler: function handler() {
          var prevAlarm = getPreviousAlarm(),
            tableDom = $('.table', $('.js-dialog'));
          return Promise.resolve(prevAlarm && AlarmDetailsTable.makeFor(prevAlarm)).then(function (table) {
            if (tableDom && table) {
              tableDom.empty().append(table.jq());
            }
            throw new Error(); //keep the dialog open
          });
        },
        esc: false
      };
    };
    NextAlarmCommand.make = function () {
      return {
        name: 'next',
        displayName: lex.get('command.nextAlarm.label'),
        handler: function handler() {
          var nextAlarm = getNextAlarm(),
            tableDom = $('.table', $('.js-dialog'));
          return Promise.resolve(nextAlarm && AlarmDetailsTable.makeFor(nextAlarm)).then(function (table) {
            if (tableDom && table) {
              tableDom.empty().append(table.jq());
            }
            throw new Error(); //keep the dialog open
          });
        },
        esc: false
      };
    };
    SequencerNotesCommand.make = function () {
      return {
        name: 'notes',
        displayName: lex.get('commands.notes.displayName'),
        handler: function handler() {
          new NotesCommand(view, [getCurrentAlarm()]).invoke()["catch"](logSevere);
          return false;
        }
      };
    };
    return [PrevAlarmCommand.make(), NextAlarmCommand.make(), SequencerNotesCommand.make()];
  };
  return Sequencer;
});
