function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Danesh Kamal
 */

/**
 * API Status: **Private**
 * @module nmodule/alarm/rc/db/editors/Pager
 */
define(['baja!', 'lex!alarm', 'log!nmodule.alarm.rc.db.editors.Pager', 'bajaux/commands/Command', 'bajaux/util/CommandButton', 'dialogs', 'jquery', 'Promise', 'nmodule/alarm/rc/Alarm', 'nmodule/alarm/rc/db/editors/AlarmTable', 'nmodule/alarm/rc/db/editors/AlarmTablePaginationModel', 'nmodule/webEditors/rc/fe/fe'], function (baja, lexs, log, Command, CommandButton, dialogs, $, Promise, Alarm, AlarmTable, AlarmTablePaginationModel, fe) {
  "use strict";

  var lex = lexs[0],
    logSevere = log.severe.bind(log),
    TIME_RANGE_EDITOR_SELECTOR = '.timeRangeEditor',
    ALARM_LIMIT_SELECTOR = '.limitSelector',
    PREV_PAGE_CMD_SELECTOR = '.prevPageCmd',
    NEXT_PAGE_CMD_SELECTOR = '.nextPageCmd',
    PAGE_LOCATION_SELECTOR = '.pageLocation',
    MAINTENANCE_GROUP_SELECTOR = '.maintenance',
    PAGING_SELECTOR = '.paging',
    NEXT_PAGE_LABEL = lex.get('command.nextPage'),
    PREVIOUS_PAGE_LABEL = lex.get('command.previousPage'),
    LIMITS = [10, 25, 50, 75, 100, 250, 500, 1000],
    DEFAULT_LIMIT = LIMITS[4];
  function initLimitSelector(pager) {
    var view = pager.view,
      selectList = $(ALARM_LIMIT_SELECTOR, view.jq());
    selectList.empty();
    LIMITS.forEach(function (limit) {
      var option = $("<option>").val(limit).text(lex.get({
        key: 'alarm.db.perPage',
        args: [limit]
      }));
      selectList.append(option);
    });
    selectList.val(DEFAULT_LIMIT);
    selectList.change(function () {
      var model = pager.$paginationModel;
      model.setRowsPerPage(parseInt(selectList.val(), 10));
      model.setCurrentPage(1)["catch"](logSevere);
    });
  }
  function init(pager, isAlarmArchiveSpace) {
    initLimitSelector(pager);
    pager.$isInitializing = true;
    return Promise.all([makePrevCommand(pager), makeNextCommand(pager), AlarmTable.makeFor(pager.view, pager.$paginationModel, isAlarmArchiveSpace)]).then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 2),
        prev = _ref2[0],
        next = _ref2[1];
      pager.prev = prev;
      pager.next = next;
      pager.$paginationModel.on('changed', function () {
        pager.disable();
        pager.updateControls();
      });
      return pager.update();
    })
    //capture results so we can return it after turning off the isInitializing flag
    .then(function (results) {
      pager.$isInitializing = false;
      return results;
    });
  }
  function makePrevCommand(pager) {
    return fe.buildFor({
      dom: $(PREV_PAGE_CMD_SELECTOR, pager.view.jq()),
      type: CommandButton,
      value: new Command({
        displayName: PREVIOUS_PAGE_LABEL,
        func: function func() {
          return pager.previousPage();
        }
      })
    });
  }
  function makeNextCommand(pager) {
    return fe.buildFor({
      dom: $(NEXT_PAGE_CMD_SELECTOR, pager.view.jq()),
      type: CommandButton,
      value: new Command({
        displayName: NEXT_PAGE_LABEL,
        func: function func() {
          return pager.nextPage();
        }
      })
    });
  }

  /**
   * Disable/Enable controls when table starts/stops loading
   *
   * @param pager
   * @param isLoading
   */
  function loading(pager, isLoading) {
    var view = pager.view,
      timeRangeControl = $(TIME_RANGE_EDITOR_SELECTOR + " select", view.jq()),
      resultsPerPageControl = $(PAGING_SELECTOR + " select", view.jq()),
      maintenanceControls = $(MAINTENANCE_GROUP_SELECTOR + " button", view.jq()),
      controls = maintenanceControls.add(timeRangeControl).add(resultsPerPageControl);
    controls.prop('disabled', isLoading);
  }

  /**
   * @class
   * @alias module:nmodule/alarm/rc/db/editors/Pager
   * @param view
   * @param displayNamesMap
   * @param timeZoneDatabase
   * @param isAlarmArchiveSpace
   */
  var Pager = function Pager(view, displayNamesMap, timeZoneDatabase, isAlarmArchiveSpace) {
    this.view = view;
    this.$paginationModel = new AlarmTablePaginationModel({
      rowsPerPage: DEFAULT_LIMIT,
      displayNamesMap: displayNamesMap,
      timeZoneDatabase: timeZoneDatabase,
      isAlarmArchiveSpace: isAlarmArchiveSpace
    });
  };

  /**
   * @private
   * @returns {module:bajaux/util/CommandButton}
   */
  Pager.prototype.$getPreviousPageCmd = function () {
    return this.prev;
  };

  /**
   * @private
   * @returns {module:bajaux/util/CommandButton}
   */
  Pager.prototype.$getNextPageCmd = function () {
    return this.next;
  };

  /**
   * @private
   * @returns {JQuery}
   */
  Pager.prototype.$getLimitSelector = function () {
    return $(ALARM_LIMIT_SELECTOR, this.view.jq());
  };

  /**
   * Restarts pagination back at page 1. Called when the database query
   * parameters themselves change.
   * @private
   * @returns {Promise}
   */
  Pager.prototype.$reset = function () {
    var model = this.$paginationModel;
    return Promise.all([model.setRowCount(-1), model.setCurrentPage(1)]);
  };

  /**
   * @returns {Promise}
   */
  Pager.prototype.updateTable = function () {
    return this.setCurrentPage(this.getCurrentPage());
  };

  /**
   * @returns {Promise}
   */
  Pager.prototype.previousPage = function () {
    return this.setCurrentPage(this.getCurrentPage() - 1);
  };

  /**
   * @returns {Promise}
   */
  Pager.prototype.nextPage = function () {
    return this.setCurrentPage(this.getCurrentPage() + 1);
  };

  /**
   * @returns {number}
   */
  Pager.prototype.getCurrentPage = function () {
    return this.$paginationModel.getCurrentPage();
  };

  /**
   * @param {number} currentPage
   * @returns {Promise}
   */
  Pager.prototype.setCurrentPage = function (currentPage) {
    return this.$paginationModel.setCurrentPage(currentPage);
  };

  /**
   * Sets a new FilterSet and triggers a page change back to the beginning.
   *
   * @param {baja.Complex} filterSet a `bql:FilterSet`
   * @returns {Promise} to be resolved after the pagination model has been
   * reset back to the start
   */
  Pager.prototype.setFilterSet = function (filterSet) {
    this.$paginationModel.setFilterSet(filterSet);
    return this.$reset();
  };

  /**
   * Sets a new time range and triggers a page change back to the beginning.
   *
   * @param {baja.Simple} timeRange a `bql:DynamicTimeRange`
   * @returns {Promise} to be resolved after the pagination model has been
   * reset back to the start
   */
  Pager.prototype.setTimeRange = function (timeRange) {
    this.$paginationModel.setTimeRange(timeRange);
    return this.$reset();
  };

  /**
   * @param args
   * @returns {Promise}
   */
  Pager.prototype.update = function (args) {
    var that = this,
      paginationModel = that.$paginationModel,
      desc = !!(args && args.desc),
      col = args && args.col && args.col.getName() || 'timestamp',
      DELAY = 1500;
    paginationModel.setSortDescending(desc);
    paginationModel.setSortColumn(col);
    return this.disable().then(function () {
      //query the alarm database
      loading(that, true);
      //if !isInitializing then call updateTable to update the results
      if (!that.$isInitializing) {
        var promise = that.updateTable();
        dialogs.showLoading(DELAY, promise);
        return promise;
      } else {
        //on initializing since we are not calling updateTable, we need to call updateControls
        that.updateControls();
      }
    }).then(function () {
      loading(that, false);
      return that;
    });
  };
  Pager.prototype.updateControls = function () {
    var paginationModel = this.$paginationModel,
      pageCount = paginationModel.getPageCount(),
      currentPage = paginationModel.getCurrentPage();
    this.next.setEnabled(currentPage < pageCount);
    this.prev.setEnabled(currentPage > 1 && pageCount >= currentPage);
    this.displayPagePosition(currentPage, pageCount);
  };
  Pager.prototype.displayPagePosition = function (currentPage, totalPages) {
    var jq = $(PAGE_LOCATION_SELECTOR, this.view.jq());
    if (totalPages === 0) {
      jq.text(lex.get('alarm.table.page.noResults'));
    } else if (currentPage <= totalPages) {
      var pageOf = lex.get({
        key: "alarm.table.page.pageOf",
        def: "Page {0} of {1}",
        args: [currentPage, totalPages]
      });
      jq.text(pageOf);
    }
  };
  Pager.prototype.disable = function () {
    return Promise.resolve(this.prev && this.prev.setEnabled(false) && this.next && this.next.setEnabled(false));
  };
  Pager.prototype.destroy = function () {
    return Promise.all([this.prev.destroy(), this.next.destroy()]);
  };
  Pager.makeFor = function (view, isAlarmArchiveSpace) {
    return Promise.all([Alarm.getDisplayNamesMap(), baja.TimeZoneDatabase.get()]).then(function (_ref3) {
      var _ref4 = _slicedToArray(_ref3, 2),
        displayNamesMap = _ref4[0],
        timeZoneDatabase = _ref4[1];
      var pager = new Pager(view, displayNamesMap, timeZoneDatabase, isAlarmArchiveSpace);
      return init(pager, isAlarmArchiveSpace);
    });
  };
  return Pager;
});
