/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Danesh Kamal
 */

/**
 * API Status: **Private**
 * @module nmodule/alarm/rc/db/editors/AlarmDetailsTable
 */
define(['baja!', 'lex!alarm', 'jquery', 'Promise', 'nmodule/alarm/rc/console/baja/BajaDataChannel', 'nmodule/alarm/rc/util/alarmUtils', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/util/textUtils', 'nmodule/webEditors/rc/wb/table/Table', 'nmodule/webEditors/rc/wb/table/model/TableModel', 'nmodule/webEditors/rc/wb/table/model/Column', 'nmodule/webEditors/rc/wb/table/model/Row'], function (baja, lexs, $, Promise, BajaDataChannel, alarmUtils, fe, textUtils, Table, TableModel, Column, Row) {
  "use strict";

  var lex = lexs[0];
  function makeFacetsTable(alarm, facets) {
    /*global document*/
    var table = $(document.createElement('table')).addClass('facets');

    //Rows
    facets.getKeys().sort().forEach(function (key) {
      // If present, also filter out the 'unconvertedHyperlinkOrd' alarm data facet since it
      // is only present when the 'hyperlinkOrd' alarm data facet has been converted to
      // nspace ORD form (see NCCB-54949). It's only needed for framework use (to stash
      // away the original hyperlink ORD) and therefore not needed to display to the user.
      if (key === 'notes' || key === 'unconvertedHyperlinkOrd') {
        return false;
      }
      var value = facets.get(key);
      if (value instanceof baja.AbsTime) {
        value = BajaDataChannel.createDateString(value.getMillis(), alarm.getAlarmData().get('TimeZone'));
      } else {
        value = value.toDisplayString ? value.toDisplayString() : value.toString();
      }
      if (value !== "") {
        $("<tr/>").append($("<td/>").text(alarmUtils.getAlarmDataDisplayName(key))).append($("<td/>").text(value)).appendTo(table);
      }
    });
    return $("<div/>").append(table).html();
  }
  function makeSourceOrdTable(alarm) {
    var alarmData = alarm.getAlarmData();
    var sourceDetails = $('<table/>');
    if (alarmData.get('sourceName')) {
      var sourceNameRow = $('<tr/>').append($('<td/>').text(alarmData.get('sourceName')));
      sourceNameRow.appendTo(sourceDetails);
    }
    var sourceOrds = alarm.getSource().getOrds();
    for (var i = sourceOrds.length; i > 0; i--) {
      var sourceOrdRow = $('<tr/>').append($('<td/>').text(sourceOrds[i - 1]));
      sourceOrdRow.appendTo(sourceDetails);
    }
    return sourceDetails;
  }
  function isAlarmData(row) {
    return row.getSubject().getName() === 'alarmData';
  }
  function isAlarmSource(row) {
    return row.getSubject().getName() === 'source';
  }
  var PropertiesTable = function PropertiesTable() {};
  PropertiesTable.makeFor = function (alarm) {
    var rows = [],
      propNameColumn = new Column('name', {
        displayName: lex.get('alarm.console.details.name')
      }),
      propValueColumn = new Column('value', {
        displayName: lex.get('alarm.console.details.value')
      }),
      columns = [propNameColumn, propValueColumn];
    propNameColumn.getValueFor = function (row) {
      var name = row.getSubject().getName();
      return lex.get(name) || textUtils.toFriendly(name);
    };

    //NCCB-14443 - Override from Column.js to remove HTML escaping
    propValueColumn.buildCell = function (row, dom) {
      var rowValue = this.getValueFor(row);
      if (isAlarmData(row)) {
        return Promise.resolve(dom.html(rowValue));
      }
      if (isAlarmSource(row)) {
        return Promise.resolve(dom.html(makeSourceOrdTable(alarm)));
      }
      return Promise.resolve(dom.text(String(rowValue)));
    };
    propValueColumn.getValueFor = function (row) {
      var value = alarm.get(row.getSubject());
      if (value instanceof baja.AbsTime) {
        var tz = alarm.getAlarmData().get('TimeZone');
        var alarmData = alarm.alarmData;
        if (!(tz instanceof baja.TimeZone)) {
          if (alarmData && alarmData.TimeZone) {
            tz = alarmData.TimeZone;
          } else {
            tz = baja.TimeZone.UTC;
          }
        }
        return BajaDataChannel.createDateString(value.getMillis(), tz);
      } else if (value instanceof baja.Facets) {
        return makeFacetsTable(alarm, value);
      }
      if (isAlarmSource(row)) {
        return value && baja.SlotPath.unescape(value.toString());
      }
      return value.toString();
    };
    alarm.getSlots().properties().each(function (prop) {
      rows.push(new Row(prop));
    });
    return fe.buildFor({
      dom: $("<table class='ux-table ux-select-none'></table>"),
      type: Table,
      value: new TableModel({
        rows: rows,
        columns: columns
      })
    });
  };
  return PropertiesTable;
});
