/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Danesh Kamal
 */

/**
 * API Status: **Private**
 * @module nmodule/alarm/rc/db/commands/PlayCommand
 */
define(['baja!', 'lex!alarm', 'log!nmodule.alarm.rc.db.commands.PlayCommand', 'bajaux/commands/ToggleCommand'], function (baja, lexs, log, ToggleCommand) {
  "use strict";

  var logSevere = log.severe.bind(log);
  var ticket,
    REFRESH_INTERVAL = 5000,
    lex = lexs[0];
  var PlayCommand = function PlayCommand(view, params, func) {
    ToggleCommand.call(this, params, func);
    this.view = view;
  };

  //extend and set up prototype chain
  PlayCommand.prototype = Object.create(ToggleCommand.prototype);
  PlayCommand.prototype.constructor = PlayCommand;
  PlayCommand.prototype.toggle = function (params) {
    ToggleCommand.prototype.toggle.call(this, params);
    var pager = this.view.pager;
    if (ticket) {
      ticket.cancel();
    }
    if (this.isSelected() && pager) {
      pager.updateTable().then(function () {
        ticket = baja.clock.schedulePeriodically(function () {
          pager.updateTable();
        }, REFRESH_INTERVAL);
      })["catch"](logSevere);
    }
  };
  PlayCommand.makeFor = function (view) {
    return new PlayCommand(view, {
      displayName: lex.get('command.play.label'),
      description: lex.get('command.play.label'),
      icon: lex.get('command.play.icon')
    });
  };
  return PlayCommand;
});
