/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Danesh Kamal
 */

/**
 * API Status: **Private**
 * @module nmodule/alarm/rc/db/commands/FilterCommand
 */
define(['baja!', 'baja!alarm:AlarmRecord,alarm:SourceState,alarm:AckState,' + 'alarm:AlarmFilterSet,' + 'bql:FilterEntry,' + 'bql:BooleanFilter,' + 'bql:EnumFilter,' + 'bql:StringFilter,' + 'bql:IntegerFilter,' + 'bql:FacetsFilter', 'underscore', 'lex!alarm', 'Promise', 'nmodule/alarm/rc/Alarm', 'bajaux/commands/Command', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/servlets/registry'], function (baja, types, _, lexs, Promise, Alarm, Command, feDialogs, registry) {
  "use strict";

  function makeFilterSet() {
    var alarmRecord = baja.$('alarm:AlarmRecord'),
      filterSet = baja.$('alarm:AlarmFilterSet'),
      cursor = alarmRecord.getSlots().properties().frozen(),
      slots = [],
      promises = [],
      excludedProperties = ['timestamp', 'uuid'];
    cursor.each(function (prop) {
      var name = prop.getName(),
        displayName = prop.$getDisplayName(),
        value = alarmRecord.get(prop);
      if (_.contains(excludedProperties, name)) {
        return;
      }
      slots.push(name);
      promises.push(registry.getAgentOnInfo(value.getType().getTypeSpec(), {
        is: 'bql:IBqlFilter'
      }).then(function (obj) {
        if (obj.length) {
          var filterType = obj[0].type,
            filter = baja.$(filterType),
            filterEntry;
          if (filterType === 'bql:EnumFilter') {
            if (name === 'sourceState' || name === 'alarmTransition') {
              filter.setEnumType(baja.DynamicEnum.make({
                en: 'alarm:SourceState'
              }));
            }
            if (name === 'ackState') {
              filter.setEnumType(baja.DynamicEnum.make({
                en: 'alarm:AckState'
              }));
            }
          }
          filterEntry = baja.$('bql:FilterEntry', {
            label: displayName,
            filter: filter
          });
          filterSet.add({
            slot: name,
            value: filterEntry
          });
        }
        return null;
      }));
    });
    return Promise.all(promises).then(function () {
      return filterSet.reorder(slots);
    }).then(function () {
      return filterSet;
    });
  }
  var FilterCommand = function FilterCommand(view, params) {
    Command.call(this, params);
    this.$view = view;
  };
  FilterCommand.prototype = Object.create(Command.prototype);
  FilterCommand.prototype.constructor = FilterCommand;
  FilterCommand.makeFor = function (view) {
    var lex = lexs[0],
      filterSet,
      pager;
    return new FilterCommand(view, {
      displayName: lex.get('command.filter.label'),
      description: lex.get('command.filter.label'),
      icon: lex.get('command.filter.icon'),
      func: function func() {
        return Promise.resolve(filterSet || makeFilterSet()).then(function (fs) {
          return feDialogs.showFor({
            title: lex.get('command.filter.label'),
            value: fs
          }).then(function (newFilterSet) {
            filterSet = newFilterSet || filterSet;
            if (filterSet) {
              //NCCB-13573: at this point if the alarmClass filter entry is active then retrieve
              //the alarm class name to display name map, reverse lookup the alarm class name from the
              // search term and load the filter's pattern with this name
              var alarmClassFilterEntry = filterSet.get('alarmClass');
              return Promise.resolve(alarmClassFilterEntry && alarmClassFilterEntry.getActive() && Alarm.getDisplayNamesMap()).then(function (map) {
                var stringFilter = alarmClassFilterEntry.getFilter(),
                  pattern = stringFilter.getPattern(),
                  exact = stringFilter.getExact(),
                  matchCase = stringFilter.getMatchCase();
                if (map) {
                  map = _.invert(map);

                  //replace pattern string delimited by % signs
                  stringFilter.setPattern(pattern.replace(/[^%].*[^%]/, function (searchTerm) {
                    //the match could be the full key into the map (exact match) or a partial string that
                    //is a substring of a key in the map. Go through the map and return the first
                    //key that satifies this criteria
                    var alarmClassName = _.find(map, function (alarmClassName, alarmClassDisplayName) {
                      if (!matchCase) {
                        searchTerm = searchTerm.toLowerCase();
                        alarmClassDisplayName = alarmClassDisplayName.toLowerCase();
                      }
                      if (exact) {
                        return alarmClassDisplayName === searchTerm;
                      }
                      return alarmClassDisplayName.indexOf(searchTerm) !== -1;
                    });
                    return alarmClassName || searchTerm;
                  }));
                }
                pager = pager || view.pager;
                return pager.setFilterSet(filterSet).then(function () {
                  //restore the string filter's original pattern
                  return stringFilter.setPattern(pattern);
                });
              });
            }
          });
        });
      }
    });
  };
  return FilterCommand;
});
