/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Danesh Kamal
 */

/**
 * API Status: **Private**
 * @module nmodule/alarm/rc/db/AlarmFacetColumn
 */
define(['baja!', 'underscore', 'Promise', 'nmodule/webEditors/rc/wb/table/model/Column'], function (baja, _, Promise, Column) {
  "use strict";

  var FORMATTED_KEYS = ['msgText'];

  /**
   * @class
   * @alias module:nmodule/alarm/rc/db/AlarmFacetColumn
   * @extends module:nmodule/webEditors/rc/wb/table/model/Column
   * @param name
   * @param params
   */
  var AlarmFacetColumn = function AlarmFacetColumn(name, params) {
    Column.apply(this, [name, params]);
  };
  AlarmFacetColumn.prototype = Object.create(Column.prototype);
  AlarmFacetColumn.prototype.constructor = AlarmFacetColumn;
  AlarmFacetColumn.prototype.getValueFor = function (row) {
    return row.getSubject().get('alarmData').get(this.$name) || '';
  };
  AlarmFacetColumn.prototype.buildCell = function (row, dom) {
    var key = this.$name,
      value = this.getValueFor(row),
      requiresFormatting = _.contains(FORMATTED_KEYS, key);
    return Promise.resolve(value && requiresFormatting && baja.Format.format({
      object: row.getSubject(),
      pattern: value
    })).then(function (str) {
      dom.text(str || '');
    });
  };
  return AlarmFacetColumn;
});
