/**
 * @copyright 2017 Tridium, Inc. All Rights Reserved.
 * @author Jeremy Narron
 */

/**
 * API Status: **Private**
 * @module nmodule/alarm/rc/console/table/columns/SourceColumn
 */
define(['lex!alarm', 'nmodule/alarm/rc/console/table/columns/DefaultColumn', 'nmodule/webEditors/rc/util/textUtils'], function (lexs, DefaultColumn, textUtils) {
  'use strict';

  var lex = lexs[0];

  /**
   * SourceColumn
   *
   * @class
   * @extends {module:nmodule/alarm/rc/console/table/columns/DefaultColumn}
   * @alias {module:nmodule/alarm/rc/console/table/columns/SourceColumn}
   */
  var SourceColumn = function SourceColumn() {
    DefaultColumn.apply(this, ['source', {
      displayName: lex.get({
        key: 'alarm.console.columns.source',
        def: textUtils.toFriendly('source')
      })
    }]);
  };
  SourceColumn.prototype = Object.create(DefaultColumn.prototype);
  SourceColumn.prototype.constructor = SourceColumn;

  /**
   * @param {module:nmodule/webEditors/rc/wb/table/model/Row} row
   * @returns {String}
   */
  SourceColumn.prototype.getValueFor = function (row) {
    var alarmData = row.getSubject().alarmData;
    return alarmData && alarmData.sourceName || row.getSubject().source;
  };
  return SourceColumn;
});
