/**
 * @copyright 2017 Tridium, Inc. All Rights Reserved.
 * @author Danesh Kamal
 */

/* eslint-env browser */

/**
 * API Status: **Private**
 * @module nmodule/alarm/rc/console/commands/HyperlinkCommand
 */
define(['Promise', 'underscore', 'dialogs', 'bajaux/commands/Command', 'nmodule/alarm/rc/console/commands/alarmConsoleCommandMixIn'], function (Promise, _, dialogs, Command, alarmConsoleCommandMixIn) {
  'use strict';

  function getSelectedHyperlinkOrd(view, params) {
    var details = params && params.details,
      subject,
      table,
      rows;
    if (details) {
      subject = params.subject;
    } else {
      table = view.$getAlarmTable();
      rows = table.getSelectedRows();
      if (rows.length) {
        subject = rows[0].getSubject();
      }
    }
    var alarmData = subject && subject._alarmData;
    return alarmData && alarmData.hyperlinkOrd;
  }
  function hyperlink(view, params) {
    var ord = getSelectedHyperlinkOrd(view, params);
    if (ord) {
      window.niagara.env.hyperlink(ord);
    }
  }

  /**
   * If the alarm has a hyperlink, this command will hyperlink the user to it.
   *
   * @constructor
   * @param {module:nmodule/alarm/rc/console/AlarmConsole} view The alarm console view.
   * @param {Object} params
   * @extends {module:bajaux/commands/Command}
   * @mixes {module:nmodule/alarm/rc/console/commands/alarmConsoleCommandMixIn}
   */
  var HyperlinkCommand = function HyperlinkCommand(view, params) {
    Command.apply(this, [{
      module: 'alarm',
      lex: 'commands.hyperlink',
      func: function func(hyperlinkParams) {
        hyperlink(view, _.extend({}, params, hyperlinkParams));
      }
    }]);
    alarmConsoleCommandMixIn(this);
    this.$showInMenu = true;
    this.$showInCommandBar = true;
    this.$view = view;
  };
  HyperlinkCommand.prototype = Object.create(Command.prototype);
  HyperlinkCommand.prototype.constructor = HyperlinkCommand;
  HyperlinkCommand.prototype.selectionChanged = function () {
    var data = this.$view.getSelectedAlarmRecords();
    this.setEnabled(!!(data && data.length && data[0]._alarmData && data[0]._alarmData.hyperlinkOrd));
  };
  return HyperlinkCommand;
});
