function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _superPropGet(t, e, o, r) { var p = _get(_getPrototypeOf(1 & r ? t.prototype : t), e, o); return 2 & r && "function" == typeof p ? function (t) { return p.apply(o, t); } : p; }
function _get() { return _get = "undefined" != typeof Reflect && Reflect.get ? Reflect.get.bind() : function (e, t, r) { var p = _superPropBase(e, t); if (p) { var n = Object.getOwnPropertyDescriptor(p, t); return n.get ? n.get.call(arguments.length < 3 ? e : r) : n.value; } }, _get.apply(null, arguments); }
function _superPropBase(t, o) { for (; !{}.hasOwnProperty.call(t, o) && null !== (t = _getPrototypeOf(t));); return t; }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2023 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/modbusCore/rc/mgr/model/ModbusBaseDeviceModel
 */

define(['baja!', 'baja!modbusCore:ModbusDevice', 'lex!modbusCore', 'Promise', 'nmodule/driver/rc/wb/mgr/columns/DeviceExtsMgrColumn', 'nmodule/driver/rc/wb/mgr/DeviceMgrModel', 'nmodule/webEditors/rc/wb/mgr/model/columns/NameMgrColumn', 'nmodule/webEditors/rc/wb/mgr/model/columns/PropertyMgrColumn', 'nmodule/webEditors/rc/wb/mgr/model/columns/IconMgrColumn', 'nmodule/webEditors/rc/wb/mgr/model/columns/TypeMgrColumn', 'nmodule/webEditors/rc/wb/table/model/Column'], function (baja, types, lexs, Promise, DeviceExtsMgrColumn, DeviceMgrModel, NameMgrColumn, PropertyMgrColumn, IconMgrColumn, TypeMgrColumn, Column) {
  'use strict';

  var _Column$flags = Column.flags,
    EDITABLE = _Column$flags.EDITABLE,
    UNSEEN = _Column$flags.UNSEEN;
  var MODBUS_CORE_TYPE = baja.lt('modbusCore:ModbusDevice');
  var _lexs = _slicedToArray(lexs, 1),
    modbusCoreLex = _lexs[0];
  var COLUMNS = [new IconMgrColumn(), new NameMgrColumn({
    flags: EDITABLE
  }), new TypeMgrColumn({
    flags: EDITABLE | UNSEEN
  }), new DeviceExtsMgrColumn('deviceExts', {
    dynamic: true
  }), new PropertyMgrColumn('status', {
    type: MODBUS_CORE_TYPE
  }), new PropertyMgrColumn('enabled', {
    flags: EDITABLE | UNSEEN,
    type: MODBUS_CORE_TYPE
  }), new PropertyMgrColumn('health', {
    flags: UNSEEN,
    type: MODBUS_CORE_TYPE
  }), new PropertyMgrColumn('deviceAddress', {
    flags: EDITABLE,
    type: MODBUS_CORE_TYPE
  }), new PropertyMgrColumn('modbusConfig', {
    flags: EDITABLE | UNSEEN,
    type: MODBUS_CORE_TYPE
  })];

  /**
   * Device Base model class for Modbus
   * @since Niagara 4.14
   * @class
   * @alias module:nmodule/modbusCore/rc/mgr/model/ModbusBaseDeviceModel
   * @extends module:nmodule/driver/rc/wb/mgr/DeviceMgrModel
   */
  var ModbusBaseDeviceModel = /*#__PURE__*/function (_DeviceMgrModel) {
    function ModbusBaseDeviceModel(params) {
      var _this;
      _classCallCheck(this, ModbusBaseDeviceModel);
      _this = _callSuper(this, ModbusBaseDeviceModel, arguments);
      _this.$endAddress = params.endAddress || 247;
      return _this;
    }

    /**
     *
     * @param params
     * @param params the parameters to be used to create new instances
     * @param {module:nmodule/webEditors/rc/wb/mgr/MgrTypeInfo} params.typeInfo the `MgrTypeInfo`
     * representing the type of the components we're creating
     * @param {baja.Integer} params.count how many new components to create
     * @param {baja.Integer} params.addressStart the starting point for all new addresses
     * @returns {Promise.<Array.<baja.Value>>}     */
    _inherits(ModbusBaseDeviceModel, _DeviceMgrModel);
    return _createClass(ModbusBaseDeviceModel, [{
      key: "newInstances",
      value: function newInstances(params) {
        var _this2 = this;
        return _superPropGet(ModbusBaseDeviceModel, "newInstances", this, 3)([params]).then(function (instances) {
          return Promise.all(instances.map(function (instance, i) {
            var newAddress = params.addressStart.valueOf() + i;
            if (newAddress > _this2.$endAddress) {
              return Promise.reject(new Error(modbusCoreLex.get("devManager.error.invalidCount", _this2.$endAddress)));
            }
            return instance.set({
              slot: 'deviceAddress',
              value: newAddress
            }).then(function () {
              return instance;
            });
          }));
        }).then(function (updatedInstances) {
          return updatedInstances;
        });
      }
    }]);
  }(DeviceMgrModel);
  ModbusBaseDeviceModel.DEFAULT_COLUMNS = COLUMNS;
  return ModbusBaseDeviceModel;
});
