function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/gx/rc/fe/PointEditor
 */
define(['baja!', 'jquery', 'Promise', 'bajaux/events', 'bajaux/Widget', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/fe/baja/BaseEditor', 'nmodule/gx/rc/baja/Point'], function (baja, $, Promise, events, Widget, fe, BaseEditor, Point) {
  "use strict";

  /**
   * Baja UX field editor for Point.
   * Has an editor each for the X and Y co-ordinate values defaulting to values 0
   *
   * @class
   * @extends module:nmodule/webEditors/rc/fe/baja/BaseEditor
   * @alias  module:nmodule/gx/rc/fe/PointEditor
   */
  var PointEditor = /*#__PURE__*/function (_BaseEditor) {
    function PointEditor() {
      _classCallCheck(this, PointEditor);
      return _callSuper(this, PointEditor, arguments);
    }
    _inherits(PointEditor, _BaseEditor);
    return _createClass(PointEditor, [{
      key: "doInitialize",
      value:
      /**
       * Creates an editor with correcty labeled X and Y child editors
       *
       * @param {JQuery} dom
       * @returns {Promise}
       */
      function doInitialize(dom) {
        var _this = this;
        dom.append('<span class="x-editor">');
        dom.append('<span class="y-editor">');
        dom.on(events.MODIFY_EVENT, '.type-baja-Number', function () {
          _this.setModified(true);
          return false;
        });
        return Promise.all([fe.buildFor({
          dom: this.$getXEditorElement(),
          value: 0,
          formFactor: 'mini',
          properties: {
            prelabel: 'X'
          }
        }), fe.buildFor({
          dom: this.$getYEditorElement(),
          value: 0,
          formFactor: 'mini',
          properties: {
            prelabel: 'Y'
          }
        })]);
      }

      /**
       *
       * Loads the x field of the point parameter into the X editor, and the y field of the size parameter into
       * the Y editor.
       *
       * @param {module:nmodule/gx/rc/baja/Point} value
       * @returns {Promise}
       */
    }, {
      key: "doLoad",
      value: function doLoad(value) {
        var xEditor = this.$getXEditor(),
          yEditor = this.$getYEditor();
        return Promise.all([xEditor.load(value.x()), yEditor.load(value.y())]);
      }

      /**
       * Reads the value of X and Y, forms a Point and returns it
       *
       * @returns {module:nmodule/gx/rc/baja/Point}
       */
    }, {
      key: "doRead",
      value: function doRead() {
        var xEditor = this.$getXEditor(),
          yEditor = this.$getYEditor();
        return Promise.all([xEditor.read(), yEditor.read()]).then(function (_ref) {
          var _ref2 = _slicedToArray(_ref, 2),
            xVal = _ref2[0],
            yVal = _ref2[1];
          return new Point(xVal, yVal);
        });
      }

      /**
       * Sets all the child widgets of this editor to readonly.
       *
       * @param {boolean} readonly
       * @returns {Promise}
       */
    }, {
      key: "doReadonly",
      value: function doReadonly(readonly) {
        return this.getChildWidgets().setAllReadonly(readonly);
      }

      /**
       * Sets all the child widgets of this editor to enabled.
       *
       * @param {boolean} enabled
       * @returns {Promise}
       */
    }, {
      key: "doEnabled",
      value: function doEnabled(enabled) {
        return this.getChildWidgets().setAllEnabled(enabled);
      }

      /**
       * Destroys all children of the editor.
       *
       * @returns {Promise}
       */
    }, {
      key: "doDestroy",
      value: function doDestroy() {
        return this.getChildWidgets().destroyAll();
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getXEditor",
      value: function $getXEditor() {
        return Widget["in"](this.$getXEditorElement());
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getYEditor",
      value: function $getYEditor() {
        return Widget["in"](this.$getYEditorElement());
      }

      /**
       * @private
       * @returns {JQuery}
       */
    }, {
      key: "$getXEditorElement",
      value: function $getXEditorElement() {
        return this.jq().find('.x-editor');
      }

      /**
       * @private
       * @returns {JQuery}
       */
    }, {
      key: "$getYEditorElement",
      value: function $getYEditorElement() {
        return this.jq().find('.y-editor');
      }
    }]);
  }(BaseEditor);
  return PointEditor;
});
