function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module  module:nmodule/gx/rc/fe/PenEditor
 */
define(['baja!', 'jquery', 'Promise', 'bajaux/Widget', 'bajaux/events', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/fe/baja/BaseEditor', 'nmodule/webEditors/rc/fe/baja/OrderedMapEditor', 'nmodule/gx/rc/baja/Pen', 'lex!gx'], function (baja, $, Promise, Widget, events, fe, BaseEditor, OrderedMapEditor, Pen, lexs) {
  "use strict";

  var _lexs = _slicedToArray(lexs, 1),
    lex = _lexs[0];
  var dotted = [2, 2];
  var dashed = [8, 2];

  /**
   * Baja UX field editor for Pen.
   * Has an editor each for the pen width, cap, join and dash pattern
   *
   * @class
   * @extends module:nmodule/webEditors/rc/fe/baja/BaseEditor
   * @alias module:nmodule/gx/rc/fe/PenEditor
   */
  var PenEditor = /*#__PURE__*/function (_BaseEditor) {
    function PenEditor() {
      _classCallCheck(this, PenEditor);
      return _callSuper(this, PenEditor, arguments);
    }
    _inherits(PenEditor, _BaseEditor);
    return _createClass(PenEditor, [{
      key: "doInitialize",
      value:
      /**
       * Creates a pen editor with child editors for width, cap, join and pen dash pattern width default
       * values as 1, Pen.CAP_BUTT, Pen.JOIN_MITER and Pen.noDash respectively.
       *
       * @param {JQuery} dom
       * @returns {Promise}
       */
      function doInitialize(dom) {
        var _this = this;
        dom.html("<span class=\"width\"/>\n                <span class=\"dash\"/> \n                <span class=\"cap\"/> \n                <span class=\"join\"/>");
        dom.on(events.MODIFY_EVENT, '.type-baja-Number, .width, .dash, .cap, .join', function () {
          _this.setModified(true);
          return false;
        });
        var defaultPen = Pen.DEFAULT;
        this.validators().add(function (pen) {
          var width = pen.getWidth();
          if (width === Number.POSITIVE_INFINITY || width === Number.NEGATIVE_INFINITY || isNaN(width)) {
            throw new Error(lex.get("pen.width.error", width.encodeToString()));
          }
        });
        return Promise.all([fe.buildFor({
          dom: this.$getWidthElement(),
          value: defaultPen.getWidth(),
          formFactor: 'mini'
        }), fe.buildFor({
          dom: this.$getDashElement(),
          value: this.$getDashPatternMap(),
          loadParams: {
            selectedValue: 'solid'
          },
          type: OrderedMapEditor,
          formFactor: 'mini'
        }), fe.buildFor({
          dom: this.$getCapElement(),
          value: this.$getPenCapMap(),
          loadParams: {
            selectedValue: defaultPen.getCap()
          },
          type: OrderedMapEditor,
          formFactor: 'mini'
        }), fe.buildFor({
          dom: this.$getJoinElement(),
          value: this.$getPenJoinMap(),
          loadParams: {
            selectedValue: defaultPen.getJoin()
          },
          type: OrderedMapEditor,
          formFactor: 'mini'
        })]);
      }

      /**
       * Loads the width value, cap and join styles and dash pattern in to the respective editors
       *
       * @param {module:nmodule/gx/rc/baja/Pen} pen
       * @returns {Promise}
       */
    }, {
      key: "doLoad",
      value: function doLoad(pen) {
        return Promise.all([this.$getWidthEditor().load(pen.getWidth()), this.$getDashEditor().setSelectedValue(this.$getDashPatternString(pen.getDash()), true), this.$getCapEditor().setSelectedValue(pen.getCap(), true), this.$getJoinEditor().setSelectedValue(pen.getJoin(), true)]);
      }

      /**
       * Reads the value of width, pen cap & join and dash pattern, forms a Pen instance and
       * returns it
       *
       * @returns {module:nmodule/gx/rc/baja/Pen}
       */
    }, {
      key: "doRead",
      value: function doRead() {
        var _this2 = this;
        return Promise.all([this.$getWidthEditor().read(), this.$getDashEditor().read(), this.$getCapEditor().read(), this.$getJoinEditor().read()]).then(function (_ref) {
          var _ref2 = _slicedToArray(_ref, 4),
            width = _ref2[0],
            dash = _ref2[1],
            cap = _ref2[2],
            join = _ref2[3];
          return Pen.make(width, cap, join, _this2.$getDashPatternValue(dash));
        });
      }

      /**
       * Sets all the child widgets of this editor to readonly.
       *
       * @param {boolean} readonly
       * @returns {Promise}
       */
    }, {
      key: "doReadonly",
      value: function doReadonly(readonly) {
        return this.getChildWidgets().setAllReadonly(readonly);
      }

      /**
       * Sets all the child widgets of this editor to enabled.
       *
       * @param {boolean} enabled
       * @returns {Promise}
       */
    }, {
      key: "doEnabled",
      value: function doEnabled(enabled) {
        return this.getChildWidgets().setAllEnabled(enabled);
      }

      /**
       * Destroys all children of the editor.
       *
       * @returns {Promise}
       */
    }, {
      key: "doDestroy",
      value: function doDestroy() {
        return this.getChildWidgets().destroyAll();
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getWidthEditor",
      value: function $getWidthEditor() {
        return Widget["in"](this.$getWidthElement());
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getCapEditor",
      value: function $getCapEditor() {
        return Widget["in"](this.$getCapElement());
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getJoinEditor",
      value: function $getJoinEditor() {
        return Widget["in"](this.$getJoinElement());
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getDashEditor",
      value: function $getDashEditor() {
        return Widget["in"](this.$getDashElement());
      }

      /**
       * @private
       * @returns {JQuery}
       */
    }, {
      key: "$getWidthElement",
      value: function $getWidthElement() {
        return this.jq().find('.width');
      }

      /**
       * @private
       * @returns {JQuery}
       */
    }, {
      key: "$getCapElement",
      value: function $getCapElement() {
        return this.jq().find('.cap');
      }

      /**
       * @private
       * @returns {JQuery}
       */
    }, {
      key: "$getJoinElement",
      value: function $getJoinElement() {
        return this.jq().find('.join');
      }

      /**
       * @private
       * @returns {JQuery}
       */
    }, {
      key: "$getDashElement",
      value: function $getDashElement() {
        return this.jq().find('.dash');
      }

      /**
       * Returns the OrderedMap of pen cap options to be loaded in to the Pen Cap
       *
       * editor.
       * @private
       * @returns {baja.OrderedMap}
       */
    }, {
      key: "$getPenCapMap",
      value: function $getPenCapMap() {
        var _this3 = this;
        var penCaps = [Pen.CAP_BUTT, Pen.CAP_SQUARE, Pen.CAP_ROUND],
          map = new baja.OrderedMap();
        penCaps.forEach(function (cap) {
          map.put(_this3.$getCapDisplay(cap), cap);
        });
        return map;
      }

      /**
       * Returns the OrderedMap of pen join options to be loaded in to the Pen Join
       * editor.
       *
       * @private
       * @returns {baja.OrderedMap}
       */
    }, {
      key: "$getPenJoinMap",
      value: function $getPenJoinMap() {
        var _this4 = this;
        var penJoins = [Pen.JOIN_MITER, Pen.JOIN_BEVEL, Pen.JOIN_ROUND],
          map = new baja.OrderedMap();
        penJoins.forEach(function (join) {
          map.put(_this4.$getJoinDisplay(join), join);
        });
        return map;
      }

      /**
       * Returns the OrderedMap of pen dash pattern options to be loaded in to the Pen Dash
       * editor.
       *
       * @private
       * @returns {baja.OrderedMap}
       */
    }, {
      key: "$getDashPatternMap",
      value: function $getDashPatternMap() {
        var map = new baja.OrderedMap();
        map.put(lex.get('pen.dash.solid'), 'solid');
        map.put(lex.get('pen.dash.dotted'), 'dotted');
        map.put(lex.get('pen.dash.dashed'), 'dashed');
        return map;
      }

      /**
       * Get the display name for the options in pen cap
       *
       * @private
       * @param {number} cap
       * @returns {string}
       */
    }, {
      key: "$getCapDisplay",
      value: function $getCapDisplay(cap) {
        var capDisplay = '';
        switch (cap) {
          case Pen.CAP_BUTT:
            capDisplay = lex.get("pen.cap.butt");
            break;
          case Pen.CAP_SQUARE:
            capDisplay = lex.get("pen.cap.square");
            break;
          case Pen.CAP_ROUND:
            capDisplay = lex.get("pen.cap.round");
            break;
          default:
            throw new Error('Invalid cap');
        }
        return capDisplay;
      }

      /**
       * Get the display name for the options in pen join
       *
       * @private
       * @param {number} join
       * @returns {string}
       */
    }, {
      key: "$getJoinDisplay",
      value: function $getJoinDisplay(join) {
        var joinDisplay = '';
        switch (join) {
          case Pen.JOIN_MITER:
            joinDisplay = lex.get("pen.join.miter");
            break;
          case Pen.JOIN_BEVEL:
            joinDisplay = lex.get("pen.join.bevel");
            break;
          case Pen.JOIN_ROUND:
            joinDisplay = lex.get("pen.join.round");
            break;
          default:
            throw new Error('Invalid join');
        }
        return joinDisplay;
      }

      /**
       * Get the dash pattern value as array (solid = PenEditor.solid; dotted = PenEditor.dotted; dashed = PenEditor.dashed)
       *
       * @private
       * @returns {Array.<number>}
       */
    }, {
      key: "$getDashPatternValue",
      value: function $getDashPatternValue(dashStr) {
        var dashArr = Pen.noDash;
        switch (dashStr) {
          case 'solid':
            return dashArr.slice();
          case 'dotted':
            return dotted.slice();
          case 'dashed':
            return dashed.slice();
        }
        return dashArr;
      }

      /**
       * Get the dash pattern string (solid/dotted/dashed)
       *
       * @private
       * @returns {string}
       */
    }, {
      key: "$getDashPatternString",
      value: function $getDashPatternString(dash) {
        var dashPatternStr;
        if (dash.length === 0) {
          dashPatternStr = 'solid';
        } else if (dash[0] === dotted[0] && dash[1] === dotted[1]) {
          dashPatternStr = 'dotted';
        } else if (dash[0] === dashed[0] && dash[1] === dashed[1]) {
          dashPatternStr = 'dashed';
        } else {
          throw new Error(lex.get('pen.dash.custom.error'));
        }
        return dashPatternStr;
      }
    }]);
  }(BaseEditor);
  return PenEditor;
});
