function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _superPropGet(t, e, o, r) { var p = _get(_getPrototypeOf(1 & r ? t.prototype : t), e, o); return 2 & r && "function" == typeof p ? function (t) { return p.apply(o, t); } : p; }
function _get() { return _get = "undefined" != typeof Reflect && Reflect.get ? Reflect.get.bind() : function (e, t, r) { var p = _superPropBase(e, t); if (p) { var n = Object.getOwnPropertyDescriptor(p, t); return n.get ? n.get.call(arguments.length < 3 ? e : r) : n.value; } }, _get.apply(null, arguments); }
function _superPropBase(t, o) { for (; !{}.hasOwnProperty.call(t, o) && null !== (t = _getPrototypeOf(t));); return t; }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2022 Tridium, Inc. All Rights Reserved.
 */

/** @jsx spandrel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/report/rc/fe/ExportSourceInfoEditor
 */

define(['baja!', 'jquery', 'lex!report', 'bajaux/spandrel', 'bajaux/Widget', 'Promise', 'underscore', 'nmodule/bajaui/rc/ux/UxCommandButton', 'nmodule/report/rc/baja/ExportSourceInfo', 'nmodule/webEditors/rc/fe/baja/DisplayOnlyEditor', 'nmodule/webEditors/rc/fe/baja/OrderedMapEditor', 'nmodule/webEditors/rc/fe/baja/util/compUtils', 'nmodule/webEditors/rc/servlets/userData', 'nmodule/webEditors/rc/servlets/valueDocEncodingUtil', 'nmodule/webEditors/rc/transform/exportUtils', 'nmodule/webEditors/rc/wb/commands/PopOutCommand', 'nmodule/webEditors/rc/wb/PropertySheet', 'css!nmodule/report/rc/report'], function (baja, $, lexs, spandrel, Widget, Promise, _, UxCommandButton, ExportSourceInfo, DisplayOnlyEditor, OrderedMapEditor, compUtils, userData, valueDocEncodingUtil, exportUtils, PopOutCommand, PropertySheet) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    report = _lexs[0];
  var sourceLabel = report.get("ExportSourceInfoEditor.sourceOrdLabel");
  var operationLabel = report.get("ExportSourceInfoEditor.operationLabel");
  var setupLabel = report.get("ExportSourceInfoEditor.setupLabel");
  var widgetDefaults = function widgetDefaults() {
    return {
      properties: {
        rootCssClass: '-t-ExportSourceInfoEditor'
      }
    };
  };

  /**
   * A field editor for editor the ExportSourceInfo
   *
   * @class
   * @alias module:nmodule/report/rc/fe/ExportSourceInfoEditor
   * @extends module:bajaux/Widget
   * @since Niagara 4.13
   */
  var ExportSourceInfoEditor = /*#__PURE__*/function (_spandrel) {
    function ExportSourceInfoEditor(params) {
      var _this;
      _classCallCheck(this, ExportSourceInfoEditor);
      _this = _callSuper(this, ExportSourceInfoEditor, [{
        params: params,
        defaults: widgetDefaults()
      }]);
      _this.$popoutCmd = new PopOutCommand();
      return _this;
    }

    /**
     * Builds the editor using the information in the state and exportSourceInfo
     * @private
     * @param {object} state the current state for the editor
     * @returns {JSX.Element[]}
     */
    _inherits(ExportSourceInfoEditor, _spandrel);
    return _createClass(ExportSourceInfoEditor, [{
      key: "$buildEditor",
      value: function $buildEditor(state) {
        var formFactor = state.formFactor,
          sourceOrd = state.sourceOrd,
          agentId = state.agentId,
          currentOp = state.currentOp,
          exporterObj = state.exporterObj,
          exporterMap = state.exporterMap;
        var self = state.self;
        if (formFactor === 'mini') {
          var desc = (sourceOrd ? sourceOrd.encodeToString() : "null") + " [" + (agentId || 'null') + "]";
          return [spandrel.jsx("div", {
            className: "-t-ExportSourceInfoEditor-mini-layout",
            spandrelKey: "layout-mini"
          }, desc)];
        }
        return [spandrel.jsx("table", {
          className: "ux-table no-strips"
        }, spandrel.jsx("tr", {
          className: "ux-table-row -t-ExportSourceInfoEditor-sourceLayout",
          spandrelKey: "sourceLayout"
        }, spandrel.jsx("td", {
          spandrelKey: "sourceLabel"
        }, sourceLabel), spandrel.jsx("td", null, spandrel.jsx(DisplayOnlyEditor, {
          lax: "true",
          bindKey: "sourceOrd",
          className: "-t-ExportSourceInfoEditor-sourceEditor -t-ExportSourceInfoEditor-label",
          spandrelKey: "sourceEditor",
          value: sourceOrd,
          properties: {
            allowHyperlink: false
          },
          onUxModifiedValue: function onUxModifiedValue(ord) {
            return self.$setOrd(ord);
          }
          // TODO this was not being called, so used the doLoad override to resolve it
          // onUxLoad={(e, ed) => self.$popoutCmd.setWatchedEditor(ed)}
        })), spandrel.jsx("td", null, spandrel.jsx(UxCommandButton, {
          value: self.$popoutCmd,
          properties: {
            enabled: true,
            buttonStyle: baja.$('bajaui:ButtonStyle', 'toolBar'),
            text: " "
          },
          spandrelKey: "popOutCommandButton",
          className: "-t-ExportSourceInfoEditor-sourceChooser-popoutCommandButton"
        }))), spandrel.jsx("tr", {
          className: "ux-table-row -t-ExportSourceInfoEditor-operationLayout",
          spandrelKey: "operationLayout"
        }, spandrel.jsx("td", {
          spandrelKey: "operationLabel"
        }, operationLabel), spandrel.jsx("td", null, spandrel.jsx(OrderedMapEditor, {
          value: currentOp,
          lax: true,
          className: "-t-ExportSourceInfoEditor-operation",
          spandrelKey: "operation",
          properties: {
            map: exporterMap
          },
          onUxModifiedValue: function onUxModifiedValue(op) {
            return self.$setCurrentOp(op);
          }
        }))), spandrel.jsx("tr", {
          className: "ux-table-row -t-ExportSourceInfoEditor-setupLayout",
          spandrelKey: "operationSetup"
        }, spandrel.jsx("td", {
          spandrelKey: "setupLabel"
        }, setupLabel), spandrel.jsx("td", null, spandrel.jsx(PropertySheet, {
          className: "-t-ExportSourceInfoEditor-exporterObj",
          bind: true,
          spandrelKey: "exporterObj",
          value: exporterObj || baja.$('baja:Component'),
          properties: {
            showHeader: false,
            readBehavior: "copy"
          }
        }))))];
      }
    }, {
      key: "doLoad",
      value: function doLoad() {
        var _this2 = this;
        return _superPropGet(ExportSourceInfoEditor, "doLoad", this, 3)(arguments).then(function () {
          var sourceEditor = _this2.$getSourceEditor();
          if (sourceEditor) {
            _this2.$popoutCmd.setWatchedEditor(sourceEditor);
          }
        });
      }

      /**
       * @param {module:nmodule/report/rc/baja/ExportSourceInfo} exportSourceInfo loaded export source info object
       * @returns {Promise.<baja.Value>}
       */
    }, {
      key: "toState",
      value: function toState(exportSourceInfo) {
        var _this3 = this;
        exportSourceInfo = exportSourceInfo || ExportSourceInfo.DEFAULT;
        var sourceOrd = exportSourceInfo.getSource();
        var agentId = exportSourceInfo.getAgentId();
        return Promise.all([this.$makeExporterMap(this.state().formFactor, sourceOrd), exportSourceInfo.getExporterValue(), exportUtils.getUserConfiguration()]).then(function (_ref) {
          var _ref2 = _slicedToArray(_ref, 3),
            newExporterMap = _ref2[0],
            exporterObj = _ref2[1],
            userConfiguration = _ref2[2];
          var exporterMap = newExporterMap;
          _this3.$userConfiguration = userConfiguration;
          var currentOp = _this3.$getCurrentOp(agentId, exporterMap);

          //store the exportObj for the current op into the exporterMap for later retrieval
          if (currentOp && exporterObj) {
            var transformers = userConfiguration.transformers;
            if (!transformers) {
              transformers = {};
              _this3.$userConfiguration.transformers = transformers;
            }
            transformers[currentOp.getDisplayName()] = compUtils.toObject(exporterObj, {
              deep: true
            });
          }
          return {
            sourceOrd: sourceOrd,
            agentId: agentId,
            currentOp: currentOp,
            exporterObj: exporterObj,
            exporterMap: exporterMap
          };
        });
      }

      /**
       * @param {object} state the current state for the editor
       * @private
       * @returns {Promise.<module:nmodule/report/rc/baja/ExportSourceInfo>}
       */
    }, {
      key: "fromState",
      value: function fromState(state) {
        var sourceOrd = state.sourceOrd,
          agentId = state.agentId,
          exporterObj = state.exporterObj;
        return exporterObj ? ExportSourceInfo.makeFromExporter(sourceOrd, agentId, exporterObj) : ExportSourceInfo.make(sourceOrd, agentId, "");
      }

      /**
       * Returns an OrderedMap based on the formfactor and source ord.  If the formfactor = 'mini' the
       *  OrderMap will be the DEFAULT OrderedMap
       *
       * @private
       * @param {String} formFactor the formfactor of the editor
       * @param {baja.Ord} source the source Ord
       * @returns {Promise<baja.OrderedMap>}
       */
    }, {
      key: "$makeExporterMap",
      value: function $makeExporterMap(formFactor, source) {
        if (formFactor !== 'mini' && !source.isNull()) {
          return source.get().then(function (ord) {
            return exportUtils.makeOperationMap(ord);
          });
        }
        return Promise.resolve(new baja.OrderedMap());
      }

      /**
       *
       * @private
       * @param {String} agentId the string value that represents the agentId or transformerSpec
       * @param {baja.OrderedMap} exporterMap
       * @returns {module:nmodule/export/rc/TransformOperation|null}
       */
    }, {
      key: "$getCurrentOp",
      value: function $getCurrentOp(agentId, exporterMap) {
        var currentOp;
        var cursor = exporterMap.getCursor();
        cursor.each(function (element) {
          var transformer = element.getTransformer();
          var transformerSpec = transformer.getExporterTypeSpec();
          if (transformerSpec === agentId) {
            currentOp = element;
            return currentOp;
          }
        });
        return currentOp;
      }

      /**
       * The logic implemented when the source Ord is changed.
       *
       * @private
       * @param {baja.Ord} ord the new ord
       * @returns {Promise}
       */
    }, {
      key: "$setOrd",
      value: function $setOrd(ord) {
        var _this4 = this;
        var _this$state = this.state(),
          currentOp = _this$state.currentOp;
        return this.$makeExporterMap(this.state().formFactor, ord).then(function (operationMap) {
          var exporterMap = operationMap;
          currentOp = exporterMap.getFromIndex(0);
          return _this4.state({
            currentOp: currentOp,
            exporterMap: exporterMap
          }).then(function () {
            return _this4.$setCurrentOp(currentOp);
          });
        });
      }

      /**
       * The logic implemented when the operation selected changes.  It updates the current state
       *  with the new values.
       *
       * @private
       * @param {module:nmodule/export/rc/TransformOperation} [inOp]
       * @returns {Promise}
       */
    }, {
      key: "$setCurrentOp",
      value: function $setCurrentOp(inOp) {
        var _this5 = this;
        var value = inOp || this.state().currentOp;
        return value.getTransformer().getDefaultConfig(value.getTransformedObject()).then(function (config) {
          var userConfig;
          if (_this5.$userConfiguration.transformers) {
            userConfig = _this5.$userConfiguration.transformers[value.getDisplayName()];
          }
          if (userConfig) {
            return userData.fromPersistenceObject(config, userConfig);
          } else {
            return config;
          }
        }).then(function (exporterObj) {
          var agentId = value.getTransformer().getExporterTypeSpec();
          return _this5.state({
            agentId: agentId,
            currentOp: value,
            exporterObj: exporterObj
          });
        });
      }

      /**
       * Returns the layout for the "mini" formFactor
       *
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getMiniLayout",
      value: function $getMiniLayout() {
        return this.queryWidget('layout-mini');
      }

      /**
       * Returns the widget that holds the label for the source Ord editor
       *
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getSourceLabel",
      value: function $getSourceLabel() {
        return this.queryWidget('**/sourceLabel');
      }

      /**
       * Returns the source Ord editor
       *
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getSourceEditor",
      value: function $getSourceEditor() {
        return this.queryWidget('**/sourceEditor');
      }

      /**
       * Returns PopOutButton
       *
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getPopOutButton",
      value: function $getPopOutButton() {
        return this.queryWidget("**/popOutCommandButton");
      }

      /**
       * Returns the label for the operation editor
       *
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getOperationLabel",
      value: function $getOperationLabel() {
        return this.queryWidget("**/operationLabel");
      }

      /**
       * Returns the operation editor
       *
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getOperation",
      value: function $getOperation() {
        return this.queryWidget("**/operation");
      }

      /**
       * Returns label for the setup label
       *
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getSetupLabel",
      value: function $getSetupLabel() {
        return this.queryWidget("**/setupLabel");
      }

      /**
       * Returns the setup label
       *
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getExporterObjEditor",
      value: function $getExporterObjEditor() {
        return this.queryWidget("**/exporterObj");
      }
    }]);
  }(spandrel(function (exportSourceInfo, state) {
    return state.self.$buildEditor(state);
  }, {
    strategy: 'niagara'
  }));
  return ExportSourceInfoEditor;
});
