function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2022 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/report/rc/baja/ExportSourceInfo
 */

define(['baja!', 'Promise', 'nmodule/webEditors/rc/servlets/valueDocEncodingUtil'], function (baja, Promise, valueDocEncodingUtil) {
  'use strict';

  /**
   * BajaScript class that represents a report:ExportSourceInfo`.  Used to access the properties of
   * an ExportSourceInfo and encapsulate the necessary RPC calls.
   *
   * When creating a `Simple`, always use the `make()` method instead of
   * creating a new Object.
   *
   * @class
   * @alias module:nmodule/report/rc/baja/ExportSourceInfo
   * @extends baja.Simple
   * @since Niagara 4.13
   */
  var ExportSourceInfo = /*#__PURE__*/function (_baja$Simple) {
    /**
     * @param {baja.Ord} source the source ORD
     * @param {string} [agentId] the exporter agent id
     * @param {string} [exporterXml] a XML string that holds the exporter information
     */
    function ExportSourceInfo(source, agentId, exporterXml) {
      var _this;
      _classCallCheck(this, ExportSourceInfo);
      _this = _callSuper(this, ExportSourceInfo);
      _this.$source = source;
      _this.$agentId = agentId;
      _this.$exporterXml = exporterXml || "";
      return _this;
    }

    /**
     * Creates an ExportSourceInfo instance
     * @param {baja.Ord} source the source ORD
     * @param {string} [agentId ]the exporter agent id
     * @param {string} [exporterXml] a XML string that holds the exporter information
     * @returns {module:nmodule/report/rc/baja/ExportSourceInfo}
     */
    _inherits(ExportSourceInfo, _baja$Simple);
    return _createClass(ExportSourceInfo, [{
      key: "make",
      value:
      /**
       * Creates an ExportSourceInfo instance
       * @param {baja.Ord} source the source ORD
       * @param {string} [agentId] the exporter agent id
       * @param {string} [exporterXml] a XML string that holds the exporter information
       * @returns {module:nmodule/report/rc/baja/ExportSourceInfo}
       */
      function make(source, agentId, exporterXml) {
        return ExportSourceInfo.make(source, agentId, exporterXml);
      }

      /**
       * Creates an ExportSourceInfo instance
       * @param {string} strValue a formatted string that hold the properties of a ExportSourceInfo
       * @returns {module:nmodule/report/rc/baja/ExportSourceInfo}
       */
    }, {
      key: "decodeFromString",
      value:
      /**
       * Decodes a string and creates an ExportSourceInfo instance
       * @param {string} strValue
       * @returns {module:nmodule/report/rc/baja/ExportSourceInfo}
       */
      function decodeFromString(strValue) {
        //lets handle a null or undefined value
        if (!strValue) {
          return ExportSourceInfo.DEFAULT;
        }

        // lets us determine where the exporter starts and split the string at that point
        var index = strValue.indexOf("<p");
        var strRem = strValue;
        var exporterXml;
        var agentId;
        var source;
        if (index >= 0) {
          strRem = strValue.substring(0, index - 1);
          exporterXml = strValue.substring(index);
        }

        //now that we have got the remainder of the string, lets grab the source.
        index = strRem.indexOf(";");
        if (index >= 0) {
          agentId = strRem.substring(0, index);
          agentId = !agentId || agentId === "null" ? null : agentId;
        }

        //Remove any stray ';' we might have at the end
        source = strRem.substring(index + 1).replaceAll(/;$/g, "");
        return ExportSourceInfo.make(baja.Ord.make(source), agentId, exporterXml);
      }

      /**
       * Encodes this ExportSourceInfo into a string
       * @returns {string}
       */
    }, {
      key: "encodeToString",
      value: function encodeToString() {
        var returnStr;
        returnStr = (!this.$agentId ? "null" : this.$agentId) + ";" + (!this.$source ? 'null' : this.$source.encodeToString());
        if (this.$exporterXml) {
          returnStr = returnStr + ";" + this.$exporterXml;
        }
        return returnStr;
      }

      /**
       * @returns {baja.FacetsMap} the DEFAULT instance
       */
    }, {
      key: "getAgentId",
      value:
      /**
       * Returns the agent id out of the instance
       * @returns {string|null}
       */
      function getAgentId() {
        return this.$agentId;
      }

      /**
       * Returns the source of the instance as an Ord
       * @returns {baja.Ord}
       */
    }, {
      key: "getSource",
      value: function getSource() {
        return this.$source;
      }

      /**
       * Returns the exporter of the instance as XML string
       * @returns {string}
       */
    }, {
      key: "getExporterXml",
      value: function getExporterXml() {
        return this.$exporterXml;
      }

      /**
       * Returns the exporter as a baja.Value
       * @returns {Promise.<baja.Value>}
       */
    }, {
      key: "getExporterValue",
      value: function getExporterValue() {
        var _this2 = this;
        if (!this.$exporterObj && this.$exporterXml) {
          return valueDocEncodingUtil.unmarshal(this.$exporterXml).then(function (value) {
            _this2.$exporterObj = value;
            return value;
          });
        }
        return Promise.resolve(this.$exporterObj);
      }

      /**
       * Returns an object that has the configuration information for the exporter
       *
       * @returns {Promise.<Object>} an object that holds the configuration for the exporter
       */
    }, {
      key: "getExporterConfiguration",
      value: function getExporterConfiguration() {
        var _this3 = this;
        if (!this.$exporterConfiguration && this.$exporterXml) {
          return this.getExporterValue().then(function (value) {
            _this3.$exporterConfiguration = value.getSlots().properties().toValueMap();
            return _this3.$exporterConfiguration;
          });
        }
        return Promise.resolve(this.$exporterConfiguration);
      }
    }], [{
      key: "make",
      value: function make(source, agentId, exporterXml) {
        return new ExportSourceInfo(source, agentId, exporterXml);
      }
    }, {
      key: "makeFromString",
      value: function makeFromString(strValue) {
        return ExportSourceInfo.prototype.decodeFromString(strValue);
      }

      /**
       * Creates an ExportSourceInfo instance
       * @param {baja.Ord} source the source ORD
       * @param {string} [agentId] the exporter agent id
       * @param {baja.Value} [exporter] a baja.value that holds the exporter
       * @returns {Promise.<module:nmodule/report/rc/baja/ExportSourceInfo>}
       */
    }, {
      key: "makeFromExporter",
      value: function makeFromExporter(source, agentId, exporter) {
        this.$exporterObj = exporter;
        return valueDocEncodingUtil.marshal(exporter).then(function (exporterXml) {
          var sourceInfo = ExportSourceInfo.make(source, agentId, exporterXml);
          sourceInfo.$exporterObj = exporter;
          return sourceInfo;
        });
      }
    }, {
      key: "DEFAULT",
      get: function get() {
        return DEFAULT;
      }

      /**
       * @returns {baja.FacetsMap} the NULL instance
       */
    }, {
      key: "NULL",
      get: function get() {
        return DEFAULT;
      }
    }]);
  }(baja.Simple);
  var DEFAULT = new ExportSourceInfo();
  baja.registerType('report:ExportSourceInfo', function () {
    return ExportSourceInfo;
  });
  return ExportSourceInfo;
});
