/*  
 * Copyright 2005 Tridium, Inc. All Rights Reserved.
 */

/**
 * TableView JavaScript support.
 *
 * @author    Andy Frank
 * @creation  22 Mar 05
 * @version   $Revision$ $Date$
 * @since     Baja 1.0
 */

////////////////////////////////////////////////////////////////
// TableView
////////////////////////////////////////////////////////////////

var tableView = new TableView();
function TableView() {
  ////////////////////////////////////////////////////////////////
  // Selection
  ////////////////////////////////////////////////////////////////

  /**
   * Select/deselect all rows in table.
   */
  this.selectAll = function (event) {
    var checkbox = !event.target ? window.event.srcElement : event.target;
    var parentNode = checkbox;
    while (parentNode.tagName != 'TR') {
      parentNode = parentNode.parentNode;
    }
    var tr = parentNode.nextSibling;
    while (tr != null) {
      var rowcheckbox = tr.getElementsByTagName("input")[0];
      if (rowcheckbox != null) {
        rowcheckbox.checked = checkbox.checked;
      }
      tr = tr.nextSibling;
    }
  };

  /**
   * Select the editor - if selected, make editable, if
   * unselected, make readonly.
   */
  this.selectEditor = function (event) {
    var checkbox = !event.target ? window.event.srcElement : event.target;
    var parentNode = checkbox;
    while (parentNode.tagName != 'TR') {
      parentNode = parentNode.parentNode;
    }
    var td = parentNode.childNodes[2]; // editor
    tableView.enableEditors(td);
  };

  /**
   * Recurse an element toggled enabled state.
   */
  this.enableEditors = function (elem) {
    if (elem == null || elem.nodeType != 1) return;

    // Toggle enable
    if (elem.nodeName == "INPUT" || elem.nodeName == "SELECT") {
      if (elem.disabled || elem.readOnly) {
        elem.disabled = "";
        elem.readOnly = "";
      } else {
        elem.disabled = "disabled";
        elem.readOnly = "readonly";
      }
    }

    // Recurse children
    for (var i = 0; i < elem.childNodes.length; i++) tableView.enableEditors(elem.childNodes[i]);
  };
}
