/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/kitControl/rc/baja/util/Switch
 */
define(['baja!', 'nmodule/webEditors/rc/baja/bajaUtils'], function (baja, bajaUtils) {
  'use strict';

  var Component = baja.Component,
    proxySlotFacets = bajaUtils.proxySlotFacets;

  /**
   * BajaScript representation of a `kitControl:Switch` value.
   *
   * @class
   * @extends {baja.Component}
   * @alias {module:nmodule/kitControl/rc/baja/util/Switch}
   */
  var Switch = function Switch() {
    Component.apply(this, arguments);
    proxySlotFacets(this, {
      '^out': 'facets'
    });
  };
  Switch.prototype = Object.create(Component.prototype);
  Switch.prototype.constructor = Switch;
  return Switch;
});
