/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/kitControl/rc/baja/conversion/IntToStatusNumeric
 */
define(['baja!', 'nmodule/webEditors/rc/baja/bajaUtils'], function (baja, bajaUtils) {
  'use strict';

  var Component = baja.Component,
    proxySlotFacets = bajaUtils.proxySlotFacets;
  /**
   * BajaScript representation of a `kitControl:IntToStatusNumeric` value.
   *
   * @class
   * @extends {baja.Component}
   * @alias {module:nmodule/kitControl/rc/baja/conversion/IntToStatusNumeric}
   */
  var IntToStatusNumeric = function IntToStatusNumeric() {
    Component.apply(this, arguments);
    proxySlotFacets(this, {
      '^out$': 'facets'
    });
  };
  IntToStatusNumeric.prototype = Object.create(Component.prototype);
  IntToStatusNumeric.prototype.constructor = IntToStatusNumeric;
  return IntToStatusNumeric;
});
