/*
 * Copyright 2005 Tridium, Inc. All Rights Reserved.
 */

/**
 * wiegandFormat
 *
 * @author    JJ Frankovich
 * @creation  08 Jan 06
 * @version   $Revision$ $Date$
 * @since     Baja 1.0
 */
var wiegandFormat = new WiegandFormat();

function WiegandFormat() {
  'use strict';

  this.maxBitLength = 256;
  this.maxParityBits = 5;
  this.parityText = "Parity Layout ";
  this.lengthWarning = "Only Wiegand Formats of length 16 to " + this.maxBitLength + " are supported.";
  this.parityLengthWarning = "Only 0 to " + this.maxParityBits + " Parity Bits are supported.";
  this.fixFacilityRange = "Please Fix Facility Range.";
  this.fixCredentialRange = "Please Fix Credential Range.";
  this.overlapWarning = "Please Fix Credential and Facility Overlap (?).";
  this.notEnoughParity = "Not enough Parity Bits (Add P's to Format).";
  this.tooManyParity = "Too many Parity Bits (Remove P's from Format).";
  this.atLeastOneErO = ": At least one E or O ";
  this.mustOverlapAtLeastOneCorF = "must overlap with at least one Credential (N) or Facility Code (F).";
  this.mustOverlapExactlyOneParity = ": E's or O's must overlap with exactly 1 new Parity (P). There is currently no new overlap.";
  this.mustOverlapExactlyOneNewParity = ": E's or O's must overlap with exactly 1 new Parity (P). Current new overlap: ";
  this.cannotMixEAndO = ": Cannot mix and match E's and O's within a single parity layout.";
  this.eOrOMustBeDefined = ": Even or Odd Parity Must be defined (Add either E's or O's)."; // eslint-disable-next-line no-use-before-define

  this.resize = function (scope) {
    // eslint-disable-next-line no-undef
    var size = document.getElementById(scope + ".bitLength").value;
    var s = parseInt(size); // eslint-disable-next-line no-undef

    var f = document.getElementById(scope + ".format");
    f.size = s;
    var fValue = f.value;

    if (fValue.length > s) {
      f.value = fValue.substring(0, s);
    } else {
      var tmp = fValue;

      for (var i = fValue.length; i < s; i++) {
        tmp += "-";
      }

      f.value = tmp;
    } // eslint-disable-next-line no-redeclare


    for (var i = 0; i < wiegandFormat.maxParityBits; i++) {
      // eslint-disable-next-line no-undef
      var p = document.getElementById(scope + ".parity" + i);
      p.size = s;
      var pValue = p.value;

      if (pValue.length > s) {
        p.value = pValue.substring(0, s);
      } else {
        // eslint-disable-next-line no-redeclare
        var tmp = pValue;

        for (var j = pValue.length; j < s; j++) {
          tmp += "-";
        }

        p.value = tmp;
      }
    }
  };

  this.parityFix = function (scope) {
    // eslint-disable-next-line no-undef
    var parityBits = parseInt(document.getElementById(scope + ".parityBits").value);

    for (var i = 0; i < wiegandFormat.maxParityBits; i++) {
      // eslint-disable-next-line no-undef
      var p = document.getElementById(scope + ".parityRow" + i);

      if (i < parityBits) {
        p.style.display = "";
      } else {
        p.style.display = "none";
      }
    }
  };

  this.recalculate = function (scope) {
    this.resize(scope); // eslint-disable-next-line no-undef

    var facStartBit = document.getElementById(scope + ".facilityStart"); // eslint-disable-next-line no-undef

    var facilityBitLength = document.getElementById(scope + ".facilityLength"); // eslint-disable-next-line no-undef

    var credentialStartBit = document.getElementById(scope + ".credentialStart"); // eslint-disable-next-line no-undef

    var credentialBitLength = document.getElementById(scope + ".credentialLength"); // eslint-disable-next-line no-undef

    var format = document.getElementById(scope + ".format"); // eslint-disable-next-line no-undef

    var parityBits = parseInt(document.getElementById(scope + ".parityBits").value); // eslint-disable-next-line no-undef

    var warning = document.getElementById(scope + ".warning");
    var warningText = "";
    var fS = parseInt(facStartBit.value);
    var fL = parseInt(facilityBitLength.value);
    var cS = parseInt(credentialStartBit.value);
    var cL = parseInt(credentialBitLength.value);
    var f = format.value.toUpperCase();
    var newFormat = "";
    var pCount = 0;
    var overlap = 0;

    if (f.length < 16 || f.length > wiegandFormat.maxBitLength) {
      warningText = this.lengthWarning;
    }

    if (parityBits < 0 || parityBits > wiegandFormat.maxParityBits) {
      warningText = this.parityLengthWarning;
    }

    if (fS < 0 || fS + fL > f.length || fL < 0) {
      if (warningText.length > 0) {
        warningText += "<br/>";
      }

      warningText += this.fixFacilityRange;
    }

    if (cS < 0 || cS + cL > f.length || cL <= 0) {
      if (warningText.length > 0) {
        warningText += "<br/>";
      }

      warningText += this.fixCredentialRange;
    }

    for (var i = 0; i < f.length; i++) {
      if (i >= fS && i < fS + fL && i >= cS && i < cS + cL) {
        newFormat += "?";
        overlap++;
      } else if (i >= fS && i < fS + fL) {
        newFormat += "F";
      } else if (i >= cS && i < cS + cL) {
        newFormat += "N";
      } else if (f.charAt(i) === '0' || f.charAt(i) === '1' || f.charAt(i) === 'P') {
        newFormat += f.charAt(i);

        if (f.charAt(i) === 'P') {
          pCount++;
        }
      } else {
        newFormat += '-';
      }
    }

    format.value = newFormat;

    if (overlap > 0) {
      if (warningText.length > 0) {
        warningText += "<br/>";
      }

      warningText += this.overlapWarning;
    }

    if (pCount < parityBits) {
      if (warningText.length > 0) {
        warningText += "<br/>";
      }

      warningText += this.notEnoughParity;
    } else if (pCount > parityBits) {
      if (warningText.length > 0) {
        warningText += "<br/>";
      }

      warningText += this.tooManyParity;
    }

    var parityLayouts = []; //check for valid bits
    // eslint-disable-next-line no-redeclare

    for (var i = 0; i < parityBits && i < wiegandFormat.maxParityBits; i++) {
      // eslint-disable-next-line no-undef
      var parity = document.getElementById(scope + ".parity" + i);
      var p = parity.value.toUpperCase();
      parityLayouts[i] = p;
      var newParity = "";
      var credentialCount = 0;
      var flexibleParityCount = 0; // eslint-disable-next-line no-unused-vars

      var parityCount = 0;

      for (var j = 0; j < p.length; j++) {
        if (p.charAt(j) === 'E' || p.charAt(j) === 'O') {
          if (newFormat.charAt(j) === '-') {
            newParity += '-';
          } else {
            if (newFormat.charAt(j) === 'P') {
              //check for already covered parities
              var isFlex = true;

              for (var k = i - 1; k >= 0; k--) {
                if (parityLayouts[k].charAt(j) === 'E' || parityLayouts[k].charAt(j) === 'O') {
                  isFlex = false;
                  break;
                }
              }

              if (isFlex) {
                flexibleParityCount++;
              }

              newParity += p.charAt(j);
            } else {
              newParity += p.charAt(j);
            }
          }

          if (newFormat.charAt(j) === 'N' || newFormat.charAt(j) === 'F') {
            credentialCount++;
          } else if (newFormat.charAt(j) === 'P') {
            // eslint-disable-next-line no-unused-vars
            parityCount++;
          }
        } else {
          newParity += '-';
        }
      }

      parity.value = newParity; //check for credential/facility overlap

      if (credentialCount === 0) {
        if (warningText.length > 0) {
          warningText += "<br/>";
        }

        warningText += this.parityText + (1 + i) + this.atLeastOneErO;
        warningText += this.mustOverlapAtLeastOneCorF;
      } //check for correct P alignment


      if (flexibleParityCount < 1) {
        if (warningText.length > 0) {
          warningText += "<br/>";
        }

        warningText += this.parityText + (1 + i) + this.mustOverlapExactlyOneParity;
      }

      if (flexibleParityCount > 1) {
        if (warningText.length > 0) {
          warningText += "<br/>";
        }

        warningText += this.parityText + (1 + i) + this.mustOverlapExactlyOneNewParity + flexibleParityCount;
      } //check parities for validity


      if (newParity.indexOf("E") > -1 && newParity.indexOf("O") > -1) {
        if (warningText.length > 0) {
          warningText += "<br/>";
        }

        warningText += this.parityText + (i + 1) + this.cannotMixEAndO;
      } else if (newParity.indexOf("E") === -1 && newParity.indexOf("O") === -1) {
        if (warningText.length > 0) {
          warningText += "<br/>";
        }

        warningText += this.parityText + (i + 1) + this.eOrOMustBeDefined;
      }
    } //set warnings


    warning.innerHTML = warningText; // eslint-disable-next-line no-undef

    if (warningText.length === 0) {
      save.enable();
    } else {
      save.disable();
    }
  };
}
