function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * @Copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author Shivani Jakhmola
 */
define(['baja!', 'dialogs', 'Promise', 'lex!entsecHx'], function (baja, dialogs, Promise, lexs) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
      lex = _lexs[0];
  /**
   * API Status: **Private**
   * @exports nmodule/entsecHx/rc/photoID/rpc/rpc
   */


  var exports = {};

  var callRpc = function callRpc(typeSpec, methodName, args) {
    return baja.rpc({
      typeSpec: typeSpec,
      methodName: methodName,
      args: args
    });
  };

  var callRpcWithOrd = function callRpcWithOrd(ord, methodName, args) {
    return baja.rpc({
      ord: ord,
      methodName: methodName,
      args: args
    });
  };
  /**
   * Display an error dialog, inserting the error text into the failure message.
   */


  var showErrorDialog = function showErrorDialog(err) {
    dialogs.showOk({
      title: lex.getSafe('PhotoIdView.invalidOrd.dialog.title'),
      content: lex.getSafe('PhotoIdView.invalidOrd', err)
    });
    return Promise.reject(err);
  };
  /**
   * catch the Ord error and show error dialog
   */


  exports.getOrd = function (makeArgs) {
    var getArgs = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : undefined;
    var ordPath = baja.Ord.make(makeArgs);
    var promise = ordPath.get();

    if (getArgs) {
      promise = ordPath.get(getArgs);
    }

    return promise["catch"](function (err) {
      showErrorDialog(err);
    });
  };
  /**
   * Connected cameras will be returned from the cache.
   *
   *  @returns {Promise}
   */


  exports.getCameras = function (videoPlaybackMillstreamOrd, encodedFilterSet) {
    return callRpc('entsecHx:PhotoIDUxRpc', 'getCameraList', [String(videoPlaybackMillstreamOrd), String(encodedFilterSet)]);
  };
  /**
   * RPC to Resolve a promise with the readers from local and remote station
   *
   * @returns {Promise}
   */


  exports.getReaders = function (videoPlaybackMillstreamOrd, encodedFilterSet) {
    return callRpc('entsecHx:PhotoIDUxRpc', 'getReaders', [String(videoPlaybackMillstreamOrd), String(encodedFilterSet)]);
  };
  /**
   * Adds PhotoIdCamera to the slot sheet of the photoIdViewer component.
   *
   * @param {Array<string>} args - camera uuid to add
   * @returns {Promise}
   */


  exports.addPhotoIdCamera = function (args) {
    return callRpc('entsec:PhotoIDViewerComponent', 'addPhotoIDCameraRpc', args);
  };
  /**
   * Calls monitor door rpc on PhotoIdCamera.
   *
   * @param {baja.Ord} ord
   * @returns {Promise}
   */


  exports.monitorDoorRpc = function (ord) {
    return callRpcWithOrd(ord, 'monitorDoorRPC');
  };
  /**
   * Calls keepAliveMonitorRPC on PhotoIdCamera.
   *
   * @param {baja.Ord} ord
   * @returns {Promise}
   */


  exports.keepAliveMonitorRPC = function (ord) {
    return callRpcWithOrd(ord, 'keepAliveMonitorRPC');
  };
  /**
   * Calls the server which returns the byte string of the blob image.
   *
   * @param ord
   * @returns {Promise}
   */


  exports.getImageBytes = function (ord) {
    return callRpc('entsecHx:PhotoIDUxRpc', 'getImageBytes', [String(ord)]);
  };
  /**
   * Portrait Height to be used is set as a system property, using rpc we fetch the value.
   *
   * @returns {Number}
   */


  exports.getPortraitHeight = function () {
    return callRpc('entsecHx:PhotoIDUxRpc', 'getPortraitHeight');
  };
  /**
   * Portrait Height to be used is set as a system property, using rpc we fetch the value.
   *
   * @returns {Number}
   */


  exports.saveImage = function (personId, imageOrd, bytes) {
    return callRpc('entsecHx:PhotoIDUxRpc', 'saveImage', [String(personId), String(imageOrd), String(bytes)]);
  };
  /**
   * Portrait Height to be used is set as a system property, using rpc we fetch the value.
   *
   * @returns {Number}
   */


  exports.deleteImage = function (imageOrd) {
    return callRpc('entsecHx:PhotoIDUxRpc', 'deleteImage', [String(imageOrd)]);
  };
  /**
   *
   * @param {string} timeInMillis
   * @returns {Promise}
   */


  exports.getLockStatus = function (timeInMillis) {
    return callRpc('entsecHx:PhotoIDUxRpc', 'getLockStatus', [String(timeInMillis)]);
  };

  return exports;
});
