function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * Copyright 2021 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/entsecHx/rc/photoID/photoIdWakeUp
 */
// eslint-disable-next-line no-unused-vars
var photoIdWakeUp = new PhotoIdWakeUp();

function PhotoIdWakeUp() {
  'use strict'; // eslint-disable-next-line no-undef

  var $ = jQuery;
  var that = this;
  this.$isTimeoutReached = false;
  var TIME_OUT = 3000;
  /**
   *
   * @param {module:nmodule/entsecHx/rc/photoID/rpc/rpc} rpc
   * @return {Promise}
   */

  this.$getStatus = function () {
    if (that.$rpc) {
      return that.$rpc.getLockStatus(that.$timeInMillis).then(function (isLocked) {
        if (that.$isTimeoutReached) {
          return true;
        } else {
          if (isLocked) {
            return isLocked;
          } else {
            return that.$getStatus();
          }
        }
      });
    } else {
      return Promise.resolve(false);
    }
  };
  /**
   *
   * @param request
   * @param invalidResponseMessage
   */


  this.$showError = function (request, invalidResponseMessage) {
    if (that.$feDialogs) {
      that.$feDialogs.error(new Error(request.status + " " + request.statusText), {
        messageSummary: invalidResponseMessage
      });
    }
  };
  /**
   * @param {string} port
   * @param {string} invalidResponseMessage
   * @return {Promise}
   */


  this.$callAsureIdServer = function (port, invalidResponseMessage) {
    return $.ajax({
      type: "POST",
      url: 'http://localhost:' + port,
      contentType: 'application/json',
      error: function error(request) {
        that.$showError(request, invalidResponseMessage);
      },
      data: {
        "message": "asureIDClientPush"
      },
      crossDomain: true,
      dataType: 'jsonp'
    });
  };
  /**
   * Sets a fail safe timeout to avoid infinite loop.
   */


  this.$applyFailSafeTimeout = function () {
    that.$isTimeoutReached = false; // eslint-disable-next-line no-undef

    setTimeout(function () {
      that.$isTimeoutReached = true;
    }, TIME_OUT);
  };
  /**
   *
   * @param timeInMillis
   * @param port
   * @param invalidResponseMessage
   * @return {Promise}
   */


  this.wakeupPhotoId = function (port, timeInMillis, invalidResponseMessage) {
    if (timeInMillis === 0) {
      return that.$callAsureIdServer(port, invalidResponseMessage);
    } else {
      var asyncUtils = require('nmodule/js/rc/asyncUtils/asyncUtils');

      return asyncUtils.doRequire(['nmodule/webEditors/rc/fe/feDialogs', 'nmodule/entsecHx/rc/photoID/rpc/rpc']).then(function (_ref) {
        var _ref2 = _slicedToArray(_ref, 2),
            feDialogs = _ref2[0],
            rpc = _ref2[1];

        that.$feDialogs = feDialogs;
        that.$rpc = rpc;
        that.$timeInMillis = timeInMillis;
        that.$applyFailSafeTimeout();
        return that.$getStatus().then(function (status) {
          if (status) {
            return that.$callAsureIdServer(port, invalidResponseMessage);
          }
        });
      });
    }
  };
}
