function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/**
 * Copyright 2021 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/entsecHx/rc/photoID/PortraitWidget
 */
define(['baja!', 'bajaux/Widget', 'jquery', 'dialogs', 'Promise', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/fe/BaseWidget', 'nmodule/entsecHx/rc/photoID/CropWidget', 'nmodule/entsecHx/rc/photoID/CaptureWidget', 'nmodule/entsecHx/rc/photoID/rpc/rpc', 'nmodule/webEditors/rc/fe/fe', 'bajaux/commands/Command', 'bajaux/util/CommandButton', 'lex!entsecHx', 'css!nmodule/entsecHx/rc/entsecHx'], function (baja, Widget, $, dialogs, Promise, feDialogs, BaseWidget, CropWidget, CaptureWidget, rpc, fe, Command, CommandButton, lexs) {
  'use strict';

  var lex = lexs[0];

  var tpl = function tpl() {
    return "<div class=\"portraitContainer\"> \n                          <div class=\"imageContainer\">\n                             <img class=\"imgCrop\" />\n                          </div>\n                          <div class=\"options\">\n                            <button type=\"button\" class=\"capture\"/> \n                            <button type=\"button\" class=\"initCrop icon-icons-x16-resize\" title=\"".concat(lex.getSafe('cropOption.crop.label'), "\" />\n                            <button type=\"button\" class=\"reset\" title=\"").concat(lex.getSafe('cropOption.reset.label'), "\">").concat(lex.getSafe('cropOption.reset.label'), "</button>\n                            <button type=\"button\" class=\"delete\"/> \n                            <input type=\"file\" class=\"fileInput\" accept=\".png,.jpg,.jpeg\"/>\n                          </div>\n                      </div>");
  };
  /**
   * Class to show the Portrait in the person page.
   *
   ** API Status: **Private**
   * @class
   * @alias module:nmodule/entsecHx/rc/photoID/PortraitWidget
   * @extends module:nmodule/webEditors/rc/fe/BaseWidget
   */


  return /*#__PURE__*/function (_BaseWidget) {
    _inherits(PortraitWidget, _BaseWidget);

    var _super = _createSuper(PortraitWidget);

    function PortraitWidget(params) {
      var _this;

      _classCallCheck(this, PortraitWidget);

      _this = _super.call(this, params);
      _this.$deleteCommand = new Command({
        module: 'entsecHx',
        lex: 'deleteCommand',
        func: function func() {
          _this.$deleteClickHandler()["catch"](feDialogs.error);
        }
      });
      _this.$captureCommand = new Command({
        module: 'entsecHx',
        lex: 'captureCommand',
        func: function func() {
          return _this.$initCaptureWidget();
        }
      });
      return _this;
    }

    _createClass(PortraitWidget, [{
      key: "doInitialize",
      value: function doInitialize(dom) {
        var _this2 = this;

        dom.html(tpl()).addClass('PortraitWidget');
        dom.on('change', '.fileInput', function (evt) {
          _this2.$fileHandler(evt);

          return false;
        }).on('click', '.initCrop', function () {
          _this2.$initCropWidget()["catch"](feDialogs.error);

          return false;
        }).on('click', '.reset', function () {
          _this2.$setImage(_this2.$loadedImgSrc);

          _this2.$resetFileInput();

          return false;
        });
        return Promise.all([fe.buildFor({
          formFactor: 'mini',
          type: CommandButton,
          dom: dom.find('.capture'),
          value: this.$captureCommand
        }), fe.buildFor({
          formFactor: 'mini',
          type: CommandButton,
          dom: dom.find('.delete'),
          value: this.$deleteCommand
        })]);
      }
      /**
       * Removes the image.
       *
       * @private
       * @returns {Promise}
       */

    }, {
      key: "$deleteClickHandler",
      value: function $deleteClickHandler() {
        var _this3 = this;

        this.$removeImage();
        this.$resetFileInput();
        return rpc.deleteImage(this.$getValueOrd()).then(function (success) {
          if (success) {
            return _this3.$setValueOrd(null);
          }
        });
      }
      /**
       * Change handler method for fileInput.
       *
       * @private
       * @param {Event} evt
       */

    }, {
      key: "$fileHandler",
      value: function $fileHandler(evt) {
        var _this4 = this;

        var file = this.$getFile(evt);

        if (file) {
          // eslint-disable-next-line no-undef
          var reader = new FileReader();

          reader.onload = function (evt) {
            _this4.$fileLoadedHandler(evt, file);
          };

          reader.readAsDataURL(file);
        }
      }
      /**
       * @private
       * @returns {JQuery}
       */

    }, {
      key: "$getFileElement",
      value: function $getFileElement() {
        return this.jq().find('.fileInput');
      }
      /**
       * @private
       */

    }, {
      key: "$resetFileInput",
      value: function $resetFileInput() {
        this.$getFileElement().val('');
      }
      /**
       * @private
       */

    }, {
      key: "$removeImage",
      value: function $removeImage() {
        this.$setImage('');
      }
      /**
       * @private
       * @param {Event} evt
       * @returns {File} file that is uploaded
       */

    }, {
      key: "$getFile",
      value: function $getFile(evt) {
        var file = evt.currentTarget.files[0];

        if (this.$getImageType(file.name) === '') {
          dialogs.showOk({
            title: lex.get('invalidImageType.title'),
            content: lex.getSafe('invalidImageType.message')
          });
          this.$resetFileInput();
          return null;
        } else {
          return file;
        }
      }
      /**
       * @private
       * @param {Event} evt
       */

    }, {
      key: "$fileLoadedHandler",
      value: function $fileLoadedHandler(evt) {
        this.$setImage(evt.currentTarget.result);
      }
      /**
       * Sets the image source.
       *
       * @private
       * @param {string} data in bytes
       */

    }, {
      key: "$setImage",
      value: function $setImage(data) {
        var _this5 = this;

        // Empty being set as src, it's clean to remove the src attribute from Image.
        if (!data || data.length === 0) {
          // Remove the src attribute of the image element and also hide the imageContainer.
          this.$getImageElement().removeAttr('src');
          this.jq().find('.imageContainer').hide();
          return;
        } // Show the hidden image container to set the image and it's width and height.


        this.jq().find('.imageContainer').show(); // eslint-disable-next-line no-undef

        var img = new Image();
        img.addEventListener('load', function () {
          _this5.$setImageWidthAndHeight();

          return _this5.$saveImage();
        }, false);
        img.src = data;
        this.$getImageElement().attr('src', img.src);
      }
      /**
       * Saves the image to the database.
       *
       * @private
       * @returns {Promise}
       */

    }, {
      key: "$saveImage",
      value: function $saveImage() {
        var _this6 = this;

        var imgElement = this.$getImageElement()[0];
        var width = imgElement.offsetWidth;
        var height = imgElement.offsetHeight; // If any of the dimension is 0, there should be an issue with image.
        // Will not proceed to save.

        if (width === 0 || height === 0) {
          return Promise.resolve();
        }

        var canvas = $("<canvas />")[0];
        canvas.width = width;
        canvas.height = height;
        var context = canvas.getContext('2d');
        context.drawImage(imgElement, 0, 0, width, height);
        var imgString = canvas.toDataURL('image/jpg').replace(/^data:image\/(png|jpg);base64,/, "");
        return rpc.saveImage(this.$getPersonId(), this.$getValueOrd(), imgString).then(function (savedImgOrd) {
          if (savedImgOrd) {
            _this6.$setValueOrd(savedImgOrd);
          }
        });
      }
      /**
       * @private
       * @return {string}
       */

    }, {
      key: "$getValueOrd",
      value: function $getValueOrd() {
        return this.value().$ord;
      }
      /**
       * @private
       * @param {string} ord
       */

    }, {
      key: "$setValueOrd",
      value: function $setValueOrd(ord) {
        this.value().$ord = ord;
      }
      /**
       * @private
       * @returns {string} person id.
       */

    }, {
      key: "$getPersonId",
      value: function $getPersonId() {
        var winLocHref = unescape(this.$getLocation());
        var personIdWithView = winLocHref.split("personId=")[1];

        if (personIdWithView) {
          return personIdWithView.split("|")[0];
        }

        return undefined;
      }
      /**
       * Get the browser's `window.location.href`
       */

    }, {
      key: "$getLocation",
      value: function $getLocation() {
        // eslint-disable-next-line no-undef
        return window.location.href;
      }
      /**
       * Returns the image element.
       *
       * @private
       * @returns {JQuery}
       */

    }, {
      key: "$getImageElement",
      value: function $getImageElement() {
        return this.jq().find('.imgCrop');
      }
      /**
       * @private
       */

    }, {
      key: "$disablePortrait",
      value: function $disablePortrait() {
        this.$getImageElement().attr('src', '/module/entsec/rc/silhoutteImage.PNG').attr('title', lex.getSafe('savePerson.message'));
        this.jq().find('.options').hide();
      }
    }, {
      key: "doLoad",
      value: function doLoad() {
        var _this7 = this;

        if (!this.$getPersonId()) {
          this.$disablePortrait();
          return;
        }

        return rpc.getPortraitHeight().then(function (height) {
          _this7.$portraitHeight = height;
          return _this7.$getImageFromBytes().then(function (byteString) {
            if (byteString.length > 0) {
              _this7.$loadedImgSrc = _this7.$getImageElement().attr('src');
            }
          });
        });
      }
      /**
       * Fetches the image bytes for the ord specified.
       *
       * @private
       * @returns {Promise}
       */

    }, {
      key: "$getImageFromBytes",
      value: function $getImageFromBytes() {
        var _this8 = this;

        var ord = this.$getValueOrd();

        if (ord === "null") {
          return Promise.resolve("");
        } else {
          return rpc.getImageBytes(ord).then(function (byteString) {
            if (byteString.length !== 0) {
              var mimeType = _this8.$getImageType(ord);

              if (mimeType.length !== 0) {
                _this8.$getImageElement().attr('src', "data:image/".concat(mimeType, ";base64,") + byteString);
              }
            }

            return byteString;
          });
        }
      }
      /**
       * @private
       * @param {string} imageOrd
       * @returns {string}
       */

    }, {
      key: "$getImageType",
      value: function $getImageType(imageOrd) {
        if (!imageOrd) {
          return '';
        }

        if (imageOrd.indexOf('.jpg') !== -1 || imageOrd.indexOf('.jpeg') !== -1) {
          return 'jpeg';
        } else if (imageOrd.indexOf('.png') !== -1) {
          return 'png';
        }

        return '';
      }
      /**
       * Sets the image's width and height to fit the div.
       *
       * @private
       */

    }, {
      key: "$setImageWidthAndHeight",
      value: function $setImageWidthAndHeight() {
        var img = this.jq().find('.imgCrop'); // Use the natural height of the images
        // This will not force the previous image's width and height to be set for the new image.

        var imageHeight = img[0].naturalHeight;
        var imageWidth = img[0].naturalWidth;
        var ratio = imageWidth / imageHeight;
        var imgContainer = this.jq().find('.imageContainer');

        if (imageHeight > this.$portraitHeight) {
          imgContainer.css('width', "".concat(imageWidth * ratio));
          imgContainer.css('height', this.$portraitHeight);
        } else {
          imgContainer.css('width', imageWidth);
          imgContainer.css('height', imageHeight);
        }
      }
      /**
       * Instantiates the CropWidget class.
       *
       * @private
       * @returns {Promise}
       */

    }, {
      key: "$initCropWidget",
      value: function $initCropWidget() {
        var _this9 = this;

        var imageElement = this.$getImageElement();
        var imageElementSrc = imageElement.attr('src'); // If the image element's src is empty then do not initiate the cropper.

        if (imageElementSrc === undefined || imageElementSrc === '') {
          return Promise.resolve();
        }

        return feDialogs.showFor({
          value: imageElement,
          formFactor: 'mini',
          title: lex.get('cropWidget.title'),
          type: CropWidget
        }).then(function (readValue) {
          if (readValue !== null) {
            _this9.$setImage(readValue);
          }
        });
      }
      /**
       * Instantiates the Capture Widget.
       *
       * @private
       * @return {Promise}
       */

    }, {
      key: "$initCaptureWidget",
      value: function $initCaptureWidget() {
        var _this10 = this;

        return feDialogs.showFor({
          formFactor: 'mini',
          value: this,
          title: lex.get('captureDialog.title'),
          type: CaptureWidget
        }).then(function (bytes) {
          if (bytes !== null) {
            _this10.$setImage(bytes);
          }
        });
      }
    }, {
      key: "doDestroy",
      value: function doDestroy() {
        this.jq().removeClass('PortraitWidget');
        return this.getChildWidgets().destroyAll();
      }
    }]);

    return PortraitWidget;
  }(BaseWidget);
});
