function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/**
 * Copyright 2021 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/entsecHx/rc/photoID/CropWidget
 */
define(['baja!', 'jquery', 'dialogs', 'nmodule/webEditors/rc/fe/BaseWidget', 'nmodule/entsecHx/rc/photoID/uxportrait/cropper.min', 'lex!entsecHx', 'css!nmodule/entsecHx/rc/photoID/uxportrait/cropper.min'], function (baja, $, dialogs, BaseWidget, Cropper, lexs) {
  'use strict';

  var lex = lexs[0];
  var ASP_RATIO_ENUM = {
    '169': 16 / 9,
    '916': 9 / 16,
    '43': 4 / 3,
    '34': 3 / 4,
    'fh': NaN
  };

  var tpl = function tpl() {
    return "<div class=\"CropContainer\">\n                       <div class=\"options\">\n                         <select class=\"ux-select aspOptions\">\n                            <option value=\"169\">".concat(lex.getSafe('aspectRatio.sixteenNine.label'), "</option> \n                            <option value=\"916\">").concat(lex.getSafe('aspectRatio.nineSixteen.label'), "</option> \n                            <option value=\"43\">").concat(lex.getSafe('aspectRatio.fourThree.label'), "</option> \n                            <option value=\"34\">").concat(lex.getSafe('aspectRatio.threeFour.label'), "</option> \n                            <option value=\"fh\">").concat(lex.getSafe('aspectRatio.freehand.label'), "</option> \n                          </select>\n                       </div>\n                       <div class=\"imageContainer\">\n                           <img class=\"imgDlgCrop\" />\n                       </div>\n                     </div> ");
  };
  /**
   ** API Status: **Private**
   * @class
   * @alias module:nmodule/entsecHx/rc/photoID/CropWidget
   * @extends module:nmodule/webEditors/rc/fe/BaseWidget
   */


  return /*#__PURE__*/function (_BaseWidget) {
    _inherits(CropWidget, _BaseWidget);

    var _super = _createSuper(CropWidget);

    function CropWidget(params) {
      var _this;

      _classCallCheck(this, CropWidget);

      _this = _super.call(this, params); // Options to configure cropper.

      _this.options = {
        dragMode: 'crop',
        aspectRatio: 16 / 9,
        initialAspectRatio: 16 / 9,
        viewMode: 3,
        autoCropArea: 0.65,
        restore: false,
        guides: false,
        center: false,
        highlight: false,
        cropBoxMovable: true,
        cropBoxResizable: true,
        toggleDragModeOnDblclick: false,
        ready: function ready() {
          _this.setModified(true);
        },
        cropend: function cropend() {
          _this.setModified(true);
        }
      };
      return _this;
    }

    _createClass(CropWidget, [{
      key: "doInitialize",
      value: function doInitialize(dom) {
        var _this2 = this;

        dom.html(tpl()).addClass('CropWidget');
        dom.on('change', '.aspOptions', function () {
          _this2.$aspectRatioOptionsHandler();

          return false;
        });
      }
      /**
       * Change handler for aspect ratio dropdown.
       *
       * @private
       */

    }, {
      key: "$aspectRatioOptionsHandler",
      value: function $aspectRatioOptionsHandler() {
        var selectedVal = this.jq().find('.aspOptions :selected').val();
        this.options.aspectRatio = ASP_RATIO_ENUM[selectedVal];
        this.$doCrop();
      }
      /**
       * Performs the crop on the set image.
       *
       * @private
       */

    }, {
      key: "$doCrop",
      value: function $doCrop() {
        this.$destroyCropper();
        var img = this.$getImageElement();
        var imgSrc = this.value().attr('src');
        img.attr('src', imgSrc); // Initiate cropper, only if there is an image to crop.

        if (imgSrc && imgSrc !== '') {
          this.cropper = new Cropper(img[0], this.options);
        }
      }
      /**
       * Returns the image element.
       *
       * @private
       * @returns {JQuery}
       */

    }, {
      key: "$getImageElement",
      value: function $getImageElement() {
        return this.jq().find('.imgDlgCrop');
      }
      /**
       * Destroys the cropper if it already exists.
       *
       * @private
       */

    }, {
      key: "$destroyCropper",
      value: function $destroyCropper() {
        if (this.cropper) {
          this.cropper.destroy();
        }
      }
    }, {
      key: "doLoad",
      value: function doLoad() {
        this.$doCrop();
      }
    }, {
      key: "doRead",
      value: function doRead() {
        if (this.cropper) {
          return this.cropper.getCroppedCanvas().toDataURL('image/png');
        }
      }
    }, {
      key: "doDestroy",
      value: function doDestroy() {
        this.$destroyCropper();
        this.jq().removeClass('CropWidget');
        return this.getChildWidgets().destroyAll();
      }
    }]);

    return CropWidget;
  }(BaseWidget);
});
