/*
 * Copyright 2005 Tridium, Inc. All Rights Reserved.
 */

/**
 * Tab JavaScript support for SmartSchedule.
 */
var schedule = new Schedule();

function Schedule() {
  'use strict';

  this.readonly = false;
  this.moving = false;
  this.trueText = "true";
  this.falseText = "false";
  this.newDiv = false;
  this.moveTop = null;
  this.move = null;
  this.top = null;
  this.anchor = null;
  this.anchorTop = null;
  this.selectedDiv = null;
  this.lastDiv = null;
  this.lastDay = null;
  this.copiedDay = null;
  this.copiedDayFormValue = null;
  this.inAction = false;
  this.commandDay = -1;

  this.onreadonlyselectedmousedown = function (elem, event, scope) {
    //console.log("onselectedmousedown");
    schedule.fixDaySelection(elem, event, scope, 2);
    schedule.inAction = false;

    if (schedule.lastDiv != null) {
      schedule.lastDiv.className = "schedule-HxScheduler-dayEvent";
    }

    elem.className = "schedule-HxScheduler-dayEvent schedule-HxScheduler-dayEventSelected";
    schedule.selectedDiv = elem;
    schedule.lastDiv = elem;
    return schedule.finishleftclick(elem, event, scope);
  };

  this.finishleftclick = function (elem, event, scope) {
    // eslint-disable-next-line no-undef
    if (schedule.inAction && !schedule.readonly) {
      return smartTable.endEvent(event);
    }

    schedule.inAction = true;
    var mousePercent = (schedule.clientY(event) + schedule.getScrollOffset() - elem.parentNode.offsetTop) / elem.parentNode.offsetHeight;
    var percent = elem.offsetTop / elem.parentNode.offsetHeight;
    var bottomPercent = (elem.offsetTop + elem.offsetHeight) / elem.parentNode.offsetHeight;
    schedule.move = null;

    if (mousePercent + 0.04 > bottomPercent && (bottomPercent - percent > 0.08 || percent < 0.5)) {
      //console.log("bottom");
      schedule.top = true;
      schedule.anchor = percent;
      schedule.move = null; // eslint-disable-next-line no-undef

      document.body.style.cursor = "n-resize";
    } else if (mousePercent - 0.04 < percent) {
      //console.log("top");
      schedule.top = false;
      schedule.anchor = bottomPercent;
      schedule.move = null; // eslint-disable-next-line no-undef

      document.body.style.cursor = "n-resize";
    } else {
      //console.log("middle");
      schedule.top = true;
      schedule.move = mousePercent;
      schedule.moveTop = percent;
      schedule.anchor = bottomPercent - percent;
    } //setInfo


    var path = scope;
    if (path.length > 0) path = path + ".";
    var value = schedule.getElem(path + "value.value");
    value.value = schedule.getTrueOrFalse(schedule.selectedDiv.innerHTML);
    schedule.setExact(scope); // eslint-disable-next-line no-undef

    return smartTable.endEvent(event);
  };

  this.onselectedmousedown = function (elem, event, scope) {
    var returnValue = schedule.onreadonlyselectedmousedown(elem, event, scope);
    return returnValue;
  };

  this.contextMenu = function (elem, event, scope) {
    schedule.onreadonlyselectedmousedown(elem, event, scope); //right click
    // eslint-disable-next-line no-undef

    if (event.button === 2 || smartTable.forceRightClick) {
      schedule.selectedDiv = null; // eslint-disable-next-line no-undef

      var commands = smartTable.fixCommands(smartTable.elemFromEvent(event), 2); // eslint-disable-next-line no-undef

      smartTable.showRightClickMenu(event, commands);
      schedule.lastDay = elem.parentNode; // eslint-disable-next-line no-undef

      return smartTable.endEvent(event);
    }
  };

  this.moveMiddle = function (elem, event, scope) {
    if (schedule.moving) {
      return;
    } else {
      schedule.moving = true;
    } //console.log("moveMiddle");
    //top movement


    var height = schedule.anchor;
    var oldTop = schedule.moveTop;
    var mousePercent = (schedule.clientY(event) + schedule.getScrollOffset() - elem.parentNode.offsetTop) / elem.parentNode.offsetHeight;
    var percentChange = mousePercent - schedule.move; // eslint-disable-next-line no-unused-vars

    var bottomPercent = (elem.offsetTop + elem.offsetHeight) / elem.parentNode.offsetHeight; // eslint-disable-next-line no-unused-vars

    var topPercent = elem.offsetTop / elem.parentNode.offsetHeight;
    var top = oldTop + percentChange;
    var bottom = oldTop + percentChange + height;

    if (top <= 0.0) {
      top = 0.0;
      bottom = height;
    } else if (bottom >= 1.0) {
      bottom = 1.0;
      top = 1.0 - height;
    } //console.log(" ");
    //console.log("top:          " + topPercent);
    //console.log("oldTop:          " + oldTop);
    //console.log("anchor:       " + schedule.anchor);
    //console.log("mousePercent: " + mousePercent);
    //console.log("percentChange:" + percentChange);
    //console.log("height:       " + height);    


    var path = scope;
    if (path.length > 0) path = path + ".";
    schedule.setInfo(path + "start", top);
    schedule.setInfo(path + "finish", bottom); // eslint-disable-next-line no-undef

    if (!hx.ie && schedule.selectedDiv.style.bottom.length > 0) {
      //console.log("first");
      schedule.selectedDiv.style.bottom = ""; //alert("height change from " + schedule.selectedDiv.style.height + " to " + height);

      schedule.selectedDiv.style.height = "" + height * 100.0 + "%";
    }

    schedule.selectedDiv.style.top = "" + top * 100.0 + "%";
    schedule.moving = false; //alert('middle');
  };

  this.onselectedmousemove = function (elem, event, scope) {
    // eslint-disable-next-line no-undef
    if (schedule.selectedDiv == null) {
      return smartTable.endEvent(event);
    }

    if (schedule.move != null) {
      schedule.moveMiddle(elem, event, scope); // eslint-disable-next-line no-undef

      return smartTable.endEvent(event);
    }

    if (schedule.top) {
      schedule.onmousemove(elem, event, scope); // eslint-disable-next-line no-undef

      return smartTable.endEvent(event);
    } //console.log("onselectedmousemove");
    //top movement
    //console.log("t");


    var mousePercent = (schedule.clientY(event) + schedule.getScrollOffset() - elem.parentNode.offsetTop) / elem.parentNode.offsetHeight; //console.log("mousePercent:" + mousePercent);

    var bottomPercent = schedule.anchor;
    var percent = mousePercent;
    var midnight = percent <= 0.0;
    var largest = percent + 0.0208 >= bottomPercent;

    if (midnight) {
      percent = 0.0;
    }

    if (largest) {
      percent = bottomPercent - 0.0208;
    } //setInfo


    var path = scope;
    if (path.length > 0) path = path + ".";
    schedule.setInfo(path + "start", percent);
    schedule.lastDiv.style.top = "" + percent * 100.0 + "%";
    schedule.setBottom(schedule.lastDiv, percent, schedule.anchor); // eslint-disable-next-line no-undef

    return smartTable.endEvent(event);
  };

  this.modified = function () {
    // eslint-disable-next-line no-undef
    if (save != null && this.readonly === false) {
      save.modified();
    }
  };

  this.onselectedmouseup = function (elem, event, scope) {
    schedule.move = null;

    if (schedule.inAction) {
      schedule.inAction = false;
    } else {
      return;
    }

    if (schedule.lastDiv != null) {
      if (schedule.newDiv === true) {
        schedule.onmouseup(elem, event, scope);
        schedule.newDiv = false;
        return;
      }

      schedule.modified();
      schedule.fixDaySelection(elem, event, scope, 2);
      var path = scope;
      if (path.length > 0) path = path + ".";
      var dayElem = schedule.lastDiv.parentNode;

      if (dayElem != null) {
        var id = dayElem.id;
        var formDay = schedule.getElem(path + "day" + id);
        var index = -1;
        var child = dayElem.firstChild;

        while (child !== schedule.lastDiv) {
          child = child.nextSibling;

          if (child.className.indexOf("schedule-HxScheduler-dayEvent") > -1) {
            index++;
          }
        }

        if (formDay == null) {
          return;
        }

        var value = formDay.value;

        if (value == null) {
          return;
        }

        var modify = value.split("|")[index] + "|"; //modify

        var start = schedule.encode(path + "start");
        var finish = schedule.encode(path + "finish");
        var indexOf = value.indexOf(modify);
        modify = start + "," + finish + "," + schedule.getTrueOrFalse(schedule.lastDiv.innerHTML) + "|";
        var newValue = value.substring(0, indexOf) + modify + value.substring(indexOf + modify.length, value.length);
        formDay.value = newValue;
        var div = schedule.lastDiv;
        var amount = (0.0 + div.offsetTop + div.offsetHeight) / (-2.0 + div.parentNode.offsetHeight); //console.log("UP: ");
        //console.log("parent: " + div.parentNode.offsetHeight);
        //console.log("amount: " + amount);
        //console.log("top: " + div.offsetTop);
        //console.log("oldHeight: " + div.offsetHeight);

        var topPercent = div.offsetTop / div.parentNode.offsetHeight;
        schedule.setBottom(div, topPercent, amount); //console.log("height: " + div.offsetHeight);
      }

      schedule.selectedDiv = null;
      schedule.move = null; // eslint-disable-next-line no-undef

      document.body.style.cursor = "default";
    }
  };

  this.onmousedown = function (elem, event, scope) {
    schedule.fixDaySelection(elem, event, scope, 1); // eslint-disable-next-line no-undef

    if (event.button === 2 || smartTable.forceRightClick) {
      return;
    }

    schedule.ondown(elem, event, scope);
  };

  this.clientY = function (event) {
    if (event.touches != null && event.touches.length === 1) {
      return event.touches[0].clientY;
    } else {
      return event.clientY;
    }
  };

  this.ondown = function (elem, event, scope) {
    if (schedule.lastDiv != null) {
      schedule.lastDiv.className = "schedule-HxScheduler-dayEvent";
    }

    var path = scope;

    if (path.length > 0) {
      path = path + ".";
    } //alert(schedule.clientY(event) + " " + schedule.getScrollOffset() + " " + elem.parentNode.offsetTop + " " + elem.parentNode.offsetHeight);


    var percent = (schedule.clientY(event) + schedule.getScrollOffset() - elem.parentNode.offsetTop) / elem.parentNode.offsetHeight;

    if (percent > 0.985) {
      return;
    }

    schedule.anchor = percent;
    schedule.top = true; //reinit

    schedule.moveTop = null;
    schedule.move = null;
    schedule.anchorTop = null;
    schedule.lastDay = null;
    schedule.inAction = false; // eslint-disable-next-line no-undef

    var template = $(path + "template");
    var newDiv = template.cloneNode(true);
    newDiv.id = "";
    newDiv.name = "";
    newDiv.style.display = "";
    newDiv.style.top = "" + percent * 100 + "%";
    newDiv.style.height = "1px";
    newDiv.className = "schedule-HxScheduler-dayEvent schedule-HxScheduler-dayEventSelected";
    elem.parentNode.appendChild(newDiv);
    schedule.selectedDiv = newDiv;
    schedule.lastDiv = newDiv;
    schedule.newDiv = true;
    schedule.setInfo(path + "start", percent);
    schedule.setInfo(path + "finish", percent); //setInfo
    // eslint-disable-next-line no-redeclare

    var path = scope;
    if (path.length > 0) path = path + ".";
    var value = schedule.getElem(path + "value.value");
    value.value = schedule.getTrueOrFalse(schedule.selectedDiv.innerHTML);
  };

  this.createDiv = function (elem, scope, top, height, value) {
    var path = scope;

    if (path.length > 0) {
      path = path + ".";
    } // eslint-disable-next-line no-undef


    var template = $(path + "template");
    var newDiv = template.cloneNode(true);
    newDiv.id = "";
    newDiv.name = "";
    newDiv.style.display = "";
    newDiv.style.top = "" + top + "%";
    newDiv.style.height = "" + height + "%";
    newDiv.className = "schedule-HxScheduler-dayEvent";
    newDiv.innerHTML = schedule.getText(value);
    elem.appendChild(newDiv);
  };

  this.onmousemove = function (elem, event, scope) {
    // eslint-disable-next-line no-undef
    if (schedule.selectedDiv === null) {
      return smartTable.endEvent(event);
    } // eslint-disable-next-line no-undef


    if (hx.ie && navigator.appVersion.charAt(0) < 5 && event.button !== 1) {
      // eslint-disable-next-line no-undef,no-unused-expressions
      schedule.selectedDiv == null;
      schedule.onselectedmouseup(elem, event, scope);
      return;
    }

    if (!schedule.newDiv && !schedule.top) {
      schedule.onselectedmousemove(elem, event, scope); // eslint-disable-next-line no-undef

      return smartTable.endEvent(event);
    }

    if (schedule.inAction && schedule.move != null) {
      schedule.moveMiddle(elem, event, scope); // eslint-disable-next-line no-undef

      return smartTable.endEvent(event);
    }

    var percent = (schedule.clientY(event) + schedule.getScrollOffset() - elem.parentNode.offsetTop) / elem.parentNode.offsetHeight;
    var height = percent - schedule.anchor;
    var midnight = percent >= 1.0;
    var smallest = height <= 0.0208;

    if (midnight) {
      var topPercent = schedule.selectedDiv.offsetTop / schedule.selectedDiv.parentNode.offsetHeight;
      schedule.setBottom(schedule.selectedDiv, topPercent, 1.0);
      percent = 1.0;
    }

    if (smallest) {
      percent = schedule.anchor + 0.0208;
    } //setInfo


    var path = scope;
    if (path.length > 0) path = path + ".";
    height = percent - schedule.anchor;
    schedule.setInfo(path + "finish", percent);

    if (!midnight) {
      schedule.selectedDiv.style.height = "" + height * 100.0 + "%";
    } // eslint-disable-next-line no-undef


    return smartTable.endEvent(event);
  };

  this.onmouseup = function (elem, event, scope) {
    if (schedule.selectedDiv == null) {
      return;
    }

    if (schedule.newDiv === false) {
      return;
    }

    var path = scope;
    if (path.length > 0) path = path + ".";
    var dayElem = schedule.lastDiv.parentNode;

    if (dayElem != null) {
      var id = dayElem.id;
      var formDay = schedule.getElem(path + "day" + id);
      var start = schedule.encode(path + "start");
      var finish = schedule.encode(path + "finish");

      if (start === finish && start !== "00:00:00.000") {
        schedule.selectedDiv.parentNode.removeChild(schedule.selectedDiv);
        schedule.selectedDiv = null;
        schedule.lastDiv = null;
        schedule.move = null;
        schedule.newDiv = false;
        return;
      }

      formDay.value += start + "," + finish + "," + schedule.getTrueOrFalse(schedule.lastDiv.innerHTML) + "|";
      var div = schedule.lastDiv;
      var amount = (div.offsetTop + div.offsetHeight) / div.parentNode.offsetHeight;
      var topPercent = schedule.lastDiv.offsetTop / schedule.lastDiv.parentNode.offsetHeight;
      schedule.setBottom(schedule.lastDiv, topPercent, amount);
      schedule.fixDaySelection(elem, event, scope, 2);
    }

    schedule.modified();
    schedule.selectedDiv = null;
    schedule.move = null;
    schedule.newDiv = false;
  }; //"hh:mm:ss.mmm".


  this.encode = function (path) {
    var hour = parseInt(schedule.getElem(path + ".hour").value);
    var min = parseInt(schedule.getElem(path + ".min").value);
    var ampm = parseInt(schedule.getElem(path + ".ampm").value);
    var encoded = "";

    if (ampm === 1 && hour !== 12) {
      hour += 12;
    } else if (ampm === 0 && hour === 12) {
      hour = 0;
    }

    if (hour < 10) encoded += '0';
    encoded += hour;
    encoded += ':';
    if (min < 10) encoded += '0';
    encoded += min;
    encoded += ':00.000';
    return encoded;
  }; //"hh:mm:ss.mmm".


  this.decode = function (value, path) {
    var split = value.split(':');
    var hour = schedule.parseIntFix(split[0]);
    var minute = schedule.parseIntFix(split[1]);
    var ampm = 0;

    if (hour > 11) {
      ampm = 1;
      hour = hour - 12;
    }

    if (hour === 0) {
      hour = 12;
    }

    var hourElem = schedule.getElem(path + ".hour");
    var minElem = schedule.getElem(path + ".min");
    var ampmElem = schedule.getElem(path + ".ampm");
    hourElem.value = hour;
    minElem.value = minute;
    ampmElem.value = ampm; //    if(!hx.ie)
    //    {
    //      smartTable.fireOnChange(hourElem);
    //      smartTable.fireOnChange(minElem);
    //      smartTable.fireOnChange(ampmElem);
    //    }
  };

  this.parseIntFix = function (val) {
    if (val.charAt(0) === '0') {
      val = val.substring(1, val.length);
    }

    return parseInt(val);
  }; //"return (percent of day)/100".


  this.getTime = function (path) {
    var hour = parseInt(schedule.getElem(path + ".hour").value);
    var min = parseInt(schedule.getElem(path + ".min").value);
    var ampm = parseInt(schedule.getElem(path + ".ampm").value);

    if (ampm === 1 && hour !== 12) {
      hour += 12;
    } else if (ampm === 0 && hour === 12) {
      hour = 0;
    }

    var percentOfDay = (0.0 + hour + min / 60.0) / 24.0; //console.log("percentOfDay: " + percentOfDay);

    return percentOfDay;
  };

  this.setInfo = function (path, percent) {
    if (percent > 0.99) {
      percent = 1.0;
    }

    var time = percent * 24.0;
    var hour = Math.floor(time);
    var min = Math.floor((time - hour) * 60.0);
    var ampm = 0;

    if (min >= 45.0) {
      hour += 1;
      min = 0;
    }

    var top = min > 15.0 && min < 45.0;

    if (top) {
      min = 30;
    } else {
      min = 0;
    }

    if (hour > 11) {
      ampm = 1;
    }

    if (hour === 24 && ampm === 1 && min === 0) {
      hour = 12;
      ampm = 0;
    }

    hour = hour % 12;

    if (hour === 0) {
      hour = 12;
    }

    schedule.setTimeInfo(path, hour, min, ampm);
  };

  this.setTimeInfo = function (path, hour, min, ampm) {
    var hourElem = schedule.getElem(path + ".hour");
    hourElem.value = hour;
    var minElem = schedule.getElem(path + ".min");
    minElem.value = min;
    var ampmElem = schedule.getElem(path + ".ampm");
    ampmElem.value = ampm; //    if(!hx.ie)
    //    {
    //      smartTable.fireOnChange(hourElem);
    //      smartTable.fireOnChange(minElem);
    //      smartTable.fireOnChange(ampmElem);
    //    }
  };

  this.getElem = function (listName) {
    // eslint-disable-next-line no-undef
    var colList = document.getElementById(listName);

    if (colList == null) {
      // eslint-disable-next-line no-undef
      colList = document.getElementsByName(listName)[0];
    }

    return colList;
  };

  this.setExact = function (scope) {
    if (schedule.lastDiv != null) {
      var path = scope;
      if (path.length > 0) path = path + ".";
      var dayElem = schedule.lastDiv.parentNode;

      if (dayElem != null) {
        var id = dayElem.id;
        var formDay = schedule.getElem(path + "day" + id);
        var index = -1;
        var child = dayElem.firstChild;

        while (child !== schedule.lastDiv) {
          child = child.nextSibling;

          if (child.className.indexOf("schedule-HxScheduler-dayEvent") > -1) {
            index++;
          }
        }

        var value = formDay.value;
        var modify = value.split("|")[index] + "|";
        var start = modify.split(",")[0];
        var finish = modify.split(",")[1];

        try {
          schedule.decode(start, path + "start");
          schedule.decode(finish, path + "finish");
        } catch (err) {//ignore IE error
          //alert(index);
          //alert(value);
        }
      }
    }
  };

  this.valueChange = function (e, sourceId, targetId, scope) {
    var elem = schedule.getElem(sourceId);

    if (schedule.lastDiv != null) {
      schedule.lastDiv.innerHTML = schedule.getText(elem.value);
      var path = scope;
      if (path.length > 0) path = path + ".";
      var dayElem = schedule.lastDiv.parentNode;

      if (dayElem != null) {
        var id = dayElem.id;
        var formDay = schedule.getElem(path + "day" + id);
        var index = -1;
        var child = dayElem.firstChild;

        while (child !== schedule.lastDiv) {
          child = child.nextSibling;

          if (child.className.indexOf("schedule-HxScheduler-dayEvent") > -1) {
            index++;
          }
        }

        var value = formDay.value;
        var modify = value.split("|")[index] + "|"; //modify

        var start = schedule.encode(path + "start");
        var finish = schedule.encode(path + "finish");
        var indexOf = value.indexOf(modify);
        var newModify = start + "," + finish + "," + schedule.getTrueOrFalse(schedule.lastDiv.innerHTML) + "|";
        var newValue = value.substring(0, indexOf) + newModify + value.substring(indexOf + modify.length, value.length);
        formDay.value = newValue;
      }
    }
  };

  this.timeChange = function (e, sourceId, targetId, scope) {
    if (schedule.newDiv === true) {
      return;
    } //console.log("timeChange:");
    // eslint-disable-next-line no-unused-vars


    var elem = schedule.getElem(sourceId);

    if (schedule.lastDiv != null) {
      var path = scope;
      if (path.length > 0) path = path + ".";
      var dayElem = schedule.lastDiv.parentNode;

      if (dayElem != null) {
        var id = dayElem.id;
        var formDay = schedule.getElem(path + "day" + id);
        var index = -1;
        var child = dayElem.firstChild;

        while (child !== schedule.lastDiv) {
          child = child.nextSibling;

          if (child.className.indexOf("schedule-HxScheduler-dayEvent") > -1) {
            index++;
          }
        }

        var value = formDay.value;
        var modify = value.split("|")[index] + "|"; //modify

        var start = schedule.encode(path + "start");
        var finish = schedule.encode(path + "finish");
        var indexOf = value.indexOf(modify);
        modify = start + "," + finish + "," + schedule.getTrueOrFalse(schedule.lastDiv.innerHTML) + "|";
        var newValue = value.substring(0, indexOf) + modify + value.substring(indexOf + modify.length, value.length);
        formDay.value = newValue; //correct height or bottom

        var time = schedule.getTime(path + targetId);

        if (targetId === "start") {
          schedule.lastDiv.style.top = "" + time * 100.0 + "%";
          var bottom = schedule.getTime(path + "finish");
          var errorTest = schedule.setBottom(schedule.lastDiv, time, bottom);

          if (errorTest === -1) {
            // eslint-disable-next-line no-undef
            alert("The start time must be before the finish time.");
            schedule.deleteSelected(scope);
          }
        } else {
          if (time === 0.0) {
            time = 1.0;
          } else if (time === 1.0) {
            time = 0.5;
          }

          var topPercent = schedule.lastDiv.offsetTop / schedule.lastDiv.parentNode.offsetHeight; // eslint-disable-next-line no-redeclare

          var errorTest = schedule.setBottom(schedule.lastDiv, topPercent, time);

          if (errorTest === -1) {
            // eslint-disable-next-line no-undef
            alert("The start time must be before the finish time.");
            schedule.deleteSelected(scope);
          }
        } //console.log("time: " + time);

      }
    }
  };

  this.deleteSelected = function (scope) {
    if (schedule.lastDiv != null) {
      schedule.modified();
      var path = scope;
      if (path.length > 0) path = path + ".";
      var dayElem = schedule.lastDiv.parentNode;

      if (dayElem != null) {
        var id = dayElem.id;
        var formDay = schedule.getElem(path + "day" + id); //alert(formDay.value);

        var index = -1;
        var child = dayElem.firstChild;

        while (child !== schedule.lastDiv) {
          child = child.nextSibling;

          if (child.className.indexOf("schedule-HxScheduler-dayEvent") > -1) {
            index++;
          }
        }

        var value = formDay.value;
        var remove = value.split("|")[index] + "|";
        var indexOf = value.indexOf(remove);
        var newValue = value.substring(0, indexOf) + value.substring(indexOf + remove.length, value.length);
        formDay.value = newValue; //remove

        schedule.lastDiv.parentNode.removeChild(schedule.lastDiv);
      }

      schedule.lastDiv = null;
    }
  };

  this.daymousedown = function (elem, event, scope) {
    //right click
    // eslint-disable-next-line no-undef
    if (event.button === 2 || smartTable.forceRightClick) {
      schedule.selectedDiv = null; // eslint-disable-next-line no-undef

      var commands = smartTable.fixCommands(smartTable.elemFromEvent(event), 1); // eslint-disable-next-line no-undef

      smartTable.showRightClickMenu(event, commands);
      schedule.lastDay = elem; // eslint-disable-next-line no-undef

      return smartTable.endEvent(event);
    }
  };

  this.clearDay = function (elem, event, scope) {
    schedule.modified();
    schedule.clearDayNoModify(elem, event, scope);
  };

  this.clearDayNoModify = function (elem, event, scope) {
    var path = scope;
    if (path.length > 0) path = path + ".";
    var dayElem = elem;

    if (dayElem == null) {
      dayElem = schedule.lastDay;
    }

    if (dayElem == null) {
      dayElem = schedule.getElem(schedule.commandDay);
    }

    var id = dayElem.id;
    var formDay = schedule.getElem(path + "day" + id);

    if (formDay != null) {
      var childNodes = dayElem.childNodes;

      for (var i = childNodes.length - 1; i >= 0; i--) {
        if (childNodes[i].className.indexOf("schedule-HxScheduler-dayEvent") > -1) {
          dayElem.removeChild(childNodes[i]);
        }
      }

      formDay.value = "";
    }
  };

  this.clearWeek = function (elem, event, scope) {
    for (var i = 0; i < 7; i++) {
      var currentDay = schedule.getElem(i);
      schedule.lastDay = currentDay;
      schedule.clearDay(schedule.lastDay, event, scope);
    }
  };

  this.applyMF = function (elem, event, scope) {
    schedule.modified();
    var path = scope;
    if (path.length > 0) path = path + ".";
    var dayElem = schedule.lastDay;

    if (dayElem == null) {
      dayElem = schedule.getElem(schedule.commandDay);
    }

    if (dayElem != null) {
      var id = dayElem.id;
      var intId = parseInt(id);
      var formDay = schedule.getElem(path + "day" + id);
      var events = schedule.copy(dayElem, event, scope);

      for (var i = 1; i < 6; i++) {
        if (intId === i) {
          continue;
        }

        var currentDay = schedule.getElem(i);
        var currentFormDay = schedule.getElem(path + "day" + i);
        schedule.lastDay = currentDay;
        schedule.clearDay(schedule.lastDay, event, scope); // eslint-disable-next-line no-unmodified-loop-condition

        for (var j = 0; events != null && j < events.length; j++) {
          currentDay.appendChild(events[j].cloneNode(true));
        }

        currentFormDay.value = formDay.value;
      }
    }
  };

  this.copyDay = function (elem, event, scope) {
    var path = scope;
    if (path.length > 0) path = path + ".";
    var dayElem = schedule.lastDay;

    if (dayElem == null) {
      dayElem = schedule.getElem(schedule.commandDay);
    }

    if (dayElem != null) {
      var id = dayElem.id;
      schedule.copiedDay = schedule.copy(dayElem, event, scope);
      schedule.copiedDayFormValue = schedule.getElem(path + "day" + id).value;
    }
  };

  this.pasteDay = function (elem, event, scope) {
    schedule.modified();
    var path = scope;
    if (path.length > 0) path = path + ".";

    if (schedule.hasPaste()) {
      var id = schedule.commandDay;
      var dayElem = schedule.getElem(id);
      var formDay = schedule.getElem(path + "day" + id);
      var events = schedule.copiedDay;
      schedule.clearDay(dayElem, event, scope);

      for (var i = 0; i < events.length; i++) {
        dayElem.appendChild(events[i].cloneNode(true));
      }

      formDay.value = schedule.copiedDayFormValue;
    }
  };

  this.copy = function (elem, event, scope) {
    var path = scope;
    if (path.length > 0) path = path + ".";
    var dayElem = elem; //if(dayElem == null)
    //      return null;

    var id = dayElem.id; // eslint-disable-next-line no-unused-vars

    var intId = parseInt(id); // eslint-disable-next-line no-unused-vars

    var formDay = schedule.getElem(path + "day" + id);
    var childNodes = dayElem.childNodes;
    var events = [0];
    var eventsAmount = 0;

    for (var i = 0; i < childNodes.length; i++) {
      if (childNodes[i].className.indexOf("schedule-HxScheduler-dayEvent") > -1) {
        var node = childNodes[i].cloneNode(true);
        node.className = "schedule-HxScheduler-dayEvent";
        events[eventsAmount] = node;
        eventsAmount++;
      }
    }

    if (eventsAmount === 0) {
      return null;
    }

    return events;
  };

  this.allDay = function (elem, event, scope) {
    if (schedule.lastDiv != null) {
      schedule.lastDiv.className = "schedule-HxScheduler-dayEvent";
    }

    schedule.clearDay(schedule.lastDay, event, scope);
    var path = scope;
    if (path.length > 0) path = path + ".";
    var percent = 0.0;
    var dayElem = schedule.lastDay;

    if (dayElem == null) {
      dayElem = schedule.getElem(schedule.commandDay);
    }

    if (dayElem == null) {
      return null;
    }

    var id = dayElem.id;
    var formDay = schedule.getElem(path + "day" + id); // eslint-disable-next-line no-undef

    var template = $(path + "template");
    var newDiv = template.cloneNode(true);
    newDiv.id = "";
    newDiv.name = "";
    newDiv.style.display = "";
    newDiv.style.top = "" + percent * 100 + "%";
    newDiv.style.height = "100%";
    newDiv.className = "schedule-HxScheduler-dayEvent schedule-HxScheduler-dayEventSelected"; //newDiv.innerHTML="true";

    dayElem.appendChild(newDiv);
    schedule.selectedDiv = null;
    schedule.lastDiv = newDiv;
    schedule.setInfo(path + "start", percent);
    schedule.setInfo(path + "finish", 1.0); //setInfo

    var value = schedule.getElem(path + "value.value");
    value.value = schedule.getTrueOrFalse(schedule.lastDiv.innerHTML); //modify

    var start = schedule.encode(path + "start");
    var finish = schedule.encode(path + "finish");
    var modify = start + "," + finish + "," + schedule.getTrueOrFalse(schedule.lastDiv.innerHTML) + "|";
    formDay.value = modify;
  };

  this.setBottom = function (elem, topPercent, bottomPercent) {
    if (topPercent >= bottomPercent) {
      return -1; //error4 
    }

    var offset = 0.0;

    if (schedule.newDiv) {
      offset = 0.25;
    } // eslint-disable-next-line no-undef


    if (hx.ie) {
      var height = bottomPercent * 100.0 - topPercent * 100.0 + offset; //double click for ie

      if (height - schedule.lastHeight > 0.37878 && height - schedule.lastHeight < 0.37879) {} else if (height - schedule.lastHeight > 0.757575 && height - schedule.lastHeight < 0.757576) {} else {
        if (topPercent * 100.0 + height > 99.99) {
          elem.style.height = 100 - topPercent * 100.00 + "%";
        } else {
          elem.style.height = "" + height + "%";
        }

        schedule.lastHeight = height;
      }
    } else {
      schedule.lastDiv.style.height = "";
      elem.style.bottom = "" + ((1.000 - bottomPercent) * 100.0 - offset) + "%";
    }

    return 0; //return success    
  };

  this.lastHeight = 0.0;

  this.ondayselectedmousemove = function (elem, event, scope) {
    if (schedule.selectedDiv == null) {
      return false;
    }

    if (schedule.newDiv) {
      schedule.onmousemove(schedule.selectedDiv, event, scope);
    } else {
      schedule.onselectedmousemove(schedule.selectedDiv, event, scope);
    }
  };

  this.ondayselectedmouseup = function (elem, event, scope) {
    if (schedule.selectedDiv == null) {
      return false;
    }

    if (schedule.newDiv === true) {
      schedule.onmouseup(schedule.selectedDiv, event, scope);
    } else {
      schedule.onselectedmouseup(schedule.selectedDiv, event, scope);
    }
  };

  this.ondayselectedmousedown = function (elem, event, scope) {
    schedule.fixDaySelection(elem, event, scope, 1);

    if (schedule.lastDiv != null) {
      if (parseInt(schedule.lastDiv.parentNode.id) !== schedule.commandDay && schedule.newDiv === false) {
        schedule.selectedDiv = null;
        schedule.newDiv = false;
        schedule.lastDiv.className = "schedule-HxScheduler-dayEvent";
        schedule.lastDiv = null;
      }
    } // eslint-disable-next-line no-undef


    return smartTable.endEvent(event);
  };

  this.setTrueFalse = function (selectElemPath) {
    // eslint-disable-next-line no-undef
    var elem = $$(selectElemPath);
    schedule.falseText = elem.options[0].innerHTML;
    schedule.trueText = elem.options[1].innerHTML;
  };

  this.getTrueOrFalse = function (text) {
    if (text === schedule.trueText) {
      return "true";
    } else {
      return "false";
    }
  };

  this.getText = function (text) {
    if (text === "true") {
      return schedule.trueText;
    } else {
      return schedule.falseText;
    }
  };
  /**
   * scrolling offset
   */


  this.getScrollOffset = function () {
    //alert(document.body.scrollTop + " " + window.pageYOffset);
    // eslint-disable-next-line no-undef
    if (hx.ie && navigator.appVersion.charAt(0) < 5) {
      return document.documentElement.scrollTop;
    } else {
      return window.pageYOffset;
    }
  };

  this.hasPaste = function () {
    return schedule.copiedDay != null;
  };

  this.fixDaySelection = function (elem, event, scope, selectionType) {
    // eslint-disable-next-line no-undef
    smartTable.fixCommands(smartTable.elemFromEvent(event), selectionType);
    var dayBoxNode = elem;

    while (dayBoxNode != null && dayBoxNode.className != null && dayBoxNode.className.indexOf('Box') === -1) {
      dayBoxNode = dayBoxNode.parentNode;
    }

    if (dayBoxNode == null || dayBoxNode.className == null) {
      return;
    } ////fix day slider
    //var dayBoxNode = elem.parentNode.parentNode;


    if (dayBoxNode.getAttribute('day') != null) {
      schedule.commandDay = parseInt(dayBoxNode.getAttribute('day'));
    }

    var dayBoxNodeTd = dayBoxNode.parentNode;
    dayBoxNode.className = "schedule-HxScheduler-dayBox schedule-HxScheduler-dayBoxSelected"; // eslint-disable-next-line no-redeclare

    var elem = dayBoxNodeTd.previousSibling;

    while (elem != null) {
      if (elem.firstChild != null) {
        elem.firstChild.className = "schedule-HxScheduler-dayBox";
      }

      elem = elem.previousSibling;
    }

    elem = dayBoxNodeTd.nextSibling;

    while (elem != null) {
      if (elem.firstChild != null) {
        elem.firstChild.className = "schedule-HxScheduler-dayBox";
      }

      elem = elem.nextSibling;
    }
  };
}
