/*
 * Copyright 2005 Tridium, Inc. All Rights Reserved.
 */

/**
 * entsecHx
 *
 * @author    JJ Frankovich
 * @creation  19 Mar 09
 * @version   $Revision$ $Date$
 * @since     Baja 3.4
 */
var entsecHx = new EntsecHx();

function EntsecHx() {
  'use strict';

  this.loginLex = "Login";

  this.init = function () {
    try {
      // eslint-disable-next-line no-undef
      hx.errorInvokeCode = "entsecHx.errorInvokeCode();"; // eslint-disable-next-line no-undef

      if (window.name.indexOf("fullscreen") === 0) {
        // eslint-disable-next-line no-undef
        $$('entsec-header').style.display = "none"; // eslint-disable-next-line no-undef

        $$('entsec-navbar').style.display = "none";
      }
    } catch (err) {}
  };

  this.getProfileHeight = function () {
    // eslint-disable-next-line no-undef
    if (window.name.indexOf("fullscreen") === 0) {
      return 0;
    }

    try {
      // eslint-disable-next-line no-undef
      return $$('entsec-header').offsetHeight + $$('entsec-navbar').offsetHeight;
    } catch (err) {
      return 0;
    }
  };

  this.timeout = function () {
    try {
      // eslint-disable-next-line no-undef
      $('profile-stationName').className = 'entsec-header-stationName entsec-header-disconnected';
    } catch (err) {}
  };

  this.reconnect = function () {
    try {
      // eslint-disable-next-line no-undef
      $('profile-stationName').className = 'entsec-header-stationName';
    } catch (err) {}
  };

  this.errorInvokeCode = function () {
    try {
      // eslint-disable-next-line no-undef
      if (hx.err_LostConnection === hx.lastExceptionMessage) {
        entsecHx.timeout(); // eslint-disable-next-line no-implied-eval, no-undef

        setTimeout("hx.poller()", hx.pollTimeout); //keep trying in case there is a restart

        return true; // eslint-disable-next-line no-undef
      } else if (hx.lastExceptionMessage != null && hx.lastExceptionMessage.indexOf('<h1>404:') > -1) {
        // eslint-disable-current-line no-undef
        entsecHx.timeout();
        return true; // eslint-disable-next-line no-undef
      } else if (hx.lastExceptionMessage != null && hx.lastExceptionMessage.indexOf('<h1>405:') > -1) {
        entsecHx.timeout();
        return true; // eslint-disable-next-line no-undef
      } else if (hx.ie && hx.lastExceptionMessage != null && hx.lastExceptionMessage.indexOf('Error: Unspecified error.') > -1) {
        // eslint-disable-next-line no-undef
        if (hx.lastExceptionDetails != null && hx.lastExceptionDetails.indexOf("window.location=") > -1) {
          entsecHx.timeout();
          return true;
        } // eslint-disable-next-line no-undef

      } else if (hx.ie && hx.lastExceptionMessage != null && hx.lastExceptionMessage.indexOf('SyntaxError: Unterminated string constant') > -1) {
        entsecHx.timeout();
        return true;
      } //just reload
      // eslint-disable-next-line no-undef


      var stack = hx.lastExceptionDetails;

      if (stack != null && stack.indexOf("&lt;title&gt;" + entsecHx.loginLex + "&lt;/title&gt;") > -1) {
        // eslint-disable-next-line no-undef
        window.onbeforeunload = null; // eslint-disable-next-line no-undef

        window.location.reload();
        return true;
      } else {
        return false;
      }
    } catch (err) {//alert("caught:" + err);
    }
  };

  this.sameStation = function (scope) {
    // eslint-disable-next-line no-undef
    var selectionCountElem = $$(scope + "selectionCount");
    var selectionCount = parseInt(selectionCountElem.value);

    if (selectionCount === 1) {
      return true;
    } else if (selectionCount === 0) {
      return false;
    } // eslint-disable-next-line no-undef


    var selectList = $$(scope + "selectionList").value;
    var split = selectList.split("|");
    var stationName = "";

    for (var i = 0; i < split.length; i++) {
      var e = split[i];
      var s = e.split(";")[0];

      if (s.length > 0) {
        if (stationName.length === 0) {
          stationName = s;
        } else if (stationName !== s) {
          return false;
        }
      }
    }

    return true;
  };

  this.hideLessThanElem = function (e, sourceId, targetId, index) {
    // eslint-disable-next-line no-undef,no-redeclare
    var e = $$(sourceId);

    if (e.value === "") {
      // eslint-disable-next-line no-undef
      setTimeout(function () {
        this.smartTable.hideLessThanElem(e, sourceId, targetId, index);
      }, 500);
    } else {
      this.smartTable.hideLessThanElem(e, sourceId, targetId, index);
    }
  };

  this.hideElem = function (e, sourceId, targetId, index) {
    // eslint-disable-next-line no-undef,no-redeclare
    var e = $$(sourceId);

    if (e.value === "") {
      // eslint-disable-next-line no-undef
      setTimeout(function () {
        this.smartTable.hideElem(e, sourceId, targetId, index);
      }, 500);
    } else {
      this.smartTable.hideElem(e, sourceId, targetId, index);
    }
  };

  this.showElem = function (e, sourceId, targetId, index) {
    // eslint-disable-next-line no-undef,no-redeclare
    var e = $$(sourceId);

    if (e.value === "") {
      // eslint-disable-next-line no-undef
      setTimeout(function () {
        this.smartTable.showElem(e, sourceId, targetId, index);
      }, 500);
    } else {
      this.smartTable.showElem(e, sourceId, targetId, index);
    }
  };

  this.logout = function (token, message) {
    require(['dialogs'], function (dialogs) {
      return dialogs.showYesNo(message).yes(function () {
        // eslint-disable-next-line no-undef
        window.location.assign('/logout' + token);
      }).promise();
    });
  };
}
