/**
 * Copyright 2021 Tridium, Inc. All Rights Reserved.
 * @author Cody Short
 */

define(['baja!', 'lex!baja'], function (baja, lexs) {
  'use strict';

  var DAYS_OF_WEEK = ["sunday", "monday", "tuesday", "wednesday", "thursday", "friday", "saturday"];
  function getFirstDayOfWeekNumber() {
    var dayOfWeekText = bajaLex.getSafe('weekday.firstDayOfWeek'),
      dayOfWeekNumber = DAYS_OF_WEEK.indexOf(dayOfWeekText);
    return dayOfWeekNumber !== -1 ? dayOfWeekNumber : 0;
  }
  var bajaLex = lexs[0],
    MONTHS = ['january', 'february', 'march', 'april', 'may', 'june', 'july', 'august', 'september', 'october', 'november', 'december'],
    WEEKDAYS = ['sunday', 'monday', 'tuesday', 'wednesday', 'thursday', 'friday', 'saturday'];
  function get(k) {
    return bajaLex.get({
      key: k,
      def: k
    });
  }
  function getShort(k) {
    return bajaLex.get({
      key: k + '.short',
      def: k.substr(0, 3)
    });
  }
  function getMin(k) {
    return bajaLex.get({
      key: k + '.short',
      def: k
    }).substr(0, 2);
  }

  /**
   * API Status: **Private**
   * @exports nmodule/js/rc/shims/moment/applyLocale
   */

  /**
   * Apply a limited subset of current lexicon info, using the user's current
   * language, into the Moment locale. Will also switch Moment into the current
   * locale, so locale-agnostic calls to `moment#format()` will use this locale
   * as well.
   *
   * @param {Function} moment Moment itself
   */

  return function (moment) {
    var lang = baja.getLanguage();
    moment.updateLocale(lang, {
      months: MONTHS.map(get),
      monthsShort: MONTHS.map(getShort),
      weekdays: WEEKDAYS.map(get),
      weekdaysShort: WEEKDAYS.map(getShort),
      weekdaysMin: WEEKDAYS.map(getMin),
      week: {
        dow: getFirstDayOfWeekNumber()
      }
    });
    moment.locale(lang);
  };
});
