/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/js/rc/log/handlers/rpcHandler
 */
define(['nmodule/js/rc/asyncUtils/promiseMux', 'nmodule/js/rc/rpc/rpc'], function (promiseMux, rpc) {
  'use strict';

  var MAX_BATCH_SIZE = 20,
    RPC_DEBOUNCE_DELAY = 20;

  /**
   * @returns {module:nmodule/js/rc/rpc/rpc~RpcParams}
   */
  function toRpcParams(arg) {
    return {
      typeSpec: 'web:LogRpc',
      methodName: 'log',
      args: [arg.name, String(arg.level), arg.msg]
    };
  }
  var muxedLogRpc = promiseMux({
    coalesce: false,
    delay: RPC_DEBOUNCE_DELAY,
    exec: function exec(logArgs) {
      return rpc.rpc(logArgs.map(toRpcParams));
    },
    onQueue: function onQueue(arg, queue, sendEmUp) {
      if (queue.length >= MAX_BATCH_SIZE) {
        return sendEmUp();
      }
    }
  });

  /**
   * Handler to publish log messages up to the server via RPC.
   * @type {module:nmodule/js/rc/log/Log~Handler}
   * @alias module:nmodule/js/rc/log/handlers/rpcHandler
   */
  return {
    publish: function publish(name, level, msg) {
      return muxedLogRpc({
        name: name,
        level: level,
        msg: msg
      });
    }
  };
});
