/**
 * jQuery contextMenu v2.4.4 - Plugin for simple contextMenu handling
 *
 * Version: v2.4.4
 *
 * Authors: Björn Brala (SWIS.nl), Rodney Rehm, Addy Osmani (patches for FF)
 * Web: http://swisnl.github.io/jQuery-contextMenu/
 *
 * Copyright (c) 2011-2017 SWIS BV and contributors
 *
 * Licensed under
 *   MIT License http://www.opensource.org/licenses/mit-license
 *
 * Date: 2017-04-03T15:28:34.533Z
 */
(function(factory){if(typeof define==="function"&&define.amd){define(["jquery"],factory)}else if(typeof exports==="object"){factory(require("jquery"))}else{factory(jQuery)}})(function($){"use strict";$.support.htmlMenuitem="HTMLMenuItemElement"in window;$.support.htmlCommand="HTMLCommandElement"in window;$.support.eventSelectstart="onselectstart"in document.documentElement;if(!$.ui||!$.widget){$.cleanData=function(orig){return function(elems){var events,elem,i;for(i=0;elems[i]!=null;i++){elem=elems[i];try{events=$._data(elem,"events");if(events&&events.remove){$(elem).triggerHandler("remove")}}catch(e){}}orig(elems)}}($.cleanData)}var $currentTrigger=null,initialized=false,$win=$(window),counter=0,namespaces={},menus={},types={},defaults={selector:null,appendTo:null,trigger:"right",autoHide:false,delay:200,reposition:true,selectableSubMenu:false,classNames:{hover:"context-menu-hover",disabled:"context-menu-disabled",visible:"context-menu-visible",notSelectable:"context-menu-not-selectable",icon:"context-menu-icon",iconEdit:"context-menu-icon-edit",iconCut:"context-menu-icon-cut",iconCopy:"context-menu-icon-copy",iconPaste:"context-menu-icon-paste",iconDelete:"context-menu-icon-delete",iconAdd:"context-menu-icon-add",iconQuit:"context-menu-icon-quit",iconLoadingClass:"context-menu-icon-loading"},determinePosition:function($menu){if($.ui&&$.ui.position){$menu.css("display","block").position({my:"center top",at:"center bottom",of:this,offset:"0 5",collision:"fit"}).css("display","none")}else{var offset=this.offset();offset.top+=this.outerHeight();offset.left+=this.outerWidth()/2-$menu.outerWidth()/2;$menu.css(offset)}},position:function(opt,x,y){var offset;if(!x&&!y){opt.determinePosition.call(this,opt.$menu);return}else if(x==="maintain"&&y==="maintain"){offset=opt.$menu.position()}else{var offsetParentOffset=opt.$menu.offsetParent().offset();offset={top:y-offsetParentOffset.top,left:x-offsetParentOffset.left}}var bottom=$win.scrollTop()+$win.height(),right=$win.scrollLeft()+$win.width(),height=opt.$menu.outerHeight(),width=opt.$menu.outerWidth();if(offset.top+height>bottom){offset.top-=height}if(offset.top<0){offset.top=0}if(offset.left+width>right){offset.left-=width}if(offset.left<0){offset.left=0}opt.$menu.css(offset)},positionSubmenu:function($menu){if(typeof $menu==="undefined"){return}if($.ui&&$.ui.position){$menu.css("display","block").position({my:"left top-5",at:"right top",of:this,collision:"flipfit fit"}).css("display","")}else{var offset={top:-9,left:this.outerWidth()-5};$menu.css(offset)}},zIndex:1,animation:{duration:50,show:"slideDown",hide:"slideUp"},events:{show:$.noop,hide:$.noop},callback:null,items:{}},hoveract={timer:null,pageX:null,pageY:null},zindex=function($t){var zin=0,$tt=$t;while(true){zin=Math.max(zin,parseInt($tt.css("z-index"),10)||0);$tt=$tt.parent();if(!$tt||!$tt.length||"html body".indexOf($tt.prop("nodeName").toLowerCase())>-1){break}}return zin},handle={abortevent:function(e){e.preventDefault();e.stopImmediatePropagation()},contextmenu:function(e){var $this=$(this);if(e.data.trigger==="right"){e.preventDefault();e.stopImmediatePropagation()}if(e.data.trigger!=="right"&&e.data.trigger!=="demand"&&e.originalEvent){return}if(typeof e.mouseButton!=="undefined"&&e.data){if(!(e.data.trigger==="left"&&e.mouseButton===0)&&!(e.data.trigger==="right"&&e.mouseButton===2)){return}}if($this.hasClass("context-menu-active")){return}if(!$this.hasClass("context-menu-disabled")){$currentTrigger=$this;if(e.data.build){var built=e.data.build($currentTrigger,e);if(built===false){return}e.data=$.extend(true,{},defaults,e.data,built||{});if(!e.data.items||$.isEmptyObject(e.data.items)){if(window.console){(console.error||console.log).call(console,"No items specified to show in contextMenu")}throw new Error("No Items specified")}e.data.$trigger=$currentTrigger;op.create(e.data)}var showMenu=false;for(var item in e.data.items){if(e.data.items.hasOwnProperty(item)){var visible;if($.isFunction(e.data.items[item].visible)){visible=e.data.items[item].visible.call($(e.currentTarget),item,e.data)}else if(typeof e.data.items[item]!=="undefined"&&e.data.items[item].visible){visible=e.data.items[item].visible===true}else{visible=true}if(visible){showMenu=true}}}if(showMenu){op.show.call($this,e.data,e.pageX,e.pageY)}}},click:function(e){e.preventDefault();e.stopImmediatePropagation();$(this).trigger($.Event("contextmenu",{data:e.data,pageX:e.pageX,pageY:e.pageY}))},mousedown:function(e){var $this=$(this);if($currentTrigger&&$currentTrigger.length&&!$currentTrigger.is($this)){$currentTrigger.data("contextMenu").$menu.trigger("contextmenu:hide")}if(e.button===2){$currentTrigger=$this.data("contextMenuActive",true)}},mouseup:function(e){var $this=$(this);if($this.data("contextMenuActive")&&$currentTrigger&&$currentTrigger.length&&$currentTrigger.is($this)&&!$this.hasClass("context-menu-disabled")){e.preventDefault();e.stopImmediatePropagation();$currentTrigger=$this;$this.trigger($.Event("contextmenu",{data:e.data,pageX:e.pageX,pageY:e.pageY}))}$this.removeData("contextMenuActive")},mouseenter:function(e){var $this=$(this),$related=$(e.relatedTarget),$document=$(document);if($related.is(".context-menu-list")||$related.closest(".context-menu-list").length){return}if($currentTrigger&&$currentTrigger.length){return}hoveract.pageX=e.pageX;hoveract.pageY=e.pageY;hoveract.data=e.data;$document.on("mousemove.contextMenuShow",handle.mousemove);hoveract.timer=setTimeout(function(){hoveract.timer=null;$document.off("mousemove.contextMenuShow");$currentTrigger=$this;$this.trigger($.Event("contextmenu",{data:hoveract.data,pageX:hoveract.pageX,pageY:hoveract.pageY}))},e.data.delay)},mousemove:function(e){hoveract.pageX=e.pageX;hoveract.pageY=e.pageY},mouseleave:function(e){var $related=$(e.relatedTarget);if($related.is(".context-menu-list")||$related.closest(".context-menu-list").length){return}try{clearTimeout(hoveract.timer)}catch(e){}hoveract.timer=null},layerClick:function(e){var $this=$(this),root=$this.data("contextMenuRoot"),button=e.button,x=e.pageX,y=e.pageY,target,offset;e.preventDefault();setTimeout(function(){var $window;var triggerAction=root.trigger==="left"&&button===0||root.trigger==="right"&&button===2;if(document.elementFromPoint&&root.$layer){root.$layer.hide();target=document.elementFromPoint(x-$win.scrollLeft(),y-$win.scrollTop());if(target.isContentEditable){var range=document.createRange(),sel=window.getSelection();range.selectNode(target);range.collapse(true);sel.removeAllRanges();sel.addRange(range)}$(target).trigger(e);root.$layer.show()}if(root.reposition&&triggerAction){if(document.elementFromPoint){if(root.$trigger.is(target)){root.position.call(root.$trigger,root,x,y);return}}else{offset=root.$trigger.offset();$window=$(window);offset.top+=$window.scrollTop();if(offset.top<=e.pageY){offset.left+=$window.scrollLeft();if(offset.left<=e.pageX){offset.bottom=offset.top+root.$trigger.outerHeight();if(offset.bottom>=e.pageY){offset.right=offset.left+root.$trigger.outerWidth();if(offset.right>=e.pageX){root.position.call(root.$trigger,root,x,y);return}}}}}}if(target&&triggerAction){root.$trigger.one("contextmenu:hidden",function(){$(target).contextMenu({x:x,y:y,button:button})})}if(root!==null&&typeof root!=="undefined"&&root.$menu!==null&&typeof root.$menu!=="undefined"){root.$menu.trigger("contextmenu:hide")}},50)},keyStop:function(e,opt){if(!opt.isInput){e.preventDefault()}e.stopPropagation()},key:function(e){var opt={};if($currentTrigger){opt=$currentTrigger.data("contextMenu")||{}}if(typeof opt.zIndex==="undefined"){opt.zIndex=0}var targetZIndex=0;var getZIndexOfTriggerTarget=function(target){if(target.style.zIndex!==""){targetZIndex=target.style.zIndex}else{if(target.offsetParent!==null&&typeof target.offsetParent!=="undefined"){getZIndexOfTriggerTarget(target.offsetParent)}else if(target.parentElement!==null&&typeof target.parentElement!=="undefined"){getZIndexOfTriggerTarget(target.parentElement)}}};getZIndexOfTriggerTarget(e.target);if(targetZIndex>opt.zIndex){return}switch(e.keyCode){case 9:case 38:handle.keyStop(e,opt);if(opt.isInput){if(e.keyCode===9&&e.shiftKey){e.preventDefault();if(opt.$selected){opt.$selected.find("input, textarea, select").blur()}if(opt.$menu!==null&&typeof opt.$menu!=="undefined"){opt.$menu.trigger("prevcommand")}return}else if(e.keyCode===38&&opt.$selected.find("input, textarea, select").prop("type")==="checkbox"){e.preventDefault();return}}else if(e.keyCode!==9||e.shiftKey){if(opt.$menu!==null&&typeof opt.$menu!=="undefined"){opt.$menu.trigger("prevcommand")}return}break;case 40:handle.keyStop(e,opt);if(opt.isInput){if(e.keyCode===9){e.preventDefault();if(opt.$selected){opt.$selected.find("input, textarea, select").blur()}if(opt.$menu!==null&&typeof opt.$menu!=="undefined"){opt.$menu.trigger("nextcommand")}return}else if(e.keyCode===40&&opt.$selected.find("input, textarea, select").prop("type")==="checkbox"){e.preventDefault();return}}else{if(opt.$menu!==null&&typeof opt.$menu!=="undefined"){opt.$menu.trigger("nextcommand")}return}break;case 37:handle.keyStop(e,opt);if(opt.isInput||!opt.$selected||!opt.$selected.length){break}if(!opt.$selected.parent().hasClass("context-menu-root")){var $parent=opt.$selected.parent().parent();opt.$selected.trigger("contextmenu:blur");opt.$selected=$parent;return}break;case 39:handle.keyStop(e,opt);if(opt.isInput||!opt.$selected||!opt.$selected.length){break}var itemdata=opt.$selected.data("contextMenu")||{};if(itemdata.$menu&&opt.$selected.hasClass("context-menu-submenu")){opt.$selected=null;itemdata.$selected=null;itemdata.$menu.trigger("nextcommand");return}break;case 35:case 36:if(opt.$selected&&opt.$selected.find("input, textarea, select").length){return}else{(opt.$selected&&opt.$selected.parent()||opt.$menu).children(":not(."+opt.classNames.disabled+", ."+opt.classNames.notSelectable+")")[e.keyCode===36?"first":"last"]().trigger("contextmenu:focus");e.preventDefault();return}break;case 13:handle.keyStop(e,opt);if(opt.isInput){if(opt.$selected&&!opt.$selected.is("textarea, select")){e.preventDefault();return}break}if(typeof opt.$selected!=="undefined"&&opt.$selected!==null){opt.$selected.trigger("mouseup")}return;case 32:case 33:case 34:handle.keyStop(e,opt);return;case 27:handle.keyStop(e,opt);if(opt.$menu!==null&&typeof opt.$menu!=="undefined"){opt.$menu.trigger("contextmenu:hide")}return;default:var k=String.fromCharCode(e.keyCode).toUpperCase();if(opt.accesskeys&&opt.accesskeys[k]){opt.accesskeys[k].$node.trigger(opt.accesskeys[k].$menu?"contextmenu:focus":"mouseup");return}break}e.stopPropagation();if(typeof opt.$selected!=="undefined"&&opt.$selected!==null){opt.$selected.trigger(e)}},prevItem:function(e){e.stopPropagation();var opt=$(this).data("contextMenu")||{};var root=$(this).data("contextMenuRoot")||{};if(opt.$selected){var $s=opt.$selected;opt=opt.$selected.parent().data("contextMenu")||{};opt.$selected=$s}var $children=opt.$menu.children(),$prev=!opt.$selected||!opt.$selected.prev().length?$children.last():opt.$selected.prev(),$round=$prev;while($prev.hasClass(root.classNames.disabled)||$prev.hasClass(root.classNames.notSelectable)||$prev.is(":hidden")){if($prev.prev().length){$prev=$prev.prev()}else{$prev=$children.last()}if($prev.is($round)){return}}if(opt.$selected){handle.itemMouseleave.call(opt.$selected.get(0),e)}handle.itemMouseenter.call($prev.get(0),e);var $input=$prev.find("input, textarea, select");if($input.length){$input.focus()}},nextItem:function(e){e.stopPropagation();var opt=$(this).data("contextMenu")||{};var root=$(this).data("contextMenuRoot")||{};if(opt.$selected){var $s=opt.$selected;opt=opt.$selected.parent().data("contextMenu")||{};opt.$selected=$s}var $children=opt.$menu.children(),$next=!opt.$selected||!opt.$selected.next().length?$children.first():opt.$selected.next(),$round=$next;while($next.hasClass(root.classNames.disabled)||$next.hasClass(root.classNames.notSelectable)||$next.is(":hidden")){if($next.next().length){$next=$next.next()}else{$next=$children.first()}if($next.is($round)){return}}if(opt.$selected){handle.itemMouseleave.call(opt.$selected.get(0),e)}handle.itemMouseenter.call($next.get(0),e);var $input=$next.find("input, textarea, select");if($input.length){$input.focus()}},focusInput:function(){var $this=$(this).closest(".context-menu-item"),data=$this.data(),opt=data.contextMenu,root=data.contextMenuRoot;root.$selected=opt.$selected=$this;root.isInput=opt.isInput=true},blurInput:function(){var $this=$(this).closest(".context-menu-item"),data=$this.data(),opt=data.contextMenu,root=data.contextMenuRoot;root.isInput=opt.isInput=false},menuMouseenter:function(){var root=$(this).data().contextMenuRoot;root.hovering=true},menuMouseleave:function(e){var root=$(this).data().contextMenuRoot;if(root.$layer&&root.$layer.is(e.relatedTarget)){root.hovering=false}},itemMouseenter:function(e){var $this=$(this),data=$this.data(),opt=data.contextMenu,root=data.contextMenuRoot;root.hovering=true;if(e&&root.$layer&&root.$layer.is(e.relatedTarget)){e.preventDefault();e.stopImmediatePropagation()}(opt.$menu?opt:root).$menu.children("."+root.classNames.hover).trigger("contextmenu:blur").children(".hover").trigger("contextmenu:blur");if($this.hasClass(root.classNames.disabled)||$this.hasClass(root.classNames.notSelectable)){opt.$selected=null;return}$this.trigger("contextmenu:focus")},itemMouseleave:function(e){var $this=$(this),data=$this.data(),opt=data.contextMenu,root=data.contextMenuRoot;if(root!==opt&&root.$layer&&root.$layer.is(e.relatedTarget)){if(typeof root.$selected!=="undefined"&&root.$selected!==null){root.$selected.trigger("contextmenu:blur")}e.preventDefault();e.stopImmediatePropagation();root.$selected=opt.$selected=opt.$node;return}$this.trigger("contextmenu:blur")},itemClick:function(e){var $this=$(this),data=$this.data(),opt=data.contextMenu,root=data.contextMenuRoot,key=data.contextMenuKey,callback;if(!opt.items[key]||$this.is("."+root.classNames.disabled+", .context-menu-separator, ."+root.classNames.notSelectable)||$this.is(".context-menu-submenu")&&root.selectableSubMenu===false){return}e.preventDefault();e.stopImmediatePropagation();if($.isFunction(opt.callbacks[key])&&Object.prototype.hasOwnProperty.call(opt.callbacks,key)){callback=opt.callbacks[key]}else if($.isFunction(root.callback)){callback=root.callback}else{return}if(callback.call(root.$trigger,key,root)!==false){root.$menu.trigger("contextmenu:hide")}else if(root.$menu.parent().length){op.update.call(root.$trigger,root)}},inputClick:function(e){e.stopImmediatePropagation()},hideMenu:function(e,data){var root=$(this).data("contextMenuRoot");op.hide.call(root.$trigger,root,data&&data.force)},focusItem:function(e){e.stopPropagation();var $this=$(this),data=$this.data(),opt=data.contextMenu,root=data.contextMenuRoot;if($this.hasClass(root.classNames.disabled)||$this.hasClass(root.classNames.notSelectable)){return}$this.addClass([root.classNames.hover,root.classNames.visible].join(" ")).parent().find(".context-menu-item").not($this).removeClass(root.classNames.visible).filter("."+root.classNames.hover).trigger("contextmenu:blur");opt.$selected=root.$selected=$this;if(opt.$node){root.positionSubmenu.call(opt.$node,opt.$menu)}},blurItem:function(e){e.stopPropagation();var $this=$(this),data=$this.data(),opt=data.contextMenu,root=data.contextMenuRoot;if(opt.autoHide){$this.removeClass(root.classNames.visible)}$this.removeClass(root.classNames.hover);opt.$selected=null}},op={show:function(opt,x,y){var $trigger=$(this),css={};$("#context-menu-layer").trigger("mousedown");opt.$trigger=$trigger;if(opt.events.show.call($trigger,opt)===false){$currentTrigger=null;return}op.update.call($trigger,opt);opt.position.call($trigger,opt,x,y);if(opt.zIndex){var additionalZValue=opt.zIndex;if(typeof opt.zIndex==="function"){additionalZValue=opt.zIndex.call($trigger,opt)}css.zIndex=zindex($trigger)+additionalZValue}op.layer.call(opt.$menu,opt,css.zIndex);opt.$menu.find("ul").css("zIndex",css.zIndex+1);opt.$menu.css(css)[opt.animation.show](opt.animation.duration,function(){$trigger.trigger("contextmenu:visible")});$trigger.data("contextMenu",opt).addClass("context-menu-active");$(document).off("keydown.contextMenu").on("keydown.contextMenu",handle.key);if(opt.autoHide){$(document).on("mousemove.contextMenuAutoHide",function(e){var pos=$trigger.offset();pos.right=pos.left+$trigger.outerWidth();pos.bottom=pos.top+$trigger.outerHeight();if(opt.$layer&&!opt.hovering&&(!(e.pageX>=pos.left&&e.pageX<=pos.right)||!(e.pageY>=pos.top&&e.pageY<=pos.bottom))){setTimeout(function(){if(!opt.hovering&&opt.$menu!==null&&typeof opt.$menu!=="undefined"){opt.$menu.trigger("contextmenu:hide")}},50)}})}},hide:function(opt,force){var $trigger=$(this);if(!opt){opt=$trigger.data("contextMenu")||{}}if(!force&&opt.events&&opt.events.hide.call($trigger,opt)===false){return}$trigger.removeData("contextMenu").removeClass("context-menu-active");if(opt.$layer){setTimeout(function($layer){return function(){$layer.remove()}}(opt.$layer),10);try{delete opt.$layer}catch(e){opt.$layer=null}}$currentTrigger=null;opt.$menu.find("."+opt.classNames.hover).trigger("contextmenu:blur");opt.$selected=null;opt.$menu.find("."+opt.classNames.visible).removeClass(opt.classNames.visible);$(document).off(".contextMenuAutoHide").off("keydown.contextMenu");if(opt.$menu){opt.$menu[opt.animation.hide](opt.animation.duration,function(){if(opt.build){opt.$menu.remove();$.each(opt,function(key){switch(key){case"ns":case"selector":case"build":case"trigger":return true;default:opt[key]=undefined;try{delete opt[key]}catch(e){}return true}})}setTimeout(function(){$trigger.trigger("contextmenu:hidden")},10)})}},create:function(opt,root){if(typeof root==="undefined"){root=opt}opt.$menu=$('<ul class="context-menu-list"></ul>').addClass(opt.className||"").data({contextMenu:opt,contextMenuRoot:root});$.each(["callbacks","commands","inputs"],function(i,k){opt[k]={};if(!root[k]){root[k]={}}});if(!root.accesskeys){root.accesskeys={}}function createNameNode(item){var $name=$("<span></span>");if(item._accesskey){if(item._beforeAccesskey){$name.append(document.createTextNode(item._beforeAccesskey))}$("<span></span>").addClass("context-menu-accesskey").text(item._accesskey).appendTo($name);if(item._afterAccesskey){$name.append(document.createTextNode(item._afterAccesskey))}}else{if(item.isHtmlName){if(typeof item.accesskey!=="undefined"){throw new Error("accesskeys are not compatible with HTML names and cannot be used together in the same item")}$name.html(item.name)}else{$name.text(item.name)}}return $name}$.each(opt.items,function(key,item){var $t=$('<li class="context-menu-item"></li>').addClass(item.className||""),$label=null,$input=null;$t.on("click",$.noop);if(typeof item==="string"||item.type==="cm_separator"){item={type:"cm_seperator"}}item.$node=$t.data({contextMenu:opt,contextMenuRoot:root,contextMenuKey:key});if(typeof item.accesskey!=="undefined"){var aks=splitAccesskey(item.accesskey);for(var i=0,ak;ak=aks[i];i++){if(!root.accesskeys[ak]){root.accesskeys[ak]=item;var matched=item.name.match(new RegExp("^(.*?)("+ak+")(.*)$","i"));if(matched){item._beforeAccesskey=matched[1];item._accesskey=matched[2];item._afterAccesskey=matched[3]}break}}}if(item.type&&types[item.type]){types[item.type].call($t,item,opt,root);$.each([opt,root],function(i,k){k.commands[key]=item;if($.isFunction(item.callback)&&(typeof k.callbacks[key]==="undefined"||typeof opt.type==="undefined")){k.callbacks[key]=item.callback}})}else{if(item.type==="cm_seperator"){$t.addClass("context-menu-separator "+root.classNames.notSelectable)}else if(item.type==="html"){$t.addClass("context-menu-html "+root.classNames.notSelectable)}else if(item.type==="sub"){}else if(item.type){$label=$("<label></label>").appendTo($t);createNameNode(item).appendTo($label);$t.addClass("context-menu-input");opt.hasTypes=true;$.each([opt,root],function(i,k){k.commands[key]=item;k.inputs[key]=item})}else if(item.items){item.type="sub"}switch(item.type){case"cm_seperator":break;case"text":$input=$('<input type="text" value="1" name="" />').attr("name","context-menu-input-"+key).val(item.value||"").appendTo($label);break;case"textarea":$input=$('<textarea name=""></textarea>').attr("name","context-menu-input-"+key).val(item.value||"").appendTo($label);if(item.height){$input.height(item.height)}break;case"checkbox":$input=$('<input type="checkbox" value="1" name="" />').attr("name","context-menu-input-"+key).val(item.value||"").prop("checked",!!item.selected).prependTo($label);break;case"radio":$input=$('<input type="radio" value="1" name="" />').attr("name","context-menu-input-"+item.radio).val(item.value||"").prop("checked",!!item.selected).prependTo($label);break;case"select":$input=$('<select name=""></select>').attr("name","context-menu-input-"+key).appendTo($label);if(item.options){$.each(item.options,function(value,text){$("<option></option>").val(value).text(text).appendTo($input)});$input.val(item.selected)}break;case"sub":createNameNode(item).appendTo($t);item.appendTo=item.$node;$t.data("contextMenu",item).addClass("context-menu-submenu");item.callback=null;if("function"===typeof item.items.then){op.processPromises(item,root,item.items)}else{op.create(item,root)}break;case"html":$(item.html).appendTo($t);break;default:$.each([opt,root],function(i,k){k.commands[key]=item;if($.isFunction(item.callback)&&(typeof k.callbacks[key]==="undefined"||typeof opt.type==="undefined")){k.callbacks[key]=item.callback}});createNameNode(item).appendTo($t);break}if(item.type&&item.type!=="sub"&&item.type!=="html"&&item.type!=="cm_seperator"){$input.on("focus",handle.focusInput).on("blur",handle.blurInput);if(item.events){$input.on(item.events,opt)}}if(item.icon){if($.isFunction(item.icon)){item._icon=item.icon.call(this,this,$t,key,item)}else{if(typeof item.icon==="string"&&item.icon.substring(0,3)==="fa-"){item._icon=root.classNames.icon+" "+root.classNames.icon+"--fa fa "+item.icon}else{item._icon=root.classNames.icon+" "+root.classNames.icon+"-"+item.icon}}$t.addClass(item._icon)}}item.$input=$input;item.$label=$label;$t.appendTo(opt.$menu);if(!opt.hasTypes&&$.support.eventSelectstart){$t.on("selectstart.disableTextSelect",handle.abortevent)}});if(!opt.$node){opt.$menu.css("display","none").addClass("context-menu-root")}opt.$menu.appendTo(opt.appendTo||document.body)},resize:function($menu,nested){var domMenu;$menu.css({position:"absolute",display:"block"});$menu.data("width",(domMenu=$menu.get(0)).getBoundingClientRect?Math.ceil(domMenu.getBoundingClientRect().width):$menu.outerWidth()+1);$menu.css({position:"static",minWidth:"0px",maxWidth:"100000px"});$menu.find("> li > ul").each(function(){op.resize($(this),true)});if(!nested){$menu.find("ul").addBack().css({position:"",display:"",minWidth:"",maxWidth:""}).outerWidth(function(){return $(this).data("width")})}},update:function(opt,root){var $trigger=this;if(typeof root==="undefined"){root=opt;op.resize(opt.$menu)}opt.$menu.children().each(function(){var $item=$(this),key=$item.data("contextMenuKey"),item=opt.items[key],disabled=$.isFunction(item.disabled)&&item.disabled.call($trigger,key,root)||item.disabled===true,visible;if($.isFunction(item.visible)){visible=item.visible.call($trigger,key,root)}else if(typeof item.visible!=="undefined"){visible=item.visible===true}else{visible=true}$item[visible?"show":"hide"]();$item[disabled?"addClass":"removeClass"](root.classNames.disabled);if($.isFunction(item.icon)){$item.removeClass(item._icon);item._icon=item.icon.call(this,$trigger,$item,key,item);$item.addClass(item._icon)}if(item.type){$item.find("input, select, textarea").prop("disabled",disabled);switch(item.type){case"text":case"textarea":item.$input.val(item.value||"");break;case"checkbox":case"radio":item.$input.val(item.value||"").prop("checked",!!item.selected);break;case"select":item.$input.val((item.selected===0?"0":item.selected)||"");break}}if(item.$menu){op.update.call($trigger,item,root)}})},layer:function(opt,zIndex){var $layer=opt.$layer=$('<div id="context-menu-layer"></div>').css({height:$win.height(),width:$win.width(),display:"block",position:"fixed","z-index":zIndex,top:0,left:0,opacity:0,filter:"alpha(opacity=0)","background-color":"#000"}).data("contextMenuRoot",opt).insertBefore(this).on("contextmenu",handle.abortevent).on("mousedown",handle.layerClick);if(typeof document.body.style.maxWidth==="undefined"){$layer.css({position:"absolute",height:$(document).height()})}return $layer},processPromises:function(opt,root,promise){opt.$node.addClass(root.classNames.iconLoadingClass);function completedPromise(opt,root,items){if(typeof items==="undefined"){errorPromise(undefined)}finishPromiseProcess(opt,root,items)}function errorPromise(opt,root,errorItem){if(typeof errorItem==="undefined"){errorItem={error:{name:"No items and no error item",icon:"context-menu-icon context-menu-icon-quit"}};if(window.console){(console.error||console.log).call(console,'When you reject a promise, provide an "items" object, equal to normal sub-menu items')}}else if(typeof errorItem==="string"){errorItem={error:{name:errorItem}}}finishPromiseProcess(opt,root,errorItem)}function finishPromiseProcess(opt,root,items){if(typeof root.$menu==="undefined"||!root.$menu.is(":visible")){return}opt.$node.removeClass(root.classNames.iconLoadingClass);opt.items=items;op.create(opt,root,true);op.update(opt,root);root.positionSubmenu.call(opt.$node,opt.$menu)}promise.then(completedPromise.bind(this,opt,root),errorPromise.bind(this,opt,root))}};function splitAccesskey(val){var t=val.split(/\s+/);var keys=[];for(var i=0,k;k=t[i];i++){k=k.charAt(0).toUpperCase();keys.push(k)}return keys}$.fn.contextMenu=function(operation){var $t=this,$o=operation;if(this.length>0){if(typeof operation==="undefined"){this.first().trigger("contextmenu")}else if(typeof operation.x!=="undefined"&&typeof operation.y!=="undefined"){this.first().trigger($.Event("contextmenu",{pageX:operation.x,pageY:operation.y,mouseButton:operation.button}))}else if(operation==="hide"){var $menu=this.first().data("contextMenu")?this.first().data("contextMenu").$menu:null;if($menu){$menu.trigger("contextmenu:hide")}}else if(operation==="destroy"){$.contextMenu("destroy",{context:this})}else if($.isPlainObject(operation)){operation.context=this;$.contextMenu("create",operation)}else if(operation){this.removeClass("context-menu-disabled")}else if(!operation){this.addClass("context-menu-disabled")}}else{$.each(menus,function(){if(this.selector===$t.selector){$o.data=this;$.extend($o.data,{trigger:"demand"})}});handle.contextmenu.call($o.target,$o)}return this};$.contextMenu=function(operation,options){if(typeof operation!=="string"){options=operation;operation="create"}if(typeof options==="string"){options={selector:options}}else if(typeof options==="undefined"){options={}}var o=$.extend(true,{},defaults,options||{});var $document=$(document);var $context=$document;var _hasContext=false;if(!o.context||!o.context.length){o.context=document}else{$context=$(o.context).first();o.context=$context.get(0);_hasContext=!$(o.context).is(document)}switch(operation){case"create":if(!o.selector){throw new Error("No selector specified")}if(o.selector.match(/.context-menu-(list|item|input)($|\s)/)){throw new Error('Cannot bind to selector "'+o.selector+'" as it contains a reserved className')}if(!o.build&&(!o.items||$.isEmptyObject(o.items))){throw new Error("No Items specified")}counter++;o.ns=".contextMenu"+counter;if(!_hasContext){namespaces[o.selector]=o.ns}menus[o.ns]=o;if(!o.trigger){o.trigger="right"}if(!initialized){var itemClick=o.itemClickEvent==="click"?"click.contextMenu":"mouseup.contextMenu";var contextMenuItemObj={"contextmenu:focus.contextMenu":handle.focusItem,"contextmenu:blur.contextMenu":handle.blurItem,"contextmenu.contextMenu":handle.abortevent,"mouseenter.contextMenu":handle.itemMouseenter,"mouseleave.contextMenu":handle.itemMouseleave};contextMenuItemObj[itemClick]=handle.itemClick;$document.on({"contextmenu:hide.contextMenu":handle.hideMenu,"prevcommand.contextMenu":handle.prevItem,"nextcommand.contextMenu":handle.nextItem,"contextmenu.contextMenu":handle.abortevent,"mouseenter.contextMenu":handle.menuMouseenter,"mouseleave.contextMenu":handle.menuMouseleave},".context-menu-list").on("mouseup.contextMenu",".context-menu-input",handle.inputClick).on(contextMenuItemObj,".context-menu-item");initialized=true}$context.on("contextmenu"+o.ns,o.selector,o,handle.contextmenu);if(_hasContext){$context.on("remove"+o.ns,function(){$(this).contextMenu("destroy")})}switch(o.trigger){case"hover":$context.on("mouseenter"+o.ns,o.selector,o,handle.mouseenter).on("mouseleave"+o.ns,o.selector,o,handle.mouseleave);break;case"left":$context.on("click"+o.ns,o.selector,o,handle.click);break}if(!o.build){op.create(o)}break;case"destroy":var $visibleMenu;if(_hasContext){var context=o.context;$.each(menus,function(ns,o){if(!o){return true}if(!$(context).is(o.selector)){return true}$visibleMenu=$(".context-menu-list").filter(":visible");if($visibleMenu.length&&$visibleMenu.data().contextMenuRoot.$trigger.is($(o.context).find(o.selector))){$visibleMenu.trigger("contextmenu:hide",{force:true})}try{if(menus[o.ns].$menu){menus[o.ns].$menu.remove()}delete menus[o.ns]}catch(e){menus[o.ns]=null}$(o.context).off(o.ns);return true})}else if(!o.selector){$document.off(".contextMenu .contextMenuAutoHide");$.each(menus,function(ns,o){$(o.context).off(o.ns)});namespaces={};menus={};counter=0;initialized=false;$("#context-menu-layer, .context-menu-list").remove()}else if(namespaces[o.selector]){$visibleMenu=$(".context-menu-list").filter(":visible");if($visibleMenu.length&&$visibleMenu.data().contextMenuRoot.$trigger.is(o.selector)){$visibleMenu.trigger("contextmenu:hide",{force:true})}try{if(menus[namespaces[o.selector]].$menu){menus[namespaces[o.selector]].$menu.remove()}delete menus[namespaces[o.selector]]}catch(e){menus[namespaces[o.selector]]=null}$document.off(namespaces[o.selector])}break;case"html5":if(!$.support.htmlCommand&&!$.support.htmlMenuitem||typeof options==="boolean"&&options){$('menu[type="context"]').each(function(){if(this.id){$.contextMenu({selector:"[contextmenu="+this.id+"]",items:$.contextMenu.fromMenu(this)})}}).css("display","none")}break;default:throw new Error('Unknown operation "'+operation+'"')}return this};$.contextMenu.setInputValues=function(opt,data){if(typeof data==="undefined"){data={}}$.each(opt.inputs,function(key,item){switch(item.type){case"text":case"textarea":item.value=data[key]||"";break;case"checkbox":item.selected=data[key]?true:false;break;case"radio":item.selected=(data[item.radio]||"")===item.value;break;case"select":item.selected=data[key]||"";break}})};$.contextMenu.getInputValues=function(opt,data){if(typeof data==="undefined"){data={}}$.each(opt.inputs,function(key,item){switch(item.type){case"text":case"textarea":case"select":data[key]=item.$input.val();break;case"checkbox":data[key]=item.$input.prop("checked");break;case"radio":if(item.$input.prop("checked")){data[item.radio]=item.value}break}});return data};function inputLabel(node){return node.id&&$('label[for="'+node.id+'"]').val()||node.name}function menuChildren(items,$children,counter){if(!counter){counter=0}$children.each(function(){var $node=$(this),node=this,nodeName=this.nodeName.toLowerCase(),label,item;if(nodeName==="label"&&$node.find("input, textarea, select").length){label=$node.text();$node=$node.children().first();node=$node.get(0);nodeName=node.nodeName.toLowerCase()}switch(nodeName){case"menu":item={name:$node.attr("label"),items:{}};counter=menuChildren(item.items,$node.children(),counter);break;case"a":case"button":item={name:$node.text(),disabled:!!$node.attr("disabled"),callback:function(){return function(){$node.click()}}()};break;case"menuitem":case"command":switch($node.attr("type")){case undefined:case"command":case"menuitem":item={name:$node.attr("label"),disabled:!!$node.attr("disabled"),icon:$node.attr("icon"),callback:function(){return function(){
$node.click()}}()};break;case"checkbox":item={type:"checkbox",disabled:!!$node.attr("disabled"),name:$node.attr("label"),selected:!!$node.attr("checked")};break;case"radio":item={type:"radio",disabled:!!$node.attr("disabled"),name:$node.attr("label"),radio:$node.attr("radiogroup"),value:$node.attr("id"),selected:!!$node.attr("checked")};break;default:item=undefined}break;case"hr":item="-------";break;case"input":switch($node.attr("type")){case"text":item={type:"text",name:label||inputLabel(node),disabled:!!$node.attr("disabled"),value:$node.val()};break;case"checkbox":item={type:"checkbox",name:label||inputLabel(node),disabled:!!$node.attr("disabled"),selected:!!$node.attr("checked")};break;case"radio":item={type:"radio",name:label||inputLabel(node),disabled:!!$node.attr("disabled"),radio:!!$node.attr("name"),value:$node.val(),selected:!!$node.attr("checked")};break;default:item=undefined;break}break;case"select":item={type:"select",name:label||inputLabel(node),disabled:!!$node.attr("disabled"),selected:$node.val(),options:{}};$node.children().each(function(){item.options[this.value]=$(this).text()});break;case"textarea":item={type:"textarea",name:label||inputLabel(node),disabled:!!$node.attr("disabled"),value:$node.val()};break;case"label":break;default:item={type:"html",html:$node.clone(true)};break}if(item){counter++;items["key"+counter]=item}});return counter}$.contextMenu.fromMenu=function(element){var $this=$(element),items={};menuChildren(items,$this.children());return items};$.contextMenu.defaults=defaults;$.contextMenu.types=types;$.contextMenu.handle=handle;$.contextMenu.op=op;$.contextMenu.menus=menus});
