/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author JJ Frankovich
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/util/ICollectionSupport
 */
define(['bajaux/Widget', 'nmodule/webEditors/rc/wb/mixin/mixinUtils'], function (Widget, mixinUtils) {
  'use strict';

  var applyMixin = mixinUtils.applyMixin;
  var MIXIN_NAME = 'ICollectionSupport';

  /**
   * Applies `ICollectionSupport` functionality to a Widget. A widget with this
   * mixin will support multiple Widget.load calls in `UxMedia`, one for each `bajaui:WbViewBinding`.
   *
   * @mixin
   * @alias module:nmodule/webEditors/rc/wb/util/ICollectionSupport
   * @param {module:bajaux/Widget} target
   * @example
   * <caption>A widget with ICollection support</caption>
   * var CollectionWidget = function () {
   *   Widget.apply(this, arguments);
   *   ICollectionSupport(this);
   *   this.$loadedValues = [];
   * };
   * CollectionWidget.prototype = Object.create(Widget.prototype);
   * CollectionWidget.prototype.doLoad = function (value) {
   *   this.$loadValues.push(value);
   * };
   **/

  var ICollectionSupport = function ICollectionSupport(target) {
    if (!(target instanceof Widget)) {
      throw new Error('Widget required');
    }
    applyMixin(target, MIXIN_NAME, ICollectionSupport.prototype);
  };

  /**
   * @param {*} target
   * @returns {boolean}
   */
  ICollectionSupport.isOn = function (target) {
    return mixinUtils.hasMixin(target, MIXIN_NAME);
  };

  /**
   * @type {string}
   */
  ICollectionSupport.MIXIN_NAME = MIXIN_NAME;
  return ICollectionSupport;
});
