/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/tree/BajaSlotTreeNode
 */
define(['nmodule/webEditors/rc/fe/baja/util/slotUtils', 'nmodule/webEditors/rc/wb/tree/TreeNode'], function (slotUtils, TreeNode) {
  'use strict';

  var getSlotIcon = slotUtils.getSlotIcon;

  /**
   * Tree node for holding a slot (simple property, action or topic). Will never
   * resolve any child nodes.
   *
   * @class
   * @alias module:nmodule/webEditors/rc/wb/tree/BajaSlotTreeNode
   * @extends module:nmodule/webEditors/rc/wb/tree/TreeNode
   * @param {baja.Complex} complex
   * @param {baja.Slot} slot
   */
  var BajaSlotTreeNode = function BajaSlotTreeNode(complex, slot) {
    slot = complex.getSlot(slot);
    var name = slot.getName(),
      displayName = complex.getDisplayName(slot);
    TreeNode.call(this, name, displayName);
    this.$icon = getSlotIcon(slot);
  };
  BajaSlotTreeNode.prototype = Object.create(TreeNode.prototype);
  BajaSlotTreeNode.prototype.constructor = BajaSlotTreeNode;
  BajaSlotTreeNode.prototype.getIcon = function () {
    return this.$icon;
  };
  BajaSlotTreeNode.prototype.mayHaveKids = function () {
    return false;
  };
  return BajaSlotTreeNode;
});
