/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @module nmodule/webEditors/rc/wb/table/model/columns/DisplayNameColumn
 */
define(['lex!webEditors', 'nmodule/webEditors/rc/fe/baja/util/typeUtils', 'nmodule/webEditors/rc/wb/table/model/Column'], function (lexs, typeUtils, Column) {
  'use strict';

  var webEditorsLex = lexs[0];

  /**
   * API Status: **Development**
   *
   * Column for showing a component's display name.
   *
   * @class
   * @alias module:nmodule/webEditors/rc/wb/table/model/columns/DisplayNameColumn
   * @extends module:nmodule/webEditors/rc/wb/table/model/Column
   */
  var DisplayNameColumn = function DisplayNameColumn() {
    Column.apply(this, arguments);
  };
  DisplayNameColumn.prototype = Object.create(Column.prototype);
  DisplayNameColumn.prototype.constructor = DisplayNameColumn;

  /**
   * Return `name` from the `webEditors` lexicon.
   *
   * @returns {String}
   */
  DisplayNameColumn.prototype.getName = function () {
    return webEditorsLex.get('name');
  };

  /**
   * Return the component's display name.
   *
   * @param {module:nmodule/webEditors/rc/wb/table/model/Row} row
   * @returns {String} the component's display name
   * @throws {Error} if the row does not actually have a `Component` loaded
   */
  DisplayNameColumn.prototype.getValueFor = function (row) {
    var comp = row.getSubject();
    if (!typeUtils.isComponent(comp)) {
      throw new Error('component required');
    }
    return comp.getDisplayName();
  };
  return DisplayNameColumn;
});
