/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @module nmodule/webEditors/rc/wb/table/model/Row
 */
define(['underscore', 'nmodule/webEditors/rc/mixin/DataMixin'], function (_, DataMixin) {
  'use strict';

  /**
   * API Status: **Development**
   *
   * Row for use in a `TableModel`.
   *
   * @class
   * @alias module:nmodule/webEditors/rc/wb/table/model/Row
   * @mixes module:nmodule/webEditors/rc/mixin/DataMixin
   * @param {*} subject the value represented by this row
   * @param {*} [icon]
   * @see module:nmodule/webEditors/rc/wb/table/model/TableModel
   */
  var Row = function Row(subject, icon) {
    this.$subject = subject;
    this.$icon = icon || null;
    DataMixin(this);
  };

  /**
   * Get the value represented by this row.
   *
   * @returns {*}
   */
  Row.prototype.getSubject = function () {
    return this.$subject;
  };

  /**
   * Update the value of the row.
   *
   * This is currently intended for internal use by the framework only.
   * @private
   * @param {*} subject
   */
  Row.prototype.$setSubject = function (subject) {
    this.$subject = subject;
  };

  /**
   * Get this row's icon.
   *
   * @returns {*} the icon, or null if none given
   */
  Row.prototype.getIcon = function () {
    return this.$icon;
  };
  return Row;
});
