function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/table/menu/DefaultTableContextMenu
 */
define(['bajaux/commands/Command', 'bajaux/commands/CommandGroup', 'Promise', 'underscore', 'nmodule/webEditors/rc/transform/ExportCommand', 'nmodule/webEditors/rc/wb/menu/CommandGroupContextMenu', 'nmodule/webEditors/rc/wb/menu/Separator'], function (Command, CommandGroup, Promise, _, ExportCommand, CommandGroupContextMenu, Separator) {
  'use strict';

  var BLANK_ICON = 'module://icons/x16/blank.png',
    CHECK_ICON = 'module://icons/x16/whiteIcons/check.png';

  /**
   * Default context menu for a Table. Will include an export command and
   * commands to show/hide individual columns.
   *
   * @class
   * @alias module:nmodule/webEditors/rc/wb/table/menu/DefaultTableContextMenu
   * @extends module:nmodule/webEditors/rc/wb/menu/CommandGroupContextMenu
   * @param {module:nmodule/webEditors/rc/wb/table/Table} table
   */
  var DefaultTableContextMenu = function DefaultTableContextMenu(table) {
    CommandGroupContextMenu.apply(this, arguments);
    this.$table = table;
  };
  DefaultTableContextMenu.prototype = Object.create(CommandGroupContextMenu.prototype);
  DefaultTableContextMenu.prototype.constructor = DefaultTableContextMenu;

  /**
   * Causes a default context menu to be added to the table when it is
   * initialized.
   *
   * @param {module:nmodule/webEditors/rc/wb/table/Table|function} table a table
   * instance to apply the mixin to; or, a Table subclass constructor. If a
   * a constructor is given, a subclass of that constructor will be created that
   * applies the mixin to every instance.
   * @param {object} [params]
   * @param {function} [params.ctor=DefaultTableContextMenu] specify a
   * particular subclass of DefaultTableContextMenu if desired. The Table
   * instance will be passed to the constructor.
   * @returns {undefined|function}
   */
  DefaultTableContextMenu.mixin = function (table) {
    var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    if (typeof table === 'function') {
      return /*#__PURE__*/function (_table) {
        function TableWithMenu() {
          var _this;
          _classCallCheck(this, TableWithMenu);
          _this = _callSuper(this, TableWithMenu, arguments);
          DefaultTableContextMenu.mixin(_this, params);
          return _this;
        }
        _inherits(TableWithMenu, _table);
        return _createClass(TableWithMenu);
      }(table);
    }
    var _params$ctor = params.ctor,
      Ctor = _params$ctor === void 0 ? DefaultTableContextMenu : _params$ctor;
    var doInitialize = table.doInitialize,
      doDestroy = table.doDestroy;
    table.doInitialize = function (dom) {
      var contextMenu = this.$contextMenu = new Ctor(this);
      contextMenu.arm(dom, '.-t-defaultShowHideMenu');
      return Promise.resolve(doInitialize.apply(this, arguments)).then(function () {
        dom.append('<div class="showHideMenu -t-defaultShowHideMenu"></div>');
        dom.css('position', 'relative');
      });
    };
    table.doDestroy = function () {
      this.$contextMenu.destroy();
      return doDestroy.apply(this, arguments);
    };
  };

  /**
   * @returns {Promise.<module:bajaux/commands/CommandGroup>}
   */
  DefaultTableContextMenu.prototype.toContextMenu = function () {
    var table = this.$table;
    return Promise.all([getExportCommand(table), new Separator(), getShowHideCommands(table)]).then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 3),
        exportCmd = _ref2[0],
        separator = _ref2[1],
        showHideCommands = _ref2[2];
      return new CommandGroup({
        commands: [exportCmd, separator].concat(showHideCommands)
      });
    });
  };

  /**
   * @param {JQuery} jq
   * @param {string} selector
   */
  DefaultTableContextMenu.prototype.arm = function (jq, selector) {
    var that = this;
    jq.on('click', selector, function (e) {
      return that.$doContextMenu(e);
    });
    that.$armContextMenuAsync(jq, selector);
  };

  /**
   * @param {module:nmodule/webEditors/rc/wb/table/Table} table
   * @returns {module:bajaux/commands/Command}
   */
  function getExportCommand(table) {
    return new ExportCommand(table);
  }
  var ShowHideColumnCommand = function ShowHideColumnCommand(column, displayName) {
    Command.call(this, {
      displayName: displayName,
      icon: getIcon(column),
      func: function func() {
        column.setUnseen(!column.isUnseen());
        this.setIcon(getIcon(column));
      }
    });
  };
  ShowHideColumnCommand.prototype = Object.create(Command.prototype);
  ShowHideColumnCommand.prototype.constructor = ShowHideColumnCommand;
  ShowHideColumnCommand.prototype.hideAfterInvoke = function () {
    return false;
  };
  ShowHideColumnCommand.prototype.safeToHideIcon = function () {
    return false;
  };

  /**
   * @param {module:nmodule/webEditors/rc/wb/table/model/Column} column
   * @returns {string}
   */
  function getIcon(column) {
    return column.isUnseen() ? BLANK_ICON : CHECK_ICON;
  }

  /**
   * @param {module:nmodule/webEditors/rc/wb/table/Table} table
   * @returns {Promise<module:bajaux/commands/Command>}
   */
  function getShowHideCommands(table) {
    var model = table.getModel(),
      columns = _.filter(model.getColumns(), function (col) {
        return col.isHidable();
      });
    return Promise.all(columns.map(function (column) {
      return Promise.resolve(column.toDisplayName()).then(function (displayName) {
        return new ShowHideColumnCommand(column, displayName);
      });
    }));
  }
  return DefaultTableContextMenu;
});
