function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 * @author Danesh Kamal
 */

/**
 * API Status: **Development**
 *
 * @module nmodule/webEditors/rc/wb/table/commands/MoveDownCommand
 * @since Niagara 4.12
 */

define(['underscore', 'bajaux/commands/Command'], function (_, Command) {
  'use strict';

  var last = _.last;
  function handleMoveDown(getTable) {
    var table = getTable();
    var selection = table.$getSelection();
    var model = table.value();
    var actualRows = model.$getRowsUnsafe();
    var selectedRows = selection.getSelectedElements(actualRows);
    var selectedIndices = selectedRows.map(function (row) {
      return model.getRowIndex(row);
    });
    var isLastRowSelected = last(selectedIndices) === actualRows.length - 1;
    var rowsIndexToWasReordered = Array(actualRows.length);
    if (!selectedRows.length || isLastRowSelected) {
      return;
    }
    for (var len = selectedIndices.length, i = len - 1; i >= 0; --i) {
      var indexToMoveDown = selectedIndices[i];
      var temp = actualRows[indexToMoveDown + 1];
      actualRows[indexToMoveDown + 1] = actualRows[indexToMoveDown];
      actualRows[indexToMoveDown] = temp;
      rowsIndexToWasReordered[indexToMoveDown] = true;
      rowsIndexToWasReordered[indexToMoveDown + 1] = true;
    }
    var reorderedRows = [];
    rowsIndexToWasReordered.forEach(function (rowAtIndexWasReordered, index) {
      if (rowAtIndexWasReordered) {
        reorderedRows.push(actualRows[index]);
      }
    });
    if (reorderedRows.length > 0) {
      // Silently select "moved-down-rows"
      var movedDownIndices = selectedIndices.map(function (index) {
        return index + 1;
      });
      actualRows.forEach(function (row, index) {
        return selection.put(index, movedDownIndices.contains(index));
      });
      // Update row indices and emit "reOrderedRows" event
      model.$updateIndices();
      model.emit('rowsReordered', reorderedRows);
      table.setModified(true);
      //Trigger selection's 'changed' to refresh the command enable/disable status
      selection.emit('changed');
    }
  }

  /**
   * This command will move rows down in the ordering of the backing table model. The table model
   * will also emit a rowsReordered event when this happens.
   *
   * This command will be initially disabled, and it is the responsibility of the code where it is
   * used to manage the command's enabled / disabled state.
   *
   * @class
   * @extends module:bajaux/commands/Command
   * @alias module:nmodule/webEditors/rc/wb/table/commands/MoveDownCommand
   * @see module:nmodule/webEditors/rc/wb/table/Table
   * @param {Function} getTable a function that returns the target table of this command.
   * @param {Object} [params]
   * @param {String} [params.module='webEditors'] the module to look up the commands lexicon entry
   * @param {String} [params.lex='commands.moveDown'] the lexicon key to look up the command with
   */
  var MoveDownCommand = /*#__PURE__*/function (_Command) {
    function MoveDownCommand(getTable) {
      var _ref = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
        _ref$module = _ref.module,
        module = _ref$module === void 0 ? 'webEditors' : _ref$module,
        _ref$lex = _ref.lex,
        lex = _ref$lex === void 0 ? 'commands.moveDown' : _ref$lex;
      _classCallCheck(this, MoveDownCommand);
      return _callSuper(this, MoveDownCommand, [{
        module: module,
        lex: lex,
        enabled: false,
        func: function func() {
          return handleMoveDown(getTable);
        }
      }]);
    }
    _inherits(MoveDownCommand, _Command);
    return _createClass(MoveDownCommand);
  }(Command);
  return MoveDownCommand;
});
