function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Gareth Johnson.
 */

/**
 * API Status: **Private**
 *
 * Loads the Nav Tree Sidebar.
 *
 * @module nmodule/webEditors/rc/wb/profile/navTreeSideBar
 */
define(["log!nmodule.webEditors.rc.wb.profile.navTreeSideBar", "Promise", "nmodule/js/rc/asyncUtils/asyncUtils", "nmodule/webEditors/rc/servlets/navMonitor", "nmodule/webEditors/rc/wb/shell/TitlePane", "nmodule/webEditors/rc/wb/mixin/ContextMenuSupport", "nmodule/webEditors/rc/wb/mixin/NavMonitorSupport", "nmodule/webEditors/rc/wb/profile/SyncTreeCommand", "nmodule/webEditors/rc/wb/tree/stationTree", "nmodule/webEditors/rc/wb/tree/NavTree"], function (log, Promise, asyncUtils, navMonitor, TitlePane, addContextMenuSupport, addNavMonitorSupport, SyncTreeCommand, stationTree, NavTree) {
  'use strict';

  var logError = log.severe.bind(log),
    doRequire = asyncUtils.doRequire;

  //TODO: can we clear session storage on logout? !this is important for security reasons

  /**
   *  Function that load the nav tree
   * @since Niagara 4.14
   * @return {Promise}
   */
  function loadNavTree(dom, hyperlinkFunc, params) {
    var titlePane = new TitlePane(),
      navTree;
    return stationTree.createNavTree({
      loadKids: false,
      enableHoverPreload: true
    }).then(function (tree) {
      navTree = tree;
      navTree.getCommandGroup().add(new SyncTreeCommand(navTree));
      addContextMenuSupport(navTree);
      addNavMonitorSupport(navTree);

      //whenever a nav tree node is expanded, request an immediate touch.
      //see javax.baja.workbench.nav.tree.NavTreeNode#expand().
      dom.on(NavTree.EXPANDED_EVENT, function () {
        navTree.emit(navMonitor.REQUEST_TOUCH_EVENT);
      });
      return titlePane.initialize(dom);
    }).then(function () {
      dom.on(NavTree.ACTIVATED_EVENT, function (e, ed) {
        var node = ed.value();
        node.toHyperlinkUri().then(function (uri) {
          if (uri) {
            hyperlinkFunc(uri);
          } else {
            ed.$setExpanded(!ed.$isExpanded())["catch"](logError);
          }
        })["catch"](logError);
      });
      return Promise.all([stationTree.makeRootNode(params), titlePane.setContentWidget(navTree)]);
    }).then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 1),
        rootNode = _ref2[0];
      return Promise.all([doRequire("profileInfo"), titlePane.load(rootNode)]);
    }).then(function (_ref3) {
      var _ref4 = _slicedToArray(_ref3, 1),
        profileInfo = _ref4[0];
      //should loading spinner stay up until setSelectedPath completes? if so, return this
      SyncTreeCommand.syncNavTree(profileInfo.getOrd(), navTree)["catch"](logError);
    });
  }

  /**
   * Load the Nav Tree.
   *
   * @inner
   * @private
   *
   * @param {JQuery} dom The jQuery DOM to load the Nav Tree into.
   * @param {Function} hyperlinkFunc A function used to hyperlink to a
   * URI.
   * @param {Object} params Loading options for the Nav Tree.
   */
  function navTreeSideBar(dom, hyperlinkFunc, params) {
    dom.one("sidebar-layout", function () {
      loadNavTree(dom, hyperlinkFunc, params)["catch"](logError);
    });
  }
  return navTreeSideBar;
});
