function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/*global niagara: false */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/mixin/PropertySheetRowDragSupport
 */
define(['baja!', 'bajaux/dragdrop/dragDropUtils', 'Promise', 'underscore', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/wb/commands/AddSlotCommand', 'nmodule/webEditors/rc/wb/mixin/mixinUtils', 'css!nmodule/webEditors/rc/wb/mixin/PropertySheetRowDragSupport'], function (baja, dragDropUtils, Promise, _, feDialogs, AddSlotCommand, mixinUtils) {
  'use strict';

  var fromClipboard = dragDropUtils.fromClipboard,
    applyMixin = mixinUtils.applyMixin,
    MIXIN_NAME = 'dragSupport';
  function isComponent(comp) {
    return baja.hasType(comp, 'baja:Component');
  }
  function isWb() {
    return typeof niagara !== 'undefined' && niagara.env.type === 'wb';
  }
  function canAddSlot(comp) {
    return isComponent(comp) && comp.getPermissions().hasAdminWrite();
  }

  //TODO: fix drag highlighting in Workbench (NCCB-9185)
  //purposely break styling in Workbench when dragging, since we never get the
  //dragleave event to remove the styling
  var DROP_TARGET_CLASS = isWb() ? 'wbDropTarget' : 'dropTarget';

  /**
   * Get the outermost property sheet DOM.
   *
   * @inner
   * @param {JQuery} dom
   * @returns {JQuery}
   */
  function getRootSheet(dom) {
    var result = dom.parents('.PropertySheet').last();
    return result.length ? result : dom;
  }

  /**
   * Remove all CSS visual drop cues by climbing up to the root property sheet
   * (if we are nested) and wiping all drag/drop associated CSS classes.
   *
   * @inner
   * @param {JQuery} dom
   */
  function clearAllDrops(dom) {
    getRootSheet(dom).find('.PropertySheetRow.drop').removeClass('above').removeClass('below').removeClass('drop');
  }

  /**
   * When applied to a `PropertySheetRow`, enable drag/drop onto that row to
   * allow adding slots directly to the `Component` loaded in that row.
   *
   * @private
   * @exports nmodule/webEditors/rc/wb/mixin/PropertySheetRowDragSupport
   * @mixin
   */
  var exports = {
    //TODO: confirm that this is proper behavior. Workbench allows drop even if readonly. see NCCB-6747
    /**
     * Return true if this row is a valid drop target.
     *
     * @private
     * @returns {Boolean}
     */
    $isDroppable: function $isDroppable() {
      return this.isEnabled() && !this.isReadonly() && canAddSlot(this.value());
    },
    /**
     * Return true if this row is ready to receive a drop event at this moment
     * (e.g. the user is currently dragged over the slot name).
     *
     * @private
     * @returns {*}
     */
    $canDropNow: function $canDropNow() {
      return this.jq().hasClass(DROP_TARGET_CLASS);
    },
    /**
     * Arm event handlers that will add a slot to the value loaded into this
     * row if valid data is dropped onto it.
     *
     * @private
     * @param {JQuery} dom
     */
    $initializeDrag: function $initializeDrag(dom) {
      var that = this;
      dom.on('dragleave dragend', function () {
        dom.removeClass(DROP_TARGET_CLASS);
      });
      dom.on('dragenter dragover', '.col-display .link', function (e) {
        if (that.$isDroppable()) {
          clearAllDrops(dom);
          dom.addClass(DROP_TARGET_CLASS);
          return false;
        }
      });
      dom.on('drop', '.col-display .link', function (e) {
        //TODO: multiple nodes
        if (that.$isDroppable()) {
          fromClipboard(e.originalEvent.dataTransfer).then(function (envelope) {
            return Promise.all([envelope.toJson(), envelope.toValues()]);
          }).then(function (_ref) {
            var _ref2 = _slicedToArray(_ref, 2),
              json = _ref2[0],
              values = _ref2[1];
            return new AddSlotCommand(that.value(), {
              undoable: true
            }).invoke({
              bulkValues: values,
              names: _.map(json, 'name')
            });
          })["catch"](feDialogs.error)["finally"](function () {
            dom.removeClass(DROP_TARGET_CLASS);
          });
          return false;
        }
      });
    }
  };
  var addDragSupport = function addDragSupport(target) {
    if (!applyMixin(target, MIXIN_NAME, exports)) {
      return;
    }
    var _doInitialize = target.doInitialize;
    target.doInitialize = function (dom) {
      var that = this;
      return Promise.resolve(_doInitialize.apply(that, arguments)).then(function () {
        return that.$initializeDrag(dom);
      });
    };
  };
  return addDragSupport;
});
