/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 */

/**
 * @module nmodule/webEditors/rc/wb/mgr/model/columns/PathMgrColumn
 */

define(['baja!', 'lex!webEditors', 'underscore', 'nmodule/webEditors/rc/wb/table/model/Column', 'nmodule/webEditors/rc/wb/mgr/model/MgrColumn', 'nmodule/webEditors/rc/fe/baja/util/typeUtils'], function (baja, lexs, _, Column, MgrColumn, typeUtils) {
  'use strict';

  var webEditorsLex = lexs[0];

  /**
   * API Status: **Development**
   *
   * Manager column used to display the slot path of a BComponent within
   * the station. This type is equivalent to the MgrColumn.Path class
   * in the bajaui abstract manager framework.
   *
   * @class
   * @alias module:nmodule/webEditors/rc/wb/mgr/model/columns/PathMgrColumn
   * @extends module:nmodule/webEditors/rc/wb/table/model/Column
   */
  var PathMgrColumn = function PathMgrColumn(params) {
    Column.call(this, '__path', _.defaults({
      displayName: webEditorsLex.get('manager.column.path')
    }, params || {}));
  };
  PathMgrColumn.prototype = Object.create(Column.prototype);
  MgrColumn.mixin(PathMgrColumn);

  /**
   * Gets the value of the row as an unescaped slot path string. The row's
   * subject must be a `Component`, otherwise an Error will be thrown. In the
   * case of an unmounted component, an empty string will be returned.
   *
   * @param {module:nmodule/webEditors/rc/wb/table/model/Row} row A row
   * representing a Component in a manager view.
   * @returns {String}
   */
  PathMgrColumn.prototype.getValueFor = function (row) {
    var comp = row.getSubject();
    if (!typeUtils.isComponent(comp)) {
      throw new Error('Component required');
    }
    if (!comp.isMounted()) {
      return '';
    }
    return baja.SlotPath.unescape(comp.getSlotPath().getBody());
  };
  return PathMgrColumn;
});
