function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2022 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/mgr/commands/ShowExistingCommand
 */
define(['baja!', 'lex!webEditors', 'dialogs', 'Promise', 'underscore', 'bajaux/commands/Command'], function (baja, lexs, dialogs, Promise, _, Command) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    webEditorsLex = _lexs[0];

  /**
   * Command for showing the existing slot path of the matching database row
   *
   * @class
   * @extends module:bajaux/commands/Command
   * @alias module:nmodule/webEditors/rc/wb/mgr/commands/ShowExistingCommand
   * @param {String} slotPath the slotPath string value that was returned from getSlotPath
   */
  var ShowExistingCommand = function ShowExistingCommand(slotPath) {
    Command.call(this, {
      module: 'webEditors',
      lex: 'commands.mgr.showExisting',
      enabled: !!slotPath,
      // no flags configured, because ShowExistingCommand is injected by MgrLearn itself

      /**
       * When this command is invoked, if there is an associated main table row, it's slot path should
       *  be shown in a dialog box
       *
       * @alias module:nmodule/webEditors/rc/wb/mgr/commands/ShowExistingCommand#invoke
       * @returns {Promise}
       */
      func: function func() {
        return dialogs.showOk({
          title: webEditorsLex.get('commands.mgr.showExisting.displayName'),
          text: slotPath
        });
      }
    });
  };
  ShowExistingCommand.prototype = Object.create(Command.prototype);
  ShowExistingCommand.prototype.constructor = ShowExistingCommand;

  /**
   * Returns the slotPath of the database row of selected discovered row, or undefined if
   *  there is not an associated database row with a slot path
   * @param manager
   * @returns {Promise<String|undefined>}
   */
  function getSlotPath(manager) {
    var learnTable = manager.getLearnTable();
    if (learnTable) {
      var selectedRows = learnTable.getSelectedRows();
      if (selectedRows.length === 1) {
        return manager.getExisting(selectedRows[0].getSubject()).then(function (comp) {
          return baja.hasType(comp, 'baja:Component') && comp.getSlotPath().getBody();
        });
      }
    }
    return Promise.resolve();
  }

  /**
   * Creates an instance of 'ShowExistingCommand'.  The resolved instance, when invoked will
   *  show the slot path of the database row that is attached to the current selected discovered
   *  row, if one exist, in a dialog box.
   *
   * @param {module:nmodule/webEditors/rc/wb/mgr/MgrLearn} manager any manager with MgrLearn mixin
   *  applied to it that the ShowExistingCommand will be attached to.
   * @returns {Promise<module:nmodule/webEditors/rc/wb/mgr/commands/ShowExistingCommand>}
   */
  ShowExistingCommand.make = function (manager) {
    return getSlotPath(manager).then(function (slotpath) {
      return new ShowExistingCommand(slotpath);
    });
  };
  return ShowExistingCommand;
});
